# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from ... import core as _core
from ... import meta as _meta

__all__ = [
    'CSIDriverSpecPatchArgs',
    'CSIDriverSpecPatchArgsDict',
    'CSIDriverSpecArgs',
    'CSIDriverSpecArgsDict',
    'CSIDriverArgs',
    'CSIDriverArgsDict',
    'CSINodeDriverPatchArgs',
    'CSINodeDriverPatchArgsDict',
    'CSINodeDriverArgs',
    'CSINodeDriverArgsDict',
    'CSINodeSpecPatchArgs',
    'CSINodeSpecPatchArgsDict',
    'CSINodeSpecArgs',
    'CSINodeSpecArgsDict',
    'CSINodeArgs',
    'CSINodeArgsDict',
    'CSIStorageCapacityArgs',
    'CSIStorageCapacityArgsDict',
    'StorageClassArgs',
    'StorageClassArgsDict',
    'TokenRequestPatchArgs',
    'TokenRequestPatchArgsDict',
    'TokenRequestArgs',
    'TokenRequestArgsDict',
    'VolumeAttachmentSourcePatchArgs',
    'VolumeAttachmentSourcePatchArgsDict',
    'VolumeAttachmentSourceArgs',
    'VolumeAttachmentSourceArgsDict',
    'VolumeAttachmentSpecPatchArgs',
    'VolumeAttachmentSpecPatchArgsDict',
    'VolumeAttachmentSpecArgs',
    'VolumeAttachmentSpecArgsDict',
    'VolumeAttachmentStatusArgs',
    'VolumeAttachmentStatusArgsDict',
    'VolumeAttachmentArgs',
    'VolumeAttachmentArgsDict',
    'VolumeErrorArgs',
    'VolumeErrorArgsDict',
    'VolumeNodeResourcesPatchArgs',
    'VolumeNodeResourcesPatchArgsDict',
    'VolumeNodeResourcesArgs',
    'VolumeNodeResourcesArgsDict',
]

MYPY = False

if not MYPY:
    class CSIDriverSpecPatchArgsDict(TypedDict):
        """
        CSIDriverSpec is the specification of a CSIDriver.
        """
        attach_required: NotRequired[pulumi.Input[_builtins.bool]]
        """
        attachRequired indicates this CSI volume driver requires an attach operation (because it implements the CSI ControllerPublishVolume() method), and that the Kubernetes attach detach controller should call the attach volume interface which checks the volumeattachment status and waits until the volume is attached before proceeding to mounting. The CSI external-attacher coordinates with CSI volume driver and updates the volumeattachment status when the attach operation is complete. If the CSIDriverRegistry feature gate is enabled and the value is specified to false, the attach operation will be skipped. Otherwise the attach operation will be called.

        This field is immutable.
        """
        fs_group_policy: NotRequired[pulumi.Input[_builtins.str]]
        """
        fsGroupPolicy defines if the underlying volume supports changing ownership and permission of the volume before being mounted. Refer to the specific FSGroupPolicy values for additional details.

        This field was immutable in Kubernetes < 1.29 and now is mutable.

        Defaults to ReadWriteOnceWithFSType, which will examine each volume to determine if Kubernetes should modify ownership and permissions of the volume. With the default policy the defined fsGroup will only be applied if a fstype is defined and the volume's access mode contains ReadWriteOnce.
        """
        node_allocatable_update_period_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        nodeAllocatableUpdatePeriodSeconds specifies the interval between periodic updates of the CSINode allocatable capacity for this driver. When set, both periodic updates and updates triggered by capacity-related failures are enabled. If not set, no updates occur (neither periodic nor upon detecting capacity-related failures), and the allocatable.count remains static. The minimum allowed value for this field is 10 seconds.

        This is an alpha feature and requires the MutableCSINodeAllocatableCount feature gate to be enabled.

        This field is mutable.
        """
        pod_info_on_mount: NotRequired[pulumi.Input[_builtins.bool]]
        """
        podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations, if set to true. If set to false, pod information will not be passed on mount. Default is false.

        The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext.

        The following VolumeContext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID) "csi.storage.k8s.io/ephemeral": "true" if the volume is an ephemeral inline volume
                                        defined by a CSIVolumeSource, otherwise "false"

        "csi.storage.k8s.io/ephemeral" is a new feature in Kubernetes 1.16. It is only required for drivers which support both the "Persistent" and "Ephemeral" VolumeLifecycleMode. Other drivers can leave pod info disabled and/or ignore this field. As Kubernetes 1.15 doesn't support this field, drivers can only support one mode when deployed on such a cluster and the deployment determines which mode that is, for example via a command line parameter of the driver.

        This field was immutable in Kubernetes < 1.29 and now is mutable.
        """
        requires_republish: NotRequired[pulumi.Input[_builtins.bool]]
        """
        requiresRepublish indicates the CSI driver wants `NodePublishVolume` being periodically called to reflect any possible change in the mounted volume. This field defaults to false.

        Note: After a successful initial NodePublishVolume call, subsequent calls to NodePublishVolume should only update the contents of the volume. New mount points will not be seen by a running container.
        """
        se_linux_mount: NotRequired[pulumi.Input[_builtins.bool]]
        """
        seLinuxMount specifies if the CSI driver supports "-o context" mount option.

        When "true", the CSI driver must ensure that all volumes provided by this CSI driver can be mounted separately with different `-o context` options. This is typical for storage backends that provide volumes as filesystems on block devices or as independent shared volumes. Kubernetes will call NodeStage / NodePublish with "-o context=xyz" mount option when mounting a ReadWriteOncePod volume used in Pod that has explicitly set SELinux context. In the future, it may be expanded to other volume AccessModes. In any case, Kubernetes will ensure that the volume is mounted only with a single SELinux context.

        When "false", Kubernetes won't pass any special SELinux mount options to the driver. This is typical for volumes that represent subdirectories of a bigger shared filesystem.

        Default is "false".
        """
        storage_capacity: NotRequired[pulumi.Input[_builtins.bool]]
        """
        storageCapacity indicates that the CSI volume driver wants pod scheduling to consider the storage capacity that the driver deployment will report by creating CSIStorageCapacity objects with capacity information, if set to true.

        The check can be enabled immediately when deploying a driver. In that case, provisioning new volumes with late binding will pause until the driver deployment has published some suitable CSIStorageCapacity object.

        Alternatively, the driver can be deployed with the field unset or false and it can be flipped later when storage capacity information has been published.

        This field was immutable in Kubernetes <= 1.22 and now is mutable.
        """
        token_requests: NotRequired[pulumi.Input[Sequence[pulumi.Input['TokenRequestPatchArgsDict']]]]
        """
        tokenRequests indicates the CSI driver needs pods' service account tokens it is mounting volume for to do necessary authentication. Kubelet will pass the tokens in VolumeContext in the CSI NodePublishVolume calls. The CSI driver should parse and validate the following VolumeContext: "csi.storage.k8s.io/serviceAccount.tokens": {
          "<audience>": {
            "token": <token>,
            "expirationTimestamp": <expiration timestamp in RFC3339>,
          },
          ...
        }

        Note: Audience in each TokenRequest should be different and at most one token is empty string. To receive a new token after expiry, RequiresRepublish can be used to trigger NodePublishVolume periodically.
        """
        volume_lifecycle_modes: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        volumeLifecycleModes defines what kind of volumes this CSI volume driver supports. The default if the list is empty is "Persistent", which is the usage defined by the CSI specification and implemented in Kubernetes via the usual PV/PVC mechanism.

        The other mode is "Ephemeral". In this mode, volumes are defined inline inside the pod spec with CSIVolumeSource and their lifecycle is tied to the lifecycle of that pod. A driver has to be aware of this because it is only going to get a NodePublishVolume call for such a volume.

        For more information about implementing this mode, see https://kubernetes-csi.github.io/docs/ephemeral-local-volumes.html A driver can support one or more of these modes and more modes may be added in the future.

        This field is beta. This field is immutable.
        """
elif False:
    CSIDriverSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CSIDriverSpecPatchArgs:
    def __init__(__self__, *,
                 attach_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 fs_group_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 node_allocatable_update_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 pod_info_on_mount: Optional[pulumi.Input[_builtins.bool]] = None,
                 requires_republish: Optional[pulumi.Input[_builtins.bool]] = None,
                 se_linux_mount: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_capacity: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_requests: Optional[pulumi.Input[Sequence[pulumi.Input['TokenRequestPatchArgs']]]] = None,
                 volume_lifecycle_modes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        CSIDriverSpec is the specification of a CSIDriver.
        :param pulumi.Input[_builtins.bool] attach_required: attachRequired indicates this CSI volume driver requires an attach operation (because it implements the CSI ControllerPublishVolume() method), and that the Kubernetes attach detach controller should call the attach volume interface which checks the volumeattachment status and waits until the volume is attached before proceeding to mounting. The CSI external-attacher coordinates with CSI volume driver and updates the volumeattachment status when the attach operation is complete. If the CSIDriverRegistry feature gate is enabled and the value is specified to false, the attach operation will be skipped. Otherwise the attach operation will be called.
               
               This field is immutable.
        :param pulumi.Input[_builtins.str] fs_group_policy: fsGroupPolicy defines if the underlying volume supports changing ownership and permission of the volume before being mounted. Refer to the specific FSGroupPolicy values for additional details.
               
               This field was immutable in Kubernetes < 1.29 and now is mutable.
               
               Defaults to ReadWriteOnceWithFSType, which will examine each volume to determine if Kubernetes should modify ownership and permissions of the volume. With the default policy the defined fsGroup will only be applied if a fstype is defined and the volume's access mode contains ReadWriteOnce.
        :param pulumi.Input[_builtins.int] node_allocatable_update_period_seconds: nodeAllocatableUpdatePeriodSeconds specifies the interval between periodic updates of the CSINode allocatable capacity for this driver. When set, both periodic updates and updates triggered by capacity-related failures are enabled. If not set, no updates occur (neither periodic nor upon detecting capacity-related failures), and the allocatable.count remains static. The minimum allowed value for this field is 10 seconds.
               
               This is an alpha feature and requires the MutableCSINodeAllocatableCount feature gate to be enabled.
               
               This field is mutable.
        :param pulumi.Input[_builtins.bool] pod_info_on_mount: podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations, if set to true. If set to false, pod information will not be passed on mount. Default is false.
               
               The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext.
               
               The following VolumeContext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID) "csi.storage.k8s.io/ephemeral": "true" if the volume is an ephemeral inline volume
                                               defined by a CSIVolumeSource, otherwise "false"
               
               "csi.storage.k8s.io/ephemeral" is a new feature in Kubernetes 1.16. It is only required for drivers which support both the "Persistent" and "Ephemeral" VolumeLifecycleMode. Other drivers can leave pod info disabled and/or ignore this field. As Kubernetes 1.15 doesn't support this field, drivers can only support one mode when deployed on such a cluster and the deployment determines which mode that is, for example via a command line parameter of the driver.
               
               This field was immutable in Kubernetes < 1.29 and now is mutable.
        :param pulumi.Input[_builtins.bool] requires_republish: requiresRepublish indicates the CSI driver wants `NodePublishVolume` being periodically called to reflect any possible change in the mounted volume. This field defaults to false.
               
               Note: After a successful initial NodePublishVolume call, subsequent calls to NodePublishVolume should only update the contents of the volume. New mount points will not be seen by a running container.
        :param pulumi.Input[_builtins.bool] se_linux_mount: seLinuxMount specifies if the CSI driver supports "-o context" mount option.
               
               When "true", the CSI driver must ensure that all volumes provided by this CSI driver can be mounted separately with different `-o context` options. This is typical for storage backends that provide volumes as filesystems on block devices or as independent shared volumes. Kubernetes will call NodeStage / NodePublish with "-o context=xyz" mount option when mounting a ReadWriteOncePod volume used in Pod that has explicitly set SELinux context. In the future, it may be expanded to other volume AccessModes. In any case, Kubernetes will ensure that the volume is mounted only with a single SELinux context.
               
               When "false", Kubernetes won't pass any special SELinux mount options to the driver. This is typical for volumes that represent subdirectories of a bigger shared filesystem.
               
               Default is "false".
        :param pulumi.Input[_builtins.bool] storage_capacity: storageCapacity indicates that the CSI volume driver wants pod scheduling to consider the storage capacity that the driver deployment will report by creating CSIStorageCapacity objects with capacity information, if set to true.
               
               The check can be enabled immediately when deploying a driver. In that case, provisioning new volumes with late binding will pause until the driver deployment has published some suitable CSIStorageCapacity object.
               
               Alternatively, the driver can be deployed with the field unset or false and it can be flipped later when storage capacity information has been published.
               
               This field was immutable in Kubernetes <= 1.22 and now is mutable.
        :param pulumi.Input[Sequence[pulumi.Input['TokenRequestPatchArgs']]] token_requests: tokenRequests indicates the CSI driver needs pods' service account tokens it is mounting volume for to do necessary authentication. Kubelet will pass the tokens in VolumeContext in the CSI NodePublishVolume calls. The CSI driver should parse and validate the following VolumeContext: "csi.storage.k8s.io/serviceAccount.tokens": {
                 "<audience>": {
                   "token": <token>,
                   "expirationTimestamp": <expiration timestamp in RFC3339>,
                 },
                 ...
               }
               
               Note: Audience in each TokenRequest should be different and at most one token is empty string. To receive a new token after expiry, RequiresRepublish can be used to trigger NodePublishVolume periodically.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] volume_lifecycle_modes: volumeLifecycleModes defines what kind of volumes this CSI volume driver supports. The default if the list is empty is "Persistent", which is the usage defined by the CSI specification and implemented in Kubernetes via the usual PV/PVC mechanism.
               
               The other mode is "Ephemeral". In this mode, volumes are defined inline inside the pod spec with CSIVolumeSource and their lifecycle is tied to the lifecycle of that pod. A driver has to be aware of this because it is only going to get a NodePublishVolume call for such a volume.
               
               For more information about implementing this mode, see https://kubernetes-csi.github.io/docs/ephemeral-local-volumes.html A driver can support one or more of these modes and more modes may be added in the future.
               
               This field is beta. This field is immutable.
        """
        if attach_required is not None:
            pulumi.set(__self__, "attach_required", attach_required)
        if fs_group_policy is not None:
            pulumi.set(__self__, "fs_group_policy", fs_group_policy)
        if node_allocatable_update_period_seconds is not None:
            pulumi.set(__self__, "node_allocatable_update_period_seconds", node_allocatable_update_period_seconds)
        if pod_info_on_mount is not None:
            pulumi.set(__self__, "pod_info_on_mount", pod_info_on_mount)
        if requires_republish is not None:
            pulumi.set(__self__, "requires_republish", requires_republish)
        if se_linux_mount is not None:
            pulumi.set(__self__, "se_linux_mount", se_linux_mount)
        if storage_capacity is not None:
            pulumi.set(__self__, "storage_capacity", storage_capacity)
        if token_requests is not None:
            pulumi.set(__self__, "token_requests", token_requests)
        if volume_lifecycle_modes is not None:
            pulumi.set(__self__, "volume_lifecycle_modes", volume_lifecycle_modes)

    @_builtins.property
    @pulumi.getter(name="attachRequired")
    def attach_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        attachRequired indicates this CSI volume driver requires an attach operation (because it implements the CSI ControllerPublishVolume() method), and that the Kubernetes attach detach controller should call the attach volume interface which checks the volumeattachment status and waits until the volume is attached before proceeding to mounting. The CSI external-attacher coordinates with CSI volume driver and updates the volumeattachment status when the attach operation is complete. If the CSIDriverRegistry feature gate is enabled and the value is specified to false, the attach operation will be skipped. Otherwise the attach operation will be called.

        This field is immutable.
        """
        return pulumi.get(self, "attach_required")

    @attach_required.setter
    def attach_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "attach_required", value)

    @_builtins.property
    @pulumi.getter(name="fsGroupPolicy")
    def fs_group_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        fsGroupPolicy defines if the underlying volume supports changing ownership and permission of the volume before being mounted. Refer to the specific FSGroupPolicy values for additional details.

        This field was immutable in Kubernetes < 1.29 and now is mutable.

        Defaults to ReadWriteOnceWithFSType, which will examine each volume to determine if Kubernetes should modify ownership and permissions of the volume. With the default policy the defined fsGroup will only be applied if a fstype is defined and the volume's access mode contains ReadWriteOnce.
        """
        return pulumi.get(self, "fs_group_policy")

    @fs_group_policy.setter
    def fs_group_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fs_group_policy", value)

    @_builtins.property
    @pulumi.getter(name="nodeAllocatableUpdatePeriodSeconds")
    def node_allocatable_update_period_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        nodeAllocatableUpdatePeriodSeconds specifies the interval between periodic updates of the CSINode allocatable capacity for this driver. When set, both periodic updates and updates triggered by capacity-related failures are enabled. If not set, no updates occur (neither periodic nor upon detecting capacity-related failures), and the allocatable.count remains static. The minimum allowed value for this field is 10 seconds.

        This is an alpha feature and requires the MutableCSINodeAllocatableCount feature gate to be enabled.

        This field is mutable.
        """
        return pulumi.get(self, "node_allocatable_update_period_seconds")

    @node_allocatable_update_period_seconds.setter
    def node_allocatable_update_period_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_allocatable_update_period_seconds", value)

    @_builtins.property
    @pulumi.getter(name="podInfoOnMount")
    def pod_info_on_mount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations, if set to true. If set to false, pod information will not be passed on mount. Default is false.

        The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext.

        The following VolumeContext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID) "csi.storage.k8s.io/ephemeral": "true" if the volume is an ephemeral inline volume
                                        defined by a CSIVolumeSource, otherwise "false"

        "csi.storage.k8s.io/ephemeral" is a new feature in Kubernetes 1.16. It is only required for drivers which support both the "Persistent" and "Ephemeral" VolumeLifecycleMode. Other drivers can leave pod info disabled and/or ignore this field. As Kubernetes 1.15 doesn't support this field, drivers can only support one mode when deployed on such a cluster and the deployment determines which mode that is, for example via a command line parameter of the driver.

        This field was immutable in Kubernetes < 1.29 and now is mutable.
        """
        return pulumi.get(self, "pod_info_on_mount")

    @pod_info_on_mount.setter
    def pod_info_on_mount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pod_info_on_mount", value)

    @_builtins.property
    @pulumi.getter(name="requiresRepublish")
    def requires_republish(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        requiresRepublish indicates the CSI driver wants `NodePublishVolume` being periodically called to reflect any possible change in the mounted volume. This field defaults to false.

        Note: After a successful initial NodePublishVolume call, subsequent calls to NodePublishVolume should only update the contents of the volume. New mount points will not be seen by a running container.
        """
        return pulumi.get(self, "requires_republish")

    @requires_republish.setter
    def requires_republish(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "requires_republish", value)

    @_builtins.property
    @pulumi.getter(name="seLinuxMount")
    def se_linux_mount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        seLinuxMount specifies if the CSI driver supports "-o context" mount option.

        When "true", the CSI driver must ensure that all volumes provided by this CSI driver can be mounted separately with different `-o context` options. This is typical for storage backends that provide volumes as filesystems on block devices or as independent shared volumes. Kubernetes will call NodeStage / NodePublish with "-o context=xyz" mount option when mounting a ReadWriteOncePod volume used in Pod that has explicitly set SELinux context. In the future, it may be expanded to other volume AccessModes. In any case, Kubernetes will ensure that the volume is mounted only with a single SELinux context.

        When "false", Kubernetes won't pass any special SELinux mount options to the driver. This is typical for volumes that represent subdirectories of a bigger shared filesystem.

        Default is "false".
        """
        return pulumi.get(self, "se_linux_mount")

    @se_linux_mount.setter
    def se_linux_mount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "se_linux_mount", value)

    @_builtins.property
    @pulumi.getter(name="storageCapacity")
    def storage_capacity(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        storageCapacity indicates that the CSI volume driver wants pod scheduling to consider the storage capacity that the driver deployment will report by creating CSIStorageCapacity objects with capacity information, if set to true.

        The check can be enabled immediately when deploying a driver. In that case, provisioning new volumes with late binding will pause until the driver deployment has published some suitable CSIStorageCapacity object.

        Alternatively, the driver can be deployed with the field unset or false and it can be flipped later when storage capacity information has been published.

        This field was immutable in Kubernetes <= 1.22 and now is mutable.
        """
        return pulumi.get(self, "storage_capacity")

    @storage_capacity.setter
    def storage_capacity(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "storage_capacity", value)

    @_builtins.property
    @pulumi.getter(name="tokenRequests")
    def token_requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TokenRequestPatchArgs']]]]:
        """
        tokenRequests indicates the CSI driver needs pods' service account tokens it is mounting volume for to do necessary authentication. Kubelet will pass the tokens in VolumeContext in the CSI NodePublishVolume calls. The CSI driver should parse and validate the following VolumeContext: "csi.storage.k8s.io/serviceAccount.tokens": {
          "<audience>": {
            "token": <token>,
            "expirationTimestamp": <expiration timestamp in RFC3339>,
          },
          ...
        }

        Note: Audience in each TokenRequest should be different and at most one token is empty string. To receive a new token after expiry, RequiresRepublish can be used to trigger NodePublishVolume periodically.
        """
        return pulumi.get(self, "token_requests")

    @token_requests.setter
    def token_requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TokenRequestPatchArgs']]]]):
        pulumi.set(self, "token_requests", value)

    @_builtins.property
    @pulumi.getter(name="volumeLifecycleModes")
    def volume_lifecycle_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        volumeLifecycleModes defines what kind of volumes this CSI volume driver supports. The default if the list is empty is "Persistent", which is the usage defined by the CSI specification and implemented in Kubernetes via the usual PV/PVC mechanism.

        The other mode is "Ephemeral". In this mode, volumes are defined inline inside the pod spec with CSIVolumeSource and their lifecycle is tied to the lifecycle of that pod. A driver has to be aware of this because it is only going to get a NodePublishVolume call for such a volume.

        For more information about implementing this mode, see https://kubernetes-csi.github.io/docs/ephemeral-local-volumes.html A driver can support one or more of these modes and more modes may be added in the future.

        This field is beta. This field is immutable.
        """
        return pulumi.get(self, "volume_lifecycle_modes")

    @volume_lifecycle_modes.setter
    def volume_lifecycle_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "volume_lifecycle_modes", value)


if not MYPY:
    class CSIDriverSpecArgsDict(TypedDict):
        """
        CSIDriverSpec is the specification of a CSIDriver.
        """
        attach_required: NotRequired[pulumi.Input[_builtins.bool]]
        """
        attachRequired indicates this CSI volume driver requires an attach operation (because it implements the CSI ControllerPublishVolume() method), and that the Kubernetes attach detach controller should call the attach volume interface which checks the volumeattachment status and waits until the volume is attached before proceeding to mounting. The CSI external-attacher coordinates with CSI volume driver and updates the volumeattachment status when the attach operation is complete. If the CSIDriverRegistry feature gate is enabled and the value is specified to false, the attach operation will be skipped. Otherwise the attach operation will be called.

        This field is immutable.
        """
        fs_group_policy: NotRequired[pulumi.Input[_builtins.str]]
        """
        fsGroupPolicy defines if the underlying volume supports changing ownership and permission of the volume before being mounted. Refer to the specific FSGroupPolicy values for additional details.

        This field was immutable in Kubernetes < 1.29 and now is mutable.

        Defaults to ReadWriteOnceWithFSType, which will examine each volume to determine if Kubernetes should modify ownership and permissions of the volume. With the default policy the defined fsGroup will only be applied if a fstype is defined and the volume's access mode contains ReadWriteOnce.
        """
        node_allocatable_update_period_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        nodeAllocatableUpdatePeriodSeconds specifies the interval between periodic updates of the CSINode allocatable capacity for this driver. When set, both periodic updates and updates triggered by capacity-related failures are enabled. If not set, no updates occur (neither periodic nor upon detecting capacity-related failures), and the allocatable.count remains static. The minimum allowed value for this field is 10 seconds.

        This is an alpha feature and requires the MutableCSINodeAllocatableCount feature gate to be enabled.

        This field is mutable.
        """
        pod_info_on_mount: NotRequired[pulumi.Input[_builtins.bool]]
        """
        podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations, if set to true. If set to false, pod information will not be passed on mount. Default is false.

        The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext.

        The following VolumeContext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID) "csi.storage.k8s.io/ephemeral": "true" if the volume is an ephemeral inline volume
                                        defined by a CSIVolumeSource, otherwise "false"

        "csi.storage.k8s.io/ephemeral" is a new feature in Kubernetes 1.16. It is only required for drivers which support both the "Persistent" and "Ephemeral" VolumeLifecycleMode. Other drivers can leave pod info disabled and/or ignore this field. As Kubernetes 1.15 doesn't support this field, drivers can only support one mode when deployed on such a cluster and the deployment determines which mode that is, for example via a command line parameter of the driver.

        This field was immutable in Kubernetes < 1.29 and now is mutable.
        """
        requires_republish: NotRequired[pulumi.Input[_builtins.bool]]
        """
        requiresRepublish indicates the CSI driver wants `NodePublishVolume` being periodically called to reflect any possible change in the mounted volume. This field defaults to false.

        Note: After a successful initial NodePublishVolume call, subsequent calls to NodePublishVolume should only update the contents of the volume. New mount points will not be seen by a running container.
        """
        se_linux_mount: NotRequired[pulumi.Input[_builtins.bool]]
        """
        seLinuxMount specifies if the CSI driver supports "-o context" mount option.

        When "true", the CSI driver must ensure that all volumes provided by this CSI driver can be mounted separately with different `-o context` options. This is typical for storage backends that provide volumes as filesystems on block devices or as independent shared volumes. Kubernetes will call NodeStage / NodePublish with "-o context=xyz" mount option when mounting a ReadWriteOncePod volume used in Pod that has explicitly set SELinux context. In the future, it may be expanded to other volume AccessModes. In any case, Kubernetes will ensure that the volume is mounted only with a single SELinux context.

        When "false", Kubernetes won't pass any special SELinux mount options to the driver. This is typical for volumes that represent subdirectories of a bigger shared filesystem.

        Default is "false".
        """
        storage_capacity: NotRequired[pulumi.Input[_builtins.bool]]
        """
        storageCapacity indicates that the CSI volume driver wants pod scheduling to consider the storage capacity that the driver deployment will report by creating CSIStorageCapacity objects with capacity information, if set to true.

        The check can be enabled immediately when deploying a driver. In that case, provisioning new volumes with late binding will pause until the driver deployment has published some suitable CSIStorageCapacity object.

        Alternatively, the driver can be deployed with the field unset or false and it can be flipped later when storage capacity information has been published.

        This field was immutable in Kubernetes <= 1.22 and now is mutable.
        """
        token_requests: NotRequired[pulumi.Input[Sequence[pulumi.Input['TokenRequestArgsDict']]]]
        """
        tokenRequests indicates the CSI driver needs pods' service account tokens it is mounting volume for to do necessary authentication. Kubelet will pass the tokens in VolumeContext in the CSI NodePublishVolume calls. The CSI driver should parse and validate the following VolumeContext: "csi.storage.k8s.io/serviceAccount.tokens": {
          "<audience>": {
            "token": <token>,
            "expirationTimestamp": <expiration timestamp in RFC3339>,
          },
          ...
        }

        Note: Audience in each TokenRequest should be different and at most one token is empty string. To receive a new token after expiry, RequiresRepublish can be used to trigger NodePublishVolume periodically.
        """
        volume_lifecycle_modes: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        volumeLifecycleModes defines what kind of volumes this CSI volume driver supports. The default if the list is empty is "Persistent", which is the usage defined by the CSI specification and implemented in Kubernetes via the usual PV/PVC mechanism.

        The other mode is "Ephemeral". In this mode, volumes are defined inline inside the pod spec with CSIVolumeSource and their lifecycle is tied to the lifecycle of that pod. A driver has to be aware of this because it is only going to get a NodePublishVolume call for such a volume.

        For more information about implementing this mode, see https://kubernetes-csi.github.io/docs/ephemeral-local-volumes.html A driver can support one or more of these modes and more modes may be added in the future.

        This field is beta. This field is immutable.
        """
elif False:
    CSIDriverSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CSIDriverSpecArgs:
    def __init__(__self__, *,
                 attach_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 fs_group_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 node_allocatable_update_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 pod_info_on_mount: Optional[pulumi.Input[_builtins.bool]] = None,
                 requires_republish: Optional[pulumi.Input[_builtins.bool]] = None,
                 se_linux_mount: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_capacity: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_requests: Optional[pulumi.Input[Sequence[pulumi.Input['TokenRequestArgs']]]] = None,
                 volume_lifecycle_modes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        CSIDriverSpec is the specification of a CSIDriver.
        :param pulumi.Input[_builtins.bool] attach_required: attachRequired indicates this CSI volume driver requires an attach operation (because it implements the CSI ControllerPublishVolume() method), and that the Kubernetes attach detach controller should call the attach volume interface which checks the volumeattachment status and waits until the volume is attached before proceeding to mounting. The CSI external-attacher coordinates with CSI volume driver and updates the volumeattachment status when the attach operation is complete. If the CSIDriverRegistry feature gate is enabled and the value is specified to false, the attach operation will be skipped. Otherwise the attach operation will be called.
               
               This field is immutable.
        :param pulumi.Input[_builtins.str] fs_group_policy: fsGroupPolicy defines if the underlying volume supports changing ownership and permission of the volume before being mounted. Refer to the specific FSGroupPolicy values for additional details.
               
               This field was immutable in Kubernetes < 1.29 and now is mutable.
               
               Defaults to ReadWriteOnceWithFSType, which will examine each volume to determine if Kubernetes should modify ownership and permissions of the volume. With the default policy the defined fsGroup will only be applied if a fstype is defined and the volume's access mode contains ReadWriteOnce.
        :param pulumi.Input[_builtins.int] node_allocatable_update_period_seconds: nodeAllocatableUpdatePeriodSeconds specifies the interval between periodic updates of the CSINode allocatable capacity for this driver. When set, both periodic updates and updates triggered by capacity-related failures are enabled. If not set, no updates occur (neither periodic nor upon detecting capacity-related failures), and the allocatable.count remains static. The minimum allowed value for this field is 10 seconds.
               
               This is an alpha feature and requires the MutableCSINodeAllocatableCount feature gate to be enabled.
               
               This field is mutable.
        :param pulumi.Input[_builtins.bool] pod_info_on_mount: podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations, if set to true. If set to false, pod information will not be passed on mount. Default is false.
               
               The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext.
               
               The following VolumeContext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID) "csi.storage.k8s.io/ephemeral": "true" if the volume is an ephemeral inline volume
                                               defined by a CSIVolumeSource, otherwise "false"
               
               "csi.storage.k8s.io/ephemeral" is a new feature in Kubernetes 1.16. It is only required for drivers which support both the "Persistent" and "Ephemeral" VolumeLifecycleMode. Other drivers can leave pod info disabled and/or ignore this field. As Kubernetes 1.15 doesn't support this field, drivers can only support one mode when deployed on such a cluster and the deployment determines which mode that is, for example via a command line parameter of the driver.
               
               This field was immutable in Kubernetes < 1.29 and now is mutable.
        :param pulumi.Input[_builtins.bool] requires_republish: requiresRepublish indicates the CSI driver wants `NodePublishVolume` being periodically called to reflect any possible change in the mounted volume. This field defaults to false.
               
               Note: After a successful initial NodePublishVolume call, subsequent calls to NodePublishVolume should only update the contents of the volume. New mount points will not be seen by a running container.
        :param pulumi.Input[_builtins.bool] se_linux_mount: seLinuxMount specifies if the CSI driver supports "-o context" mount option.
               
               When "true", the CSI driver must ensure that all volumes provided by this CSI driver can be mounted separately with different `-o context` options. This is typical for storage backends that provide volumes as filesystems on block devices or as independent shared volumes. Kubernetes will call NodeStage / NodePublish with "-o context=xyz" mount option when mounting a ReadWriteOncePod volume used in Pod that has explicitly set SELinux context. In the future, it may be expanded to other volume AccessModes. In any case, Kubernetes will ensure that the volume is mounted only with a single SELinux context.
               
               When "false", Kubernetes won't pass any special SELinux mount options to the driver. This is typical for volumes that represent subdirectories of a bigger shared filesystem.
               
               Default is "false".
        :param pulumi.Input[_builtins.bool] storage_capacity: storageCapacity indicates that the CSI volume driver wants pod scheduling to consider the storage capacity that the driver deployment will report by creating CSIStorageCapacity objects with capacity information, if set to true.
               
               The check can be enabled immediately when deploying a driver. In that case, provisioning new volumes with late binding will pause until the driver deployment has published some suitable CSIStorageCapacity object.
               
               Alternatively, the driver can be deployed with the field unset or false and it can be flipped later when storage capacity information has been published.
               
               This field was immutable in Kubernetes <= 1.22 and now is mutable.
        :param pulumi.Input[Sequence[pulumi.Input['TokenRequestArgs']]] token_requests: tokenRequests indicates the CSI driver needs pods' service account tokens it is mounting volume for to do necessary authentication. Kubelet will pass the tokens in VolumeContext in the CSI NodePublishVolume calls. The CSI driver should parse and validate the following VolumeContext: "csi.storage.k8s.io/serviceAccount.tokens": {
                 "<audience>": {
                   "token": <token>,
                   "expirationTimestamp": <expiration timestamp in RFC3339>,
                 },
                 ...
               }
               
               Note: Audience in each TokenRequest should be different and at most one token is empty string. To receive a new token after expiry, RequiresRepublish can be used to trigger NodePublishVolume periodically.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] volume_lifecycle_modes: volumeLifecycleModes defines what kind of volumes this CSI volume driver supports. The default if the list is empty is "Persistent", which is the usage defined by the CSI specification and implemented in Kubernetes via the usual PV/PVC mechanism.
               
               The other mode is "Ephemeral". In this mode, volumes are defined inline inside the pod spec with CSIVolumeSource and their lifecycle is tied to the lifecycle of that pod. A driver has to be aware of this because it is only going to get a NodePublishVolume call for such a volume.
               
               For more information about implementing this mode, see https://kubernetes-csi.github.io/docs/ephemeral-local-volumes.html A driver can support one or more of these modes and more modes may be added in the future.
               
               This field is beta. This field is immutable.
        """
        if attach_required is not None:
            pulumi.set(__self__, "attach_required", attach_required)
        if fs_group_policy is not None:
            pulumi.set(__self__, "fs_group_policy", fs_group_policy)
        if node_allocatable_update_period_seconds is not None:
            pulumi.set(__self__, "node_allocatable_update_period_seconds", node_allocatable_update_period_seconds)
        if pod_info_on_mount is not None:
            pulumi.set(__self__, "pod_info_on_mount", pod_info_on_mount)
        if requires_republish is not None:
            pulumi.set(__self__, "requires_republish", requires_republish)
        if se_linux_mount is not None:
            pulumi.set(__self__, "se_linux_mount", se_linux_mount)
        if storage_capacity is not None:
            pulumi.set(__self__, "storage_capacity", storage_capacity)
        if token_requests is not None:
            pulumi.set(__self__, "token_requests", token_requests)
        if volume_lifecycle_modes is not None:
            pulumi.set(__self__, "volume_lifecycle_modes", volume_lifecycle_modes)

    @_builtins.property
    @pulumi.getter(name="attachRequired")
    def attach_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        attachRequired indicates this CSI volume driver requires an attach operation (because it implements the CSI ControllerPublishVolume() method), and that the Kubernetes attach detach controller should call the attach volume interface which checks the volumeattachment status and waits until the volume is attached before proceeding to mounting. The CSI external-attacher coordinates with CSI volume driver and updates the volumeattachment status when the attach operation is complete. If the CSIDriverRegistry feature gate is enabled and the value is specified to false, the attach operation will be skipped. Otherwise the attach operation will be called.

        This field is immutable.
        """
        return pulumi.get(self, "attach_required")

    @attach_required.setter
    def attach_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "attach_required", value)

    @_builtins.property
    @pulumi.getter(name="fsGroupPolicy")
    def fs_group_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        fsGroupPolicy defines if the underlying volume supports changing ownership and permission of the volume before being mounted. Refer to the specific FSGroupPolicy values for additional details.

        This field was immutable in Kubernetes < 1.29 and now is mutable.

        Defaults to ReadWriteOnceWithFSType, which will examine each volume to determine if Kubernetes should modify ownership and permissions of the volume. With the default policy the defined fsGroup will only be applied if a fstype is defined and the volume's access mode contains ReadWriteOnce.
        """
        return pulumi.get(self, "fs_group_policy")

    @fs_group_policy.setter
    def fs_group_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fs_group_policy", value)

    @_builtins.property
    @pulumi.getter(name="nodeAllocatableUpdatePeriodSeconds")
    def node_allocatable_update_period_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        nodeAllocatableUpdatePeriodSeconds specifies the interval between periodic updates of the CSINode allocatable capacity for this driver. When set, both periodic updates and updates triggered by capacity-related failures are enabled. If not set, no updates occur (neither periodic nor upon detecting capacity-related failures), and the allocatable.count remains static. The minimum allowed value for this field is 10 seconds.

        This is an alpha feature and requires the MutableCSINodeAllocatableCount feature gate to be enabled.

        This field is mutable.
        """
        return pulumi.get(self, "node_allocatable_update_period_seconds")

    @node_allocatable_update_period_seconds.setter
    def node_allocatable_update_period_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_allocatable_update_period_seconds", value)

    @_builtins.property
    @pulumi.getter(name="podInfoOnMount")
    def pod_info_on_mount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations, if set to true. If set to false, pod information will not be passed on mount. Default is false.

        The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext.

        The following VolumeContext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID) "csi.storage.k8s.io/ephemeral": "true" if the volume is an ephemeral inline volume
                                        defined by a CSIVolumeSource, otherwise "false"

        "csi.storage.k8s.io/ephemeral" is a new feature in Kubernetes 1.16. It is only required for drivers which support both the "Persistent" and "Ephemeral" VolumeLifecycleMode. Other drivers can leave pod info disabled and/or ignore this field. As Kubernetes 1.15 doesn't support this field, drivers can only support one mode when deployed on such a cluster and the deployment determines which mode that is, for example via a command line parameter of the driver.

        This field was immutable in Kubernetes < 1.29 and now is mutable.
        """
        return pulumi.get(self, "pod_info_on_mount")

    @pod_info_on_mount.setter
    def pod_info_on_mount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pod_info_on_mount", value)

    @_builtins.property
    @pulumi.getter(name="requiresRepublish")
    def requires_republish(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        requiresRepublish indicates the CSI driver wants `NodePublishVolume` being periodically called to reflect any possible change in the mounted volume. This field defaults to false.

        Note: After a successful initial NodePublishVolume call, subsequent calls to NodePublishVolume should only update the contents of the volume. New mount points will not be seen by a running container.
        """
        return pulumi.get(self, "requires_republish")

    @requires_republish.setter
    def requires_republish(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "requires_republish", value)

    @_builtins.property
    @pulumi.getter(name="seLinuxMount")
    def se_linux_mount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        seLinuxMount specifies if the CSI driver supports "-o context" mount option.

        When "true", the CSI driver must ensure that all volumes provided by this CSI driver can be mounted separately with different `-o context` options. This is typical for storage backends that provide volumes as filesystems on block devices or as independent shared volumes. Kubernetes will call NodeStage / NodePublish with "-o context=xyz" mount option when mounting a ReadWriteOncePod volume used in Pod that has explicitly set SELinux context. In the future, it may be expanded to other volume AccessModes. In any case, Kubernetes will ensure that the volume is mounted only with a single SELinux context.

        When "false", Kubernetes won't pass any special SELinux mount options to the driver. This is typical for volumes that represent subdirectories of a bigger shared filesystem.

        Default is "false".
        """
        return pulumi.get(self, "se_linux_mount")

    @se_linux_mount.setter
    def se_linux_mount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "se_linux_mount", value)

    @_builtins.property
    @pulumi.getter(name="storageCapacity")
    def storage_capacity(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        storageCapacity indicates that the CSI volume driver wants pod scheduling to consider the storage capacity that the driver deployment will report by creating CSIStorageCapacity objects with capacity information, if set to true.

        The check can be enabled immediately when deploying a driver. In that case, provisioning new volumes with late binding will pause until the driver deployment has published some suitable CSIStorageCapacity object.

        Alternatively, the driver can be deployed with the field unset or false and it can be flipped later when storage capacity information has been published.

        This field was immutable in Kubernetes <= 1.22 and now is mutable.
        """
        return pulumi.get(self, "storage_capacity")

    @storage_capacity.setter
    def storage_capacity(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "storage_capacity", value)

    @_builtins.property
    @pulumi.getter(name="tokenRequests")
    def token_requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TokenRequestArgs']]]]:
        """
        tokenRequests indicates the CSI driver needs pods' service account tokens it is mounting volume for to do necessary authentication. Kubelet will pass the tokens in VolumeContext in the CSI NodePublishVolume calls. The CSI driver should parse and validate the following VolumeContext: "csi.storage.k8s.io/serviceAccount.tokens": {
          "<audience>": {
            "token": <token>,
            "expirationTimestamp": <expiration timestamp in RFC3339>,
          },
          ...
        }

        Note: Audience in each TokenRequest should be different and at most one token is empty string. To receive a new token after expiry, RequiresRepublish can be used to trigger NodePublishVolume periodically.
        """
        return pulumi.get(self, "token_requests")

    @token_requests.setter
    def token_requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TokenRequestArgs']]]]):
        pulumi.set(self, "token_requests", value)

    @_builtins.property
    @pulumi.getter(name="volumeLifecycleModes")
    def volume_lifecycle_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        volumeLifecycleModes defines what kind of volumes this CSI volume driver supports. The default if the list is empty is "Persistent", which is the usage defined by the CSI specification and implemented in Kubernetes via the usual PV/PVC mechanism.

        The other mode is "Ephemeral". In this mode, volumes are defined inline inside the pod spec with CSIVolumeSource and their lifecycle is tied to the lifecycle of that pod. A driver has to be aware of this because it is only going to get a NodePublishVolume call for such a volume.

        For more information about implementing this mode, see https://kubernetes-csi.github.io/docs/ephemeral-local-volumes.html A driver can support one or more of these modes and more modes may be added in the future.

        This field is beta. This field is immutable.
        """
        return pulumi.get(self, "volume_lifecycle_modes")

    @volume_lifecycle_modes.setter
    def volume_lifecycle_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "volume_lifecycle_modes", value)


if not MYPY:
    class CSIDriverArgsDict(TypedDict):
        """
        CSIDriver captures information about a Container Storage Interface (CSI) volume driver deployed on the cluster. Kubernetes attach detach controller uses this object to determine whether attach is required. Kubelet uses this object to determine whether pod information needs to be passed on mount. CSIDriver objects are non-namespaced.
        """
        spec: pulumi.Input['CSIDriverSpecArgsDict']
        """
        spec represents the specification of the CSI Driver.
        """
        api_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[_builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object metadata. metadata.Name indicates the name of the CSI driver that this object refers to; it MUST be the same name returned by the CSI GetPluginName() call for that driver. The driver name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), dots (.), and alphanumerics between. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
elif False:
    CSIDriverArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CSIDriverArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['CSIDriverSpecArgs'],
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None):
        """
        CSIDriver captures information about a Container Storage Interface (CSI) volume driver deployed on the cluster. Kubernetes attach detach controller uses this object to determine whether attach is required. Kubelet uses this object to determine whether pod information needs to be passed on mount. CSIDriver objects are non-namespaced.
        :param pulumi.Input['CSIDriverSpecArgs'] spec: spec represents the specification of the CSI Driver.
        :param pulumi.Input[_builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[_builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object metadata. metadata.Name indicates the name of the CSI driver that this object refers to; it MUST be the same name returned by the CSI GetPluginName() call for that driver. The driver name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), dots (.), and alphanumerics between. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'storage.k8s.io/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'CSIDriver')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> pulumi.Input['CSIDriverSpecArgs']:
        """
        spec represents the specification of the CSI Driver.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['CSIDriverSpecArgs']):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object metadata. metadata.Name indicates the name of the CSI driver that this object refers to; it MUST be the same name returned by the CSI GetPluginName() call for that driver. The driver name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), dots (.), and alphanumerics between. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)


if not MYPY:
    class CSINodeDriverPatchArgsDict(TypedDict):
        """
        CSINodeDriver holds information about the specification of one CSI driver installed on a node
        """
        allocatable: NotRequired[pulumi.Input['VolumeNodeResourcesPatchArgsDict']]
        """
        allocatable represents the volume resources of a node that are available for scheduling. This field is beta.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        name represents the name of the CSI driver that this object refers to. This MUST be the same name returned by the CSI GetPluginName() call for that driver.
        """
        node_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        nodeID of the node from the driver point of view. This field enables Kubernetes to communicate with storage systems that do not share the same nomenclature for nodes. For example, Kubernetes may refer to a given node as "node1", but the storage system may refer to the same node as "nodeA". When Kubernetes issues a command to the storage system to attach a volume to a specific node, it can use this field to refer to the node name using the ID that the storage system will understand, e.g. "nodeA" instead of "node1". This field is required.
        """
        topology_keys: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        topologyKeys is the list of keys supported by the driver. When a driver is initialized on a cluster, it provides a set of topology keys that it understands (e.g. "company.com/zone", "company.com/region"). When a driver is initialized on a node, it provides the same topology keys along with values. Kubelet will expose these topology keys as labels on its own node object. When Kubernetes does topology aware provisioning, it can use this list to determine which labels it should retrieve from the node object and pass back to the driver. It is possible for different nodes to use different topology keys. This can be empty if driver does not support topology.
        """
elif False:
    CSINodeDriverPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CSINodeDriverPatchArgs:
    def __init__(__self__, *,
                 allocatable: Optional[pulumi.Input['VolumeNodeResourcesPatchArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 topology_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        CSINodeDriver holds information about the specification of one CSI driver installed on a node
        :param pulumi.Input['VolumeNodeResourcesPatchArgs'] allocatable: allocatable represents the volume resources of a node that are available for scheduling. This field is beta.
        :param pulumi.Input[_builtins.str] name: name represents the name of the CSI driver that this object refers to. This MUST be the same name returned by the CSI GetPluginName() call for that driver.
        :param pulumi.Input[_builtins.str] node_id: nodeID of the node from the driver point of view. This field enables Kubernetes to communicate with storage systems that do not share the same nomenclature for nodes. For example, Kubernetes may refer to a given node as "node1", but the storage system may refer to the same node as "nodeA". When Kubernetes issues a command to the storage system to attach a volume to a specific node, it can use this field to refer to the node name using the ID that the storage system will understand, e.g. "nodeA" instead of "node1". This field is required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] topology_keys: topologyKeys is the list of keys supported by the driver. When a driver is initialized on a cluster, it provides a set of topology keys that it understands (e.g. "company.com/zone", "company.com/region"). When a driver is initialized on a node, it provides the same topology keys along with values. Kubelet will expose these topology keys as labels on its own node object. When Kubernetes does topology aware provisioning, it can use this list to determine which labels it should retrieve from the node object and pass back to the driver. It is possible for different nodes to use different topology keys. This can be empty if driver does not support topology.
        """
        if allocatable is not None:
            pulumi.set(__self__, "allocatable", allocatable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if topology_keys is not None:
            pulumi.set(__self__, "topology_keys", topology_keys)

    @_builtins.property
    @pulumi.getter
    def allocatable(self) -> Optional[pulumi.Input['VolumeNodeResourcesPatchArgs']]:
        """
        allocatable represents the volume resources of a node that are available for scheduling. This field is beta.
        """
        return pulumi.get(self, "allocatable")

    @allocatable.setter
    def allocatable(self, value: Optional[pulumi.Input['VolumeNodeResourcesPatchArgs']]):
        pulumi.set(self, "allocatable", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name represents the name of the CSI driver that this object refers to. This MUST be the same name returned by the CSI GetPluginName() call for that driver.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeID")
    def node_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        nodeID of the node from the driver point of view. This field enables Kubernetes to communicate with storage systems that do not share the same nomenclature for nodes. For example, Kubernetes may refer to a given node as "node1", but the storage system may refer to the same node as "nodeA". When Kubernetes issues a command to the storage system to attach a volume to a specific node, it can use this field to refer to the node name using the ID that the storage system will understand, e.g. "nodeA" instead of "node1". This field is required.
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_id", value)

    @_builtins.property
    @pulumi.getter(name="topologyKeys")
    def topology_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        topologyKeys is the list of keys supported by the driver. When a driver is initialized on a cluster, it provides a set of topology keys that it understands (e.g. "company.com/zone", "company.com/region"). When a driver is initialized on a node, it provides the same topology keys along with values. Kubelet will expose these topology keys as labels on its own node object. When Kubernetes does topology aware provisioning, it can use this list to determine which labels it should retrieve from the node object and pass back to the driver. It is possible for different nodes to use different topology keys. This can be empty if driver does not support topology.
        """
        return pulumi.get(self, "topology_keys")

    @topology_keys.setter
    def topology_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "topology_keys", value)


if not MYPY:
    class CSINodeDriverArgsDict(TypedDict):
        """
        CSINodeDriver holds information about the specification of one CSI driver installed on a node
        """
        name: pulumi.Input[_builtins.str]
        """
        name represents the name of the CSI driver that this object refers to. This MUST be the same name returned by the CSI GetPluginName() call for that driver.
        """
        node_id: pulumi.Input[_builtins.str]
        """
        nodeID of the node from the driver point of view. This field enables Kubernetes to communicate with storage systems that do not share the same nomenclature for nodes. For example, Kubernetes may refer to a given node as "node1", but the storage system may refer to the same node as "nodeA". When Kubernetes issues a command to the storage system to attach a volume to a specific node, it can use this field to refer to the node name using the ID that the storage system will understand, e.g. "nodeA" instead of "node1". This field is required.
        """
        allocatable: NotRequired[pulumi.Input['VolumeNodeResourcesArgsDict']]
        """
        allocatable represents the volume resources of a node that are available for scheduling. This field is beta.
        """
        topology_keys: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        topologyKeys is the list of keys supported by the driver. When a driver is initialized on a cluster, it provides a set of topology keys that it understands (e.g. "company.com/zone", "company.com/region"). When a driver is initialized on a node, it provides the same topology keys along with values. Kubelet will expose these topology keys as labels on its own node object. When Kubernetes does topology aware provisioning, it can use this list to determine which labels it should retrieve from the node object and pass back to the driver. It is possible for different nodes to use different topology keys. This can be empty if driver does not support topology.
        """
elif False:
    CSINodeDriverArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CSINodeDriverArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 node_id: pulumi.Input[_builtins.str],
                 allocatable: Optional[pulumi.Input['VolumeNodeResourcesArgs']] = None,
                 topology_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        CSINodeDriver holds information about the specification of one CSI driver installed on a node
        :param pulumi.Input[_builtins.str] name: name represents the name of the CSI driver that this object refers to. This MUST be the same name returned by the CSI GetPluginName() call for that driver.
        :param pulumi.Input[_builtins.str] node_id: nodeID of the node from the driver point of view. This field enables Kubernetes to communicate with storage systems that do not share the same nomenclature for nodes. For example, Kubernetes may refer to a given node as "node1", but the storage system may refer to the same node as "nodeA". When Kubernetes issues a command to the storage system to attach a volume to a specific node, it can use this field to refer to the node name using the ID that the storage system will understand, e.g. "nodeA" instead of "node1". This field is required.
        :param pulumi.Input['VolumeNodeResourcesArgs'] allocatable: allocatable represents the volume resources of a node that are available for scheduling. This field is beta.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] topology_keys: topologyKeys is the list of keys supported by the driver. When a driver is initialized on a cluster, it provides a set of topology keys that it understands (e.g. "company.com/zone", "company.com/region"). When a driver is initialized on a node, it provides the same topology keys along with values. Kubelet will expose these topology keys as labels on its own node object. When Kubernetes does topology aware provisioning, it can use this list to determine which labels it should retrieve from the node object and pass back to the driver. It is possible for different nodes to use different topology keys. This can be empty if driver does not support topology.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "node_id", node_id)
        if allocatable is not None:
            pulumi.set(__self__, "allocatable", allocatable)
        if topology_keys is not None:
            pulumi.set(__self__, "topology_keys", topology_keys)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        name represents the name of the CSI driver that this object refers to. This MUST be the same name returned by the CSI GetPluginName() call for that driver.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeID")
    def node_id(self) -> pulumi.Input[_builtins.str]:
        """
        nodeID of the node from the driver point of view. This field enables Kubernetes to communicate with storage systems that do not share the same nomenclature for nodes. For example, Kubernetes may refer to a given node as "node1", but the storage system may refer to the same node as "nodeA". When Kubernetes issues a command to the storage system to attach a volume to a specific node, it can use this field to refer to the node name using the ID that the storage system will understand, e.g. "nodeA" instead of "node1". This field is required.
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "node_id", value)

    @_builtins.property
    @pulumi.getter
    def allocatable(self) -> Optional[pulumi.Input['VolumeNodeResourcesArgs']]:
        """
        allocatable represents the volume resources of a node that are available for scheduling. This field is beta.
        """
        return pulumi.get(self, "allocatable")

    @allocatable.setter
    def allocatable(self, value: Optional[pulumi.Input['VolumeNodeResourcesArgs']]):
        pulumi.set(self, "allocatable", value)

    @_builtins.property
    @pulumi.getter(name="topologyKeys")
    def topology_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        topologyKeys is the list of keys supported by the driver. When a driver is initialized on a cluster, it provides a set of topology keys that it understands (e.g. "company.com/zone", "company.com/region"). When a driver is initialized on a node, it provides the same topology keys along with values. Kubelet will expose these topology keys as labels on its own node object. When Kubernetes does topology aware provisioning, it can use this list to determine which labels it should retrieve from the node object and pass back to the driver. It is possible for different nodes to use different topology keys. This can be empty if driver does not support topology.
        """
        return pulumi.get(self, "topology_keys")

    @topology_keys.setter
    def topology_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "topology_keys", value)


if not MYPY:
    class CSINodeSpecPatchArgsDict(TypedDict):
        """
        CSINodeSpec holds information about the specification of all CSI drivers installed on a node
        """
        drivers: NotRequired[pulumi.Input[Sequence[pulumi.Input['CSINodeDriverPatchArgsDict']]]]
        """
        drivers is a list of information of all CSI Drivers existing on a node. If all drivers in the list are uninstalled, this can become empty.
        """
elif False:
    CSINodeSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CSINodeSpecPatchArgs:
    def __init__(__self__, *,
                 drivers: Optional[pulumi.Input[Sequence[pulumi.Input['CSINodeDriverPatchArgs']]]] = None):
        """
        CSINodeSpec holds information about the specification of all CSI drivers installed on a node
        :param pulumi.Input[Sequence[pulumi.Input['CSINodeDriverPatchArgs']]] drivers: drivers is a list of information of all CSI Drivers existing on a node. If all drivers in the list are uninstalled, this can become empty.
        """
        if drivers is not None:
            pulumi.set(__self__, "drivers", drivers)

    @_builtins.property
    @pulumi.getter
    def drivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CSINodeDriverPatchArgs']]]]:
        """
        drivers is a list of information of all CSI Drivers existing on a node. If all drivers in the list are uninstalled, this can become empty.
        """
        return pulumi.get(self, "drivers")

    @drivers.setter
    def drivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CSINodeDriverPatchArgs']]]]):
        pulumi.set(self, "drivers", value)


if not MYPY:
    class CSINodeSpecArgsDict(TypedDict):
        """
        CSINodeSpec holds information about the specification of all CSI drivers installed on a node
        """
        drivers: pulumi.Input[Sequence[pulumi.Input['CSINodeDriverArgsDict']]]
        """
        drivers is a list of information of all CSI Drivers existing on a node. If all drivers in the list are uninstalled, this can become empty.
        """
elif False:
    CSINodeSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CSINodeSpecArgs:
    def __init__(__self__, *,
                 drivers: pulumi.Input[Sequence[pulumi.Input['CSINodeDriverArgs']]]):
        """
        CSINodeSpec holds information about the specification of all CSI drivers installed on a node
        :param pulumi.Input[Sequence[pulumi.Input['CSINodeDriverArgs']]] drivers: drivers is a list of information of all CSI Drivers existing on a node. If all drivers in the list are uninstalled, this can become empty.
        """
        pulumi.set(__self__, "drivers", drivers)

    @_builtins.property
    @pulumi.getter
    def drivers(self) -> pulumi.Input[Sequence[pulumi.Input['CSINodeDriverArgs']]]:
        """
        drivers is a list of information of all CSI Drivers existing on a node. If all drivers in the list are uninstalled, this can become empty.
        """
        return pulumi.get(self, "drivers")

    @drivers.setter
    def drivers(self, value: pulumi.Input[Sequence[pulumi.Input['CSINodeDriverArgs']]]):
        pulumi.set(self, "drivers", value)


if not MYPY:
    class CSINodeArgsDict(TypedDict):
        """
        CSINode holds information about all CSI drivers installed on a node. CSI drivers do not need to create the CSINode object directly. As long as they use the node-driver-registrar sidecar container, the kubelet will automatically populate the CSINode object for the CSI driver as part of kubelet plugin registration. CSINode has the same name as a node. If the object is missing, it means either there are no CSI Drivers available on the node, or the Kubelet version is low enough that it doesn't create this object. CSINode has an OwnerReference that points to the corresponding node object.
        """
        spec: pulumi.Input['CSINodeSpecArgsDict']
        """
        spec is the specification of CSINode
        """
        api_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[_builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object's metadata. metadata.name must be the Kubernetes node name.
        """
elif False:
    CSINodeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CSINodeArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['CSINodeSpecArgs'],
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None):
        """
        CSINode holds information about all CSI drivers installed on a node. CSI drivers do not need to create the CSINode object directly. As long as they use the node-driver-registrar sidecar container, the kubelet will automatically populate the CSINode object for the CSI driver as part of kubelet plugin registration. CSINode has the same name as a node. If the object is missing, it means either there are no CSI Drivers available on the node, or the Kubelet version is low enough that it doesn't create this object. CSINode has an OwnerReference that points to the corresponding node object.
        :param pulumi.Input['CSINodeSpecArgs'] spec: spec is the specification of CSINode
        :param pulumi.Input[_builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[_builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. metadata.name must be the Kubernetes node name.
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'storage.k8s.io/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'CSINode')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> pulumi.Input['CSINodeSpecArgs']:
        """
        spec is the specification of CSINode
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['CSINodeSpecArgs']):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. metadata.name must be the Kubernetes node name.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)


if not MYPY:
    class CSIStorageCapacityArgsDict(TypedDict):
        """
        CSIStorageCapacity stores the result of one CSI GetCapacity call. For a given StorageClass, this describes the available capacity in a particular topology segment.  This can be used when considering where to instantiate new PersistentVolumes.

        For example this can express things like: - StorageClass "standard" has "1234 GiB" available in "topology.kubernetes.io/zone=us-east1" - StorageClass "localssd" has "10 GiB" available in "kubernetes.io/hostname=knode-abc123"

        The following three cases all imply that no capacity is available for a certain combination: - no object exists with suitable topology and storage class name - such an object exists, but the capacity is unset - such an object exists, but the capacity is zero

        The producer of these objects can decide which approach is more suitable.

        They are consumed by the kube-scheduler when a CSI driver opts into capacity-aware scheduling with CSIDriverSpec.StorageCapacity. The scheduler compares the MaximumVolumeSize against the requested size of pending volumes to filter out unsuitable nodes. If MaximumVolumeSize is unset, it falls back to a comparison against the less precise Capacity. If that is also unset, the scheduler assumes that capacity is insufficient and tries some other node.
        """
        storage_class_name: pulumi.Input[_builtins.str]
        """
        storageClassName represents the name of the StorageClass that the reported capacity applies to. It must meet the same requirements as the name of a StorageClass object (non-empty, DNS subdomain). If that object no longer exists, the CSIStorageCapacity object is obsolete and should be removed by its creator. This field is immutable.
        """
        api_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        capacity: NotRequired[pulumi.Input[_builtins.str]]
        """
        capacity is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields.

        The semantic is currently (CSI spec 1.2) defined as: The available capacity, in bytes, of the storage that can be used to provision volumes. If not set, that information is currently unavailable.
        """
        kind: NotRequired[pulumi.Input[_builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        maximum_volume_size: NotRequired[pulumi.Input[_builtins.str]]
        """
        maximumVolumeSize is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields.

        This is defined since CSI spec 1.4.0 as the largest size that may be used in a CreateVolumeRequest.capacity_range.required_bytes field to create a volume with the same parameters as those in GetCapacityRequest. The corresponding value in the Kubernetes API is ResourceRequirements.Requests in a volume claim.
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object's metadata. The name has no particular meaning. It must be a DNS subdomain (dots allowed, 253 characters). To ensure that there are no conflicts with other CSI drivers on the cluster, the recommendation is to use csisc-<uuid>, a generated name, or a reverse-domain name which ends with the unique CSI driver name.

        Objects are namespaced.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        node_topology: NotRequired[pulumi.Input['_meta.v1.LabelSelectorArgsDict']]
        """
        nodeTopology defines which nodes have access to the storage for which capacity was reported. If not set, the storage is not accessible from any node in the cluster. If empty, the storage is accessible from all nodes. This field is immutable.
        """
elif False:
    CSIStorageCapacityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CSIStorageCapacityArgs:
    def __init__(__self__, *,
                 storage_class_name: pulumi.Input[_builtins.str],
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_volume_size: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 node_topology: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']] = None):
        """
        CSIStorageCapacity stores the result of one CSI GetCapacity call. For a given StorageClass, this describes the available capacity in a particular topology segment.  This can be used when considering where to instantiate new PersistentVolumes.

        For example this can express things like: - StorageClass "standard" has "1234 GiB" available in "topology.kubernetes.io/zone=us-east1" - StorageClass "localssd" has "10 GiB" available in "kubernetes.io/hostname=knode-abc123"

        The following three cases all imply that no capacity is available for a certain combination: - no object exists with suitable topology and storage class name - such an object exists, but the capacity is unset - such an object exists, but the capacity is zero

        The producer of these objects can decide which approach is more suitable.

        They are consumed by the kube-scheduler when a CSI driver opts into capacity-aware scheduling with CSIDriverSpec.StorageCapacity. The scheduler compares the MaximumVolumeSize against the requested size of pending volumes to filter out unsuitable nodes. If MaximumVolumeSize is unset, it falls back to a comparison against the less precise Capacity. If that is also unset, the scheduler assumes that capacity is insufficient and tries some other node.
        :param pulumi.Input[_builtins.str] storage_class_name: storageClassName represents the name of the StorageClass that the reported capacity applies to. It must meet the same requirements as the name of a StorageClass object (non-empty, DNS subdomain). If that object no longer exists, the CSIStorageCapacity object is obsolete and should be removed by its creator. This field is immutable.
        :param pulumi.Input[_builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[_builtins.str] capacity: capacity is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields.
               
               The semantic is currently (CSI spec 1.2) defined as: The available capacity, in bytes, of the storage that can be used to provision volumes. If not set, that information is currently unavailable.
        :param pulumi.Input[_builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input[_builtins.str] maximum_volume_size: maximumVolumeSize is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields.
               
               This is defined since CSI spec 1.4.0 as the largest size that may be used in a CreateVolumeRequest.capacity_range.required_bytes field to create a volume with the same parameters as those in GetCapacityRequest. The corresponding value in the Kubernetes API is ResourceRequirements.Requests in a volume claim.
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. The name has no particular meaning. It must be a DNS subdomain (dots allowed, 253 characters). To ensure that there are no conflicts with other CSI drivers on the cluster, the recommendation is to use csisc-<uuid>, a generated name, or a reverse-domain name which ends with the unique CSI driver name.
               
               Objects are namespaced.
               
               More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['_meta.v1.LabelSelectorArgs'] node_topology: nodeTopology defines which nodes have access to the storage for which capacity was reported. If not set, the storage is not accessible from any node in the cluster. If empty, the storage is accessible from all nodes. This field is immutable.
        """
        pulumi.set(__self__, "storage_class_name", storage_class_name)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'storage.k8s.io/v1')
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if kind is not None:
            pulumi.set(__self__, "kind", 'CSIStorageCapacity')
        if maximum_volume_size is not None:
            pulumi.set(__self__, "maximum_volume_size", maximum_volume_size)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if node_topology is not None:
            pulumi.set(__self__, "node_topology", node_topology)

    @_builtins.property
    @pulumi.getter(name="storageClassName")
    def storage_class_name(self) -> pulumi.Input[_builtins.str]:
        """
        storageClassName represents the name of the StorageClass that the reported capacity applies to. It must meet the same requirements as the name of a StorageClass object (non-empty, DNS subdomain). If that object no longer exists, the CSIStorageCapacity object is obsolete and should be removed by its creator. This field is immutable.
        """
        return pulumi.get(self, "storage_class_name")

    @storage_class_name.setter
    def storage_class_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_class_name", value)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        capacity is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields.

        The semantic is currently (CSI spec 1.2) defined as: The available capacity, in bytes, of the storage that can be used to provision volumes. If not set, that information is currently unavailable.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter(name="maximumVolumeSize")
    def maximum_volume_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        maximumVolumeSize is the value reported by the CSI driver in its GetCapacityResponse for a GetCapacityRequest with topology and parameters that match the previous fields.

        This is defined since CSI spec 1.4.0 as the largest size that may be used in a CreateVolumeRequest.capacity_range.required_bytes field to create a volume with the same parameters as those in GetCapacityRequest. The corresponding value in the Kubernetes API is ResourceRequirements.Requests in a volume claim.
        """
        return pulumi.get(self, "maximum_volume_size")

    @maximum_volume_size.setter
    def maximum_volume_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maximum_volume_size", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. The name has no particular meaning. It must be a DNS subdomain (dots allowed, 253 characters). To ensure that there are no conflicts with other CSI drivers on the cluster, the recommendation is to use csisc-<uuid>, a generated name, or a reverse-domain name which ends with the unique CSI driver name.

        Objects are namespaced.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="nodeTopology")
    def node_topology(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]:
        """
        nodeTopology defines which nodes have access to the storage for which capacity was reported. If not set, the storage is not accessible from any node in the cluster. If empty, the storage is accessible from all nodes. This field is immutable.
        """
        return pulumi.get(self, "node_topology")

    @node_topology.setter
    def node_topology(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]):
        pulumi.set(self, "node_topology", value)


if not MYPY:
    class StorageClassArgsDict(TypedDict):
        """
        StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.

        StorageClasses are non-namespaced; the name of the storage class according to etcd is in ObjectMeta.Name.
        """
        provisioner: pulumi.Input[_builtins.str]
        """
        provisioner indicates the type of the provisioner.
        """
        allow_volume_expansion: NotRequired[pulumi.Input[_builtins.bool]]
        """
        allowVolumeExpansion shows whether the storage class allow volume expand.
        """
        allowed_topologies: NotRequired[pulumi.Input[Sequence[pulumi.Input['_core.v1.TopologySelectorTermArgsDict']]]]
        """
        allowedTopologies restrict the node topologies where volumes can be dynamically provisioned. Each volume plugin defines its own supported topology specifications. An empty TopologySelectorTerm list means there is no topology restriction. This field is only honored by servers that enable the VolumeScheduling feature.
        """
        api_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[_builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        mount_options: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        mountOptions controls the mountOptions for dynamically provisioned PersistentVolumes of this storage class. e.g. ["ro", "soft"]. Not validated - mount of the PVs will simply fail if one is invalid.
        """
        parameters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        parameters holds the parameters for the provisioner that should create volumes of this storage class.
        """
        reclaim_policy: NotRequired[pulumi.Input[_builtins.str]]
        """
        reclaimPolicy controls the reclaimPolicy for dynamically provisioned PersistentVolumes of this storage class. Defaults to Delete.
        """
        volume_binding_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        volumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound.  When unset, VolumeBindingImmediate is used. This field is only honored by servers that enable the VolumeScheduling feature.
        """
elif False:
    StorageClassArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StorageClassArgs:
    def __init__(__self__, *,
                 provisioner: pulumi.Input[_builtins.str],
                 allow_volume_expansion: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_topologies: Optional[pulumi.Input[Sequence[pulumi.Input['_core.v1.TopologySelectorTermArgs']]]] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 mount_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 reclaim_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_binding_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.

        StorageClasses are non-namespaced; the name of the storage class according to etcd is in ObjectMeta.Name.
        :param pulumi.Input[_builtins.str] provisioner: provisioner indicates the type of the provisioner.
        :param pulumi.Input[_builtins.bool] allow_volume_expansion: allowVolumeExpansion shows whether the storage class allow volume expand.
        :param pulumi.Input[Sequence[pulumi.Input['_core.v1.TopologySelectorTermArgs']]] allowed_topologies: allowedTopologies restrict the node topologies where volumes can be dynamically provisioned. Each volume plugin defines its own supported topology specifications. An empty TopologySelectorTerm list means there is no topology restriction. This field is only honored by servers that enable the VolumeScheduling feature.
        :param pulumi.Input[_builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[_builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mount_options: mountOptions controls the mountOptions for dynamically provisioned PersistentVolumes of this storage class. e.g. ["ro", "soft"]. Not validated - mount of the PVs will simply fail if one is invalid.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: parameters holds the parameters for the provisioner that should create volumes of this storage class.
        :param pulumi.Input[_builtins.str] reclaim_policy: reclaimPolicy controls the reclaimPolicy for dynamically provisioned PersistentVolumes of this storage class. Defaults to Delete.
        :param pulumi.Input[_builtins.str] volume_binding_mode: volumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound.  When unset, VolumeBindingImmediate is used. This field is only honored by servers that enable the VolumeScheduling feature.
        """
        pulumi.set(__self__, "provisioner", provisioner)
        if allow_volume_expansion is not None:
            pulumi.set(__self__, "allow_volume_expansion", allow_volume_expansion)
        if allowed_topologies is not None:
            pulumi.set(__self__, "allowed_topologies", allowed_topologies)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'storage.k8s.io/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'StorageClass')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if reclaim_policy is not None:
            pulumi.set(__self__, "reclaim_policy", reclaim_policy)
        if volume_binding_mode is not None:
            pulumi.set(__self__, "volume_binding_mode", volume_binding_mode)

    @_builtins.property
    @pulumi.getter
    def provisioner(self) -> pulumi.Input[_builtins.str]:
        """
        provisioner indicates the type of the provisioner.
        """
        return pulumi.get(self, "provisioner")

    @provisioner.setter
    def provisioner(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "provisioner", value)

    @_builtins.property
    @pulumi.getter(name="allowVolumeExpansion")
    def allow_volume_expansion(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        allowVolumeExpansion shows whether the storage class allow volume expand.
        """
        return pulumi.get(self, "allow_volume_expansion")

    @allow_volume_expansion.setter
    def allow_volume_expansion(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_volume_expansion", value)

    @_builtins.property
    @pulumi.getter(name="allowedTopologies")
    def allowed_topologies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_core.v1.TopologySelectorTermArgs']]]]:
        """
        allowedTopologies restrict the node topologies where volumes can be dynamically provisioned. Each volume plugin defines its own supported topology specifications. An empty TopologySelectorTerm list means there is no topology restriction. This field is only honored by servers that enable the VolumeScheduling feature.
        """
        return pulumi.get(self, "allowed_topologies")

    @allowed_topologies.setter
    def allowed_topologies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_core.v1.TopologySelectorTermArgs']]]]):
        pulumi.set(self, "allowed_topologies", value)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        mountOptions controls the mountOptions for dynamically provisioned PersistentVolumes of this storage class. e.g. ["ro", "soft"]. Not validated - mount of the PVs will simply fail if one is invalid.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "mount_options", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        parameters holds the parameters for the provisioner that should create volumes of this storage class.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="reclaimPolicy")
    def reclaim_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        reclaimPolicy controls the reclaimPolicy for dynamically provisioned PersistentVolumes of this storage class. Defaults to Delete.
        """
        return pulumi.get(self, "reclaim_policy")

    @reclaim_policy.setter
    def reclaim_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reclaim_policy", value)

    @_builtins.property
    @pulumi.getter(name="volumeBindingMode")
    def volume_binding_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        volumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound.  When unset, VolumeBindingImmediate is used. This field is only honored by servers that enable the VolumeScheduling feature.
        """
        return pulumi.get(self, "volume_binding_mode")

    @volume_binding_mode.setter
    def volume_binding_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_binding_mode", value)


if not MYPY:
    class TokenRequestPatchArgsDict(TypedDict):
        """
        TokenRequest contains parameters of a service account token.
        """
        audience: NotRequired[pulumi.Input[_builtins.str]]
        """
        audience is the intended audience of the token in "TokenRequestSpec". It will default to the audiences of kube apiserver.
        """
        expiration_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        expirationSeconds is the duration of validity of the token in "TokenRequestSpec". It has the same default value of "ExpirationSeconds" in "TokenRequestSpec".
        """
elif False:
    TokenRequestPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TokenRequestPatchArgs:
    def __init__(__self__, *,
                 audience: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        TokenRequest contains parameters of a service account token.
        :param pulumi.Input[_builtins.str] audience: audience is the intended audience of the token in "TokenRequestSpec". It will default to the audiences of kube apiserver.
        :param pulumi.Input[_builtins.int] expiration_seconds: expirationSeconds is the duration of validity of the token in "TokenRequestSpec". It has the same default value of "ExpirationSeconds" in "TokenRequestSpec".
        """
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if expiration_seconds is not None:
            pulumi.set(__self__, "expiration_seconds", expiration_seconds)

    @_builtins.property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        audience is the intended audience of the token in "TokenRequestSpec". It will default to the audiences of kube apiserver.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audience", value)

    @_builtins.property
    @pulumi.getter(name="expirationSeconds")
    def expiration_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        expirationSeconds is the duration of validity of the token in "TokenRequestSpec". It has the same default value of "ExpirationSeconds" in "TokenRequestSpec".
        """
        return pulumi.get(self, "expiration_seconds")

    @expiration_seconds.setter
    def expiration_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiration_seconds", value)


if not MYPY:
    class TokenRequestArgsDict(TypedDict):
        """
        TokenRequest contains parameters of a service account token.
        """
        audience: pulumi.Input[_builtins.str]
        """
        audience is the intended audience of the token in "TokenRequestSpec". It will default to the audiences of kube apiserver.
        """
        expiration_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        expirationSeconds is the duration of validity of the token in "TokenRequestSpec". It has the same default value of "ExpirationSeconds" in "TokenRequestSpec".
        """
elif False:
    TokenRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TokenRequestArgs:
    def __init__(__self__, *,
                 audience: pulumi.Input[_builtins.str],
                 expiration_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        TokenRequest contains parameters of a service account token.
        :param pulumi.Input[_builtins.str] audience: audience is the intended audience of the token in "TokenRequestSpec". It will default to the audiences of kube apiserver.
        :param pulumi.Input[_builtins.int] expiration_seconds: expirationSeconds is the duration of validity of the token in "TokenRequestSpec". It has the same default value of "ExpirationSeconds" in "TokenRequestSpec".
        """
        pulumi.set(__self__, "audience", audience)
        if expiration_seconds is not None:
            pulumi.set(__self__, "expiration_seconds", expiration_seconds)

    @_builtins.property
    @pulumi.getter
    def audience(self) -> pulumi.Input[_builtins.str]:
        """
        audience is the intended audience of the token in "TokenRequestSpec". It will default to the audiences of kube apiserver.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "audience", value)

    @_builtins.property
    @pulumi.getter(name="expirationSeconds")
    def expiration_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        expirationSeconds is the duration of validity of the token in "TokenRequestSpec". It has the same default value of "ExpirationSeconds" in "TokenRequestSpec".
        """
        return pulumi.get(self, "expiration_seconds")

    @expiration_seconds.setter
    def expiration_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiration_seconds", value)


if not MYPY:
    class VolumeAttachmentSourcePatchArgsDict(TypedDict):
        """
        VolumeAttachmentSource represents a volume that should be attached. Right now only PersistentVolumes can be attached via external attacher, in the future we may allow also inline volumes in pods. Exactly one member can be set.
        """
        inline_volume_spec: NotRequired[pulumi.Input['_core.v1.PersistentVolumeSpecPatchArgsDict']]
        """
        inlineVolumeSpec contains all the information necessary to attach a persistent volume defined by a pod's inline VolumeSource. This field is populated only for the CSIMigration feature. It contains translated fields from a pod's inline VolumeSource to a PersistentVolumeSpec. This field is beta-level and is only honored by servers that enabled the CSIMigration feature.
        """
        persistent_volume_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        persistentVolumeName represents the name of the persistent volume to attach.
        """
elif False:
    VolumeAttachmentSourcePatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeAttachmentSourcePatchArgs:
    def __init__(__self__, *,
                 inline_volume_spec: Optional[pulumi.Input['_core.v1.PersistentVolumeSpecPatchArgs']] = None,
                 persistent_volume_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        VolumeAttachmentSource represents a volume that should be attached. Right now only PersistentVolumes can be attached via external attacher, in the future we may allow also inline volumes in pods. Exactly one member can be set.
        :param pulumi.Input['_core.v1.PersistentVolumeSpecPatchArgs'] inline_volume_spec: inlineVolumeSpec contains all the information necessary to attach a persistent volume defined by a pod's inline VolumeSource. This field is populated only for the CSIMigration feature. It contains translated fields from a pod's inline VolumeSource to a PersistentVolumeSpec. This field is beta-level and is only honored by servers that enabled the CSIMigration feature.
        :param pulumi.Input[_builtins.str] persistent_volume_name: persistentVolumeName represents the name of the persistent volume to attach.
        """
        if inline_volume_spec is not None:
            pulumi.set(__self__, "inline_volume_spec", inline_volume_spec)
        if persistent_volume_name is not None:
            pulumi.set(__self__, "persistent_volume_name", persistent_volume_name)

    @_builtins.property
    @pulumi.getter(name="inlineVolumeSpec")
    def inline_volume_spec(self) -> Optional[pulumi.Input['_core.v1.PersistentVolumeSpecPatchArgs']]:
        """
        inlineVolumeSpec contains all the information necessary to attach a persistent volume defined by a pod's inline VolumeSource. This field is populated only for the CSIMigration feature. It contains translated fields from a pod's inline VolumeSource to a PersistentVolumeSpec. This field is beta-level and is only honored by servers that enabled the CSIMigration feature.
        """
        return pulumi.get(self, "inline_volume_spec")

    @inline_volume_spec.setter
    def inline_volume_spec(self, value: Optional[pulumi.Input['_core.v1.PersistentVolumeSpecPatchArgs']]):
        pulumi.set(self, "inline_volume_spec", value)

    @_builtins.property
    @pulumi.getter(name="persistentVolumeName")
    def persistent_volume_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        persistentVolumeName represents the name of the persistent volume to attach.
        """
        return pulumi.get(self, "persistent_volume_name")

    @persistent_volume_name.setter
    def persistent_volume_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "persistent_volume_name", value)


if not MYPY:
    class VolumeAttachmentSourceArgsDict(TypedDict):
        """
        VolumeAttachmentSource represents a volume that should be attached. Right now only PersistentVolumes can be attached via external attacher, in the future we may allow also inline volumes in pods. Exactly one member can be set.
        """
        inline_volume_spec: NotRequired[pulumi.Input['_core.v1.PersistentVolumeSpecArgsDict']]
        """
        inlineVolumeSpec contains all the information necessary to attach a persistent volume defined by a pod's inline VolumeSource. This field is populated only for the CSIMigration feature. It contains translated fields from a pod's inline VolumeSource to a PersistentVolumeSpec. This field is beta-level and is only honored by servers that enabled the CSIMigration feature.
        """
        persistent_volume_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        persistentVolumeName represents the name of the persistent volume to attach.
        """
elif False:
    VolumeAttachmentSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeAttachmentSourceArgs:
    def __init__(__self__, *,
                 inline_volume_spec: Optional[pulumi.Input['_core.v1.PersistentVolumeSpecArgs']] = None,
                 persistent_volume_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        VolumeAttachmentSource represents a volume that should be attached. Right now only PersistentVolumes can be attached via external attacher, in the future we may allow also inline volumes in pods. Exactly one member can be set.
        :param pulumi.Input['_core.v1.PersistentVolumeSpecArgs'] inline_volume_spec: inlineVolumeSpec contains all the information necessary to attach a persistent volume defined by a pod's inline VolumeSource. This field is populated only for the CSIMigration feature. It contains translated fields from a pod's inline VolumeSource to a PersistentVolumeSpec. This field is beta-level and is only honored by servers that enabled the CSIMigration feature.
        :param pulumi.Input[_builtins.str] persistent_volume_name: persistentVolumeName represents the name of the persistent volume to attach.
        """
        if inline_volume_spec is not None:
            pulumi.set(__self__, "inline_volume_spec", inline_volume_spec)
        if persistent_volume_name is not None:
            pulumi.set(__self__, "persistent_volume_name", persistent_volume_name)

    @_builtins.property
    @pulumi.getter(name="inlineVolumeSpec")
    def inline_volume_spec(self) -> Optional[pulumi.Input['_core.v1.PersistentVolumeSpecArgs']]:
        """
        inlineVolumeSpec contains all the information necessary to attach a persistent volume defined by a pod's inline VolumeSource. This field is populated only for the CSIMigration feature. It contains translated fields from a pod's inline VolumeSource to a PersistentVolumeSpec. This field is beta-level and is only honored by servers that enabled the CSIMigration feature.
        """
        return pulumi.get(self, "inline_volume_spec")

    @inline_volume_spec.setter
    def inline_volume_spec(self, value: Optional[pulumi.Input['_core.v1.PersistentVolumeSpecArgs']]):
        pulumi.set(self, "inline_volume_spec", value)

    @_builtins.property
    @pulumi.getter(name="persistentVolumeName")
    def persistent_volume_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        persistentVolumeName represents the name of the persistent volume to attach.
        """
        return pulumi.get(self, "persistent_volume_name")

    @persistent_volume_name.setter
    def persistent_volume_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "persistent_volume_name", value)


if not MYPY:
    class VolumeAttachmentSpecPatchArgsDict(TypedDict):
        """
        VolumeAttachmentSpec is the specification of a VolumeAttachment request.
        """
        attacher: NotRequired[pulumi.Input[_builtins.str]]
        """
        attacher indicates the name of the volume driver that MUST handle this request. This is the name returned by GetPluginName().
        """
        node_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        nodeName represents the node that the volume should be attached to.
        """
        source: NotRequired[pulumi.Input['VolumeAttachmentSourcePatchArgsDict']]
        """
        source represents the volume that should be attached.
        """
elif False:
    VolumeAttachmentSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeAttachmentSpecPatchArgs:
    def __init__(__self__, *,
                 attacher: Optional[pulumi.Input[_builtins.str]] = None,
                 node_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input['VolumeAttachmentSourcePatchArgs']] = None):
        """
        VolumeAttachmentSpec is the specification of a VolumeAttachment request.
        :param pulumi.Input[_builtins.str] attacher: attacher indicates the name of the volume driver that MUST handle this request. This is the name returned by GetPluginName().
        :param pulumi.Input[_builtins.str] node_name: nodeName represents the node that the volume should be attached to.
        :param pulumi.Input['VolumeAttachmentSourcePatchArgs'] source: source represents the volume that should be attached.
        """
        if attacher is not None:
            pulumi.set(__self__, "attacher", attacher)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter
    def attacher(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        attacher indicates the name of the volume driver that MUST handle this request. This is the name returned by GetPluginName().
        """
        return pulumi.get(self, "attacher")

    @attacher.setter
    def attacher(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "attacher", value)

    @_builtins.property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        nodeName represents the node that the volume should be attached to.
        """
        return pulumi.get(self, "node_name")

    @node_name.setter
    def node_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_name", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['VolumeAttachmentSourcePatchArgs']]:
        """
        source represents the volume that should be attached.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['VolumeAttachmentSourcePatchArgs']]):
        pulumi.set(self, "source", value)


if not MYPY:
    class VolumeAttachmentSpecArgsDict(TypedDict):
        """
        VolumeAttachmentSpec is the specification of a VolumeAttachment request.
        """
        attacher: pulumi.Input[_builtins.str]
        """
        attacher indicates the name of the volume driver that MUST handle this request. This is the name returned by GetPluginName().
        """
        node_name: pulumi.Input[_builtins.str]
        """
        nodeName represents the node that the volume should be attached to.
        """
        source: pulumi.Input['VolumeAttachmentSourceArgsDict']
        """
        source represents the volume that should be attached.
        """
elif False:
    VolumeAttachmentSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeAttachmentSpecArgs:
    def __init__(__self__, *,
                 attacher: pulumi.Input[_builtins.str],
                 node_name: pulumi.Input[_builtins.str],
                 source: pulumi.Input['VolumeAttachmentSourceArgs']):
        """
        VolumeAttachmentSpec is the specification of a VolumeAttachment request.
        :param pulumi.Input[_builtins.str] attacher: attacher indicates the name of the volume driver that MUST handle this request. This is the name returned by GetPluginName().
        :param pulumi.Input[_builtins.str] node_name: nodeName represents the node that the volume should be attached to.
        :param pulumi.Input['VolumeAttachmentSourceArgs'] source: source represents the volume that should be attached.
        """
        pulumi.set(__self__, "attacher", attacher)
        pulumi.set(__self__, "node_name", node_name)
        pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter
    def attacher(self) -> pulumi.Input[_builtins.str]:
        """
        attacher indicates the name of the volume driver that MUST handle this request. This is the name returned by GetPluginName().
        """
        return pulumi.get(self, "attacher")

    @attacher.setter
    def attacher(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "attacher", value)

    @_builtins.property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> pulumi.Input[_builtins.str]:
        """
        nodeName represents the node that the volume should be attached to.
        """
        return pulumi.get(self, "node_name")

    @node_name.setter
    def node_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "node_name", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input['VolumeAttachmentSourceArgs']:
        """
        source represents the volume that should be attached.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['VolumeAttachmentSourceArgs']):
        pulumi.set(self, "source", value)


if not MYPY:
    class VolumeAttachmentStatusArgsDict(TypedDict):
        """
        VolumeAttachmentStatus is the status of a VolumeAttachment request.
        """
        attached: pulumi.Input[_builtins.bool]
        """
        attached indicates the volume is successfully attached. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
        """
        attach_error: NotRequired[pulumi.Input['VolumeErrorArgsDict']]
        """
        attachError represents the last error encountered during attach operation, if any. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
        """
        attachment_metadata: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        attachmentMetadata is populated with any information returned by the attach operation, upon successful attach, that must be passed into subsequent WaitForAttach or Mount calls. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
        """
        detach_error: NotRequired[pulumi.Input['VolumeErrorArgsDict']]
        """
        detachError represents the last error encountered during detach operation, if any. This field must only be set by the entity completing the detach operation, i.e. the external-attacher.
        """
elif False:
    VolumeAttachmentStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeAttachmentStatusArgs:
    def __init__(__self__, *,
                 attached: pulumi.Input[_builtins.bool],
                 attach_error: Optional[pulumi.Input['VolumeErrorArgs']] = None,
                 attachment_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 detach_error: Optional[pulumi.Input['VolumeErrorArgs']] = None):
        """
        VolumeAttachmentStatus is the status of a VolumeAttachment request.
        :param pulumi.Input[_builtins.bool] attached: attached indicates the volume is successfully attached. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
        :param pulumi.Input['VolumeErrorArgs'] attach_error: attachError represents the last error encountered during attach operation, if any. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] attachment_metadata: attachmentMetadata is populated with any information returned by the attach operation, upon successful attach, that must be passed into subsequent WaitForAttach or Mount calls. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
        :param pulumi.Input['VolumeErrorArgs'] detach_error: detachError represents the last error encountered during detach operation, if any. This field must only be set by the entity completing the detach operation, i.e. the external-attacher.
        """
        pulumi.set(__self__, "attached", attached)
        if attach_error is not None:
            pulumi.set(__self__, "attach_error", attach_error)
        if attachment_metadata is not None:
            pulumi.set(__self__, "attachment_metadata", attachment_metadata)
        if detach_error is not None:
            pulumi.set(__self__, "detach_error", detach_error)

    @_builtins.property
    @pulumi.getter
    def attached(self) -> pulumi.Input[_builtins.bool]:
        """
        attached indicates the volume is successfully attached. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
        """
        return pulumi.get(self, "attached")

    @attached.setter
    def attached(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "attached", value)

    @_builtins.property
    @pulumi.getter(name="attachError")
    def attach_error(self) -> Optional[pulumi.Input['VolumeErrorArgs']]:
        """
        attachError represents the last error encountered during attach operation, if any. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
        """
        return pulumi.get(self, "attach_error")

    @attach_error.setter
    def attach_error(self, value: Optional[pulumi.Input['VolumeErrorArgs']]):
        pulumi.set(self, "attach_error", value)

    @_builtins.property
    @pulumi.getter(name="attachmentMetadata")
    def attachment_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        attachmentMetadata is populated with any information returned by the attach operation, upon successful attach, that must be passed into subsequent WaitForAttach or Mount calls. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
        """
        return pulumi.get(self, "attachment_metadata")

    @attachment_metadata.setter
    def attachment_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "attachment_metadata", value)

    @_builtins.property
    @pulumi.getter(name="detachError")
    def detach_error(self) -> Optional[pulumi.Input['VolumeErrorArgs']]:
        """
        detachError represents the last error encountered during detach operation, if any. This field must only be set by the entity completing the detach operation, i.e. the external-attacher.
        """
        return pulumi.get(self, "detach_error")

    @detach_error.setter
    def detach_error(self, value: Optional[pulumi.Input['VolumeErrorArgs']]):
        pulumi.set(self, "detach_error", value)


if not MYPY:
    class VolumeAttachmentArgsDict(TypedDict):
        """
        VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.

        VolumeAttachment objects are non-namespaced.
        """
        spec: pulumi.Input['VolumeAttachmentSpecArgsDict']
        """
        spec represents specification of the desired attach/detach volume behavior. Populated by the Kubernetes system.
        """
        api_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[_builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        status: NotRequired[pulumi.Input['VolumeAttachmentStatusArgsDict']]
        """
        status represents status of the VolumeAttachment request. Populated by the entity completing the attach or detach operation, i.e. the external-attacher.
        """
elif False:
    VolumeAttachmentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeAttachmentArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['VolumeAttachmentSpecArgs'],
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 status: Optional[pulumi.Input['VolumeAttachmentStatusArgs']] = None):
        """
        VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.

        VolumeAttachment objects are non-namespaced.
        :param pulumi.Input['VolumeAttachmentSpecArgs'] spec: spec represents specification of the desired attach/detach volume behavior. Populated by the Kubernetes system.
        :param pulumi.Input[_builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[_builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['VolumeAttachmentStatusArgs'] status: status represents status of the VolumeAttachment request. Populated by the entity completing the attach or detach operation, i.e. the external-attacher.
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'storage.k8s.io/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'VolumeAttachment')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> pulumi.Input['VolumeAttachmentSpecArgs']:
        """
        spec represents specification of the desired attach/detach volume behavior. Populated by the Kubernetes system.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['VolumeAttachmentSpecArgs']):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['VolumeAttachmentStatusArgs']]:
        """
        status represents status of the VolumeAttachment request. Populated by the entity completing the attach or detach operation, i.e. the external-attacher.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['VolumeAttachmentStatusArgs']]):
        pulumi.set(self, "status", value)


if not MYPY:
    class VolumeErrorArgsDict(TypedDict):
        """
        VolumeError captures an error encountered during a volume operation.
        """
        error_code: NotRequired[pulumi.Input[_builtins.int]]
        """
        errorCode is a numeric gRPC code representing the error encountered during Attach or Detach operations.

        This is an optional, alpha field that requires the MutableCSINodeAllocatableCount feature gate being enabled to be set.
        """
        message: NotRequired[pulumi.Input[_builtins.str]]
        """
        message represents the error encountered during Attach or Detach operation. This string may be logged, so it should not contain sensitive information.
        """
        time: NotRequired[pulumi.Input[_builtins.str]]
        """
        time represents the time the error was encountered.
        """
elif False:
    VolumeErrorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeErrorArgs:
    def __init__(__self__, *,
                 error_code: Optional[pulumi.Input[_builtins.int]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        VolumeError captures an error encountered during a volume operation.
        :param pulumi.Input[_builtins.int] error_code: errorCode is a numeric gRPC code representing the error encountered during Attach or Detach operations.
               
               This is an optional, alpha field that requires the MutableCSINodeAllocatableCount feature gate being enabled to be set.
        :param pulumi.Input[_builtins.str] message: message represents the error encountered during Attach or Detach operation. This string may be logged, so it should not contain sensitive information.
        :param pulumi.Input[_builtins.str] time: time represents the time the error was encountered.
        """
        if error_code is not None:
            pulumi.set(__self__, "error_code", error_code)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @_builtins.property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        errorCode is a numeric gRPC code representing the error encountered during Attach or Detach operations.

        This is an optional, alpha field that requires the MutableCSINodeAllocatableCount feature gate being enabled to be set.
        """
        return pulumi.get(self, "error_code")

    @error_code.setter
    def error_code(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "error_code", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        message represents the error encountered during Attach or Detach operation. This string may be logged, so it should not contain sensitive information.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter
    def time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        time represents the time the error was encountered.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time", value)


if not MYPY:
    class VolumeNodeResourcesPatchArgsDict(TypedDict):
        """
        VolumeNodeResources is a set of resource limits for scheduling of volumes.
        """
        count: NotRequired[pulumi.Input[_builtins.int]]
        """
        count indicates the maximum number of unique volumes managed by the CSI driver that can be used on a node. A volume that is both attached and mounted on a node is considered to be used once, not twice. The same rule applies for a unique volume that is shared among multiple pods on the same node. If this field is not specified, then the supported number of volumes on this node is unbounded.
        """
elif False:
    VolumeNodeResourcesPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeNodeResourcesPatchArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[_builtins.int]] = None):
        """
        VolumeNodeResources is a set of resource limits for scheduling of volumes.
        :param pulumi.Input[_builtins.int] count: count indicates the maximum number of unique volumes managed by the CSI driver that can be used on a node. A volume that is both attached and mounted on a node is considered to be used once, not twice. The same rule applies for a unique volume that is shared among multiple pods on the same node. If this field is not specified, then the supported number of volumes on this node is unbounded.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        count indicates the maximum number of unique volumes managed by the CSI driver that can be used on a node. A volume that is both attached and mounted on a node is considered to be used once, not twice. The same rule applies for a unique volume that is shared among multiple pods on the same node. If this field is not specified, then the supported number of volumes on this node is unbounded.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "count", value)


if not MYPY:
    class VolumeNodeResourcesArgsDict(TypedDict):
        """
        VolumeNodeResources is a set of resource limits for scheduling of volumes.
        """
        count: NotRequired[pulumi.Input[_builtins.int]]
        """
        count indicates the maximum number of unique volumes managed by the CSI driver that can be used on a node. A volume that is both attached and mounted on a node is considered to be used once, not twice. The same rule applies for a unique volume that is shared among multiple pods on the same node. If this field is not specified, then the supported number of volumes on this node is unbounded.
        """
elif False:
    VolumeNodeResourcesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeNodeResourcesArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[_builtins.int]] = None):
        """
        VolumeNodeResources is a set of resource limits for scheduling of volumes.
        :param pulumi.Input[_builtins.int] count: count indicates the maximum number of unique volumes managed by the CSI driver that can be used on a node. A volume that is both attached and mounted on a node is considered to be used once, not twice. The same rule applies for a unique volume that is shared among multiple pods on the same node. If this field is not specified, then the supported number of volumes on this node is unbounded.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        count indicates the maximum number of unique volumes managed by the CSI driver that can be used on a node. A volume that is both attached and mounted on a node is considered to be used once, not twice. The same rule applies for a unique volume that is shared among multiple pods on the same node. If this field is not specified, then the supported number of volumes on this node is unbounded.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "count", value)


