"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from attio import errors, models, utils
from attio._hooks import HookContext
from attio.types import OptionalNullable, UNSET
from attio.utils import get_security_from_env
from attio.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, List, Mapping, Optional, Union


class Attributes(BaseSDK):
    r"""Attributes model properties of objects and lists. Some attributes, such as the `name` attribute on a person, are system-defined, while others are user-defined. Attributes are one of [many types](/docs/attribute-types) such as text, location or select. See our [objects and lists guide](/docs/objects-and-lists) for more information."""

    def get_v2_target_identifier_attributes(
        self,
        *,
        target: models.GetV2TargetIdentifierAttributesTarget,
        identifier: str,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        show_archived: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.Attribute]:
        r"""List attributes

        Lists all attributes defined on a specific object or list. Attributes are returned in the order that they are sorted by in the UI.

        Required scopes: `object_configuration:read`.

        :param target: Whether the attributes are on an object or a list.
        :param identifier:
        :param limit:
        :param offset:
        :param show_archived:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetV2TargetIdentifierAttributesRequest(
            target=target,
            identifier=identifier,
            limit=limit,
            offset=offset,
            show_archived=show_archived,
        )

        req = self._build_request(
            method="GET",
            path="/v2/{target}/{identifier}/attributes",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_/v2/{target}/{identifier}/attributes",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetV2TargetIdentifierAttributesResponse, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    async def get_v2_target_identifier_attributes_async(
        self,
        *,
        target: models.GetV2TargetIdentifierAttributesTarget,
        identifier: str,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        show_archived: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.Attribute]:
        r"""List attributes

        Lists all attributes defined on a specific object or list. Attributes are returned in the order that they are sorted by in the UI.

        Required scopes: `object_configuration:read`.

        :param target: Whether the attributes are on an object or a list.
        :param identifier:
        :param limit:
        :param offset:
        :param show_archived:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetV2TargetIdentifierAttributesRequest(
            target=target,
            identifier=identifier,
            limit=limit,
            offset=offset,
            show_archived=show_archived,
        )

        req = self._build_request_async(
            method="GET",
            path="/v2/{target}/{identifier}/attributes",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_/v2/{target}/{identifier}/attributes",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetV2TargetIdentifierAttributesResponse, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    def post_v2_target_identifier_attributes(
        self,
        *,
        target: models.PostV2TargetIdentifierAttributesTarget,
        identifier: str,
        data: Union[
            models.PostV2TargetIdentifierAttributesData,
            models.PostV2TargetIdentifierAttributesDataTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Attribute:
        r"""Create an attribute

        Creates a new attribute on either an object or a list.

        To create an attribute on an object, you must also have the `object_configuration:read-write` scope.

        To create an attribute on a list, you must also have the `list_configuration:read-write` scope.

        :param target: Whether the attribute is to be created on an object or a list.
        :param identifier:
        :param data:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PostV2TargetIdentifierAttributesRequest(
            target=target,
            identifier=identifier,
            request_body=models.PostV2TargetIdentifierAttributesRequestBody(
                data=utils.get_pydantic_model(
                    data, models.PostV2TargetIdentifierAttributesData
                ),
            ),
        )

        req = self._build_request(
            method="POST",
            path="/v2/{target}/{identifier}/attributes",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PostV2TargetIdentifierAttributesRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="post_/v2/{target}/{identifier}/attributes",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "404", "409", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PostV2TargetIdentifierAttributesResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2TargetIdentifierAttributesValidationTypeErrorData, http_res
            )
            raise errors.PostV2TargetIdentifierAttributesValidationTypeError(
                response_data, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2TargetIdentifierAttributesNotFoundErrorData, http_res
            )
            raise errors.PostV2TargetIdentifierAttributesNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2TargetIdentifierAttributesSlugConflictErrorData, http_res
            )
            raise errors.PostV2TargetIdentifierAttributesSlugConflictError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    async def post_v2_target_identifier_attributes_async(
        self,
        *,
        target: models.PostV2TargetIdentifierAttributesTarget,
        identifier: str,
        data: Union[
            models.PostV2TargetIdentifierAttributesData,
            models.PostV2TargetIdentifierAttributesDataTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Attribute:
        r"""Create an attribute

        Creates a new attribute on either an object or a list.

        To create an attribute on an object, you must also have the `object_configuration:read-write` scope.

        To create an attribute on a list, you must also have the `list_configuration:read-write` scope.

        :param target: Whether the attribute is to be created on an object or a list.
        :param identifier:
        :param data:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PostV2TargetIdentifierAttributesRequest(
            target=target,
            identifier=identifier,
            request_body=models.PostV2TargetIdentifierAttributesRequestBody(
                data=utils.get_pydantic_model(
                    data, models.PostV2TargetIdentifierAttributesData
                ),
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/v2/{target}/{identifier}/attributes",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PostV2TargetIdentifierAttributesRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="post_/v2/{target}/{identifier}/attributes",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "404", "409", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PostV2TargetIdentifierAttributesResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2TargetIdentifierAttributesValidationTypeErrorData, http_res
            )
            raise errors.PostV2TargetIdentifierAttributesValidationTypeError(
                response_data, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2TargetIdentifierAttributesNotFoundErrorData, http_res
            )
            raise errors.PostV2TargetIdentifierAttributesNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2TargetIdentifierAttributesSlugConflictErrorData, http_res
            )
            raise errors.PostV2TargetIdentifierAttributesSlugConflictError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    def get_v2_target_identifier_attributes_attribute_(
        self,
        *,
        target: models.GetV2TargetIdentifierAttributesAttributeTarget,
        identifier: str,
        attribute: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Attribute:
        r"""Get an attribute

        Gets information about a single attribute on either an object or a list.

        Required scopes: `object_configuration:read`.

        :param target: Whether the attribute is on an object or a list.
        :param identifier:
        :param attribute:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetV2TargetIdentifierAttributesAttributeRequest(
            target=target,
            identifier=identifier,
            attribute=attribute,
        )

        req = self._build_request(
            method="GET",
            path="/v2/{target}/{identifier}/attributes/{attribute}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_/v2/{target}/{identifier}/attributes/{attribute}",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetV2TargetIdentifierAttributesAttributeResponse, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.GetV2TargetIdentifierAttributesAttributeNotFoundErrorData,
                http_res,
            )
            raise errors.GetV2TargetIdentifierAttributesAttributeNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    async def get_v2_target_identifier_attributes_attribute__async(
        self,
        *,
        target: models.GetV2TargetIdentifierAttributesAttributeTarget,
        identifier: str,
        attribute: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Attribute:
        r"""Get an attribute

        Gets information about a single attribute on either an object or a list.

        Required scopes: `object_configuration:read`.

        :param target: Whether the attribute is on an object or a list.
        :param identifier:
        :param attribute:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetV2TargetIdentifierAttributesAttributeRequest(
            target=target,
            identifier=identifier,
            attribute=attribute,
        )

        req = self._build_request_async(
            method="GET",
            path="/v2/{target}/{identifier}/attributes/{attribute}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_/v2/{target}/{identifier}/attributes/{attribute}",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetV2TargetIdentifierAttributesAttributeResponse, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.GetV2TargetIdentifierAttributesAttributeNotFoundErrorData,
                http_res,
            )
            raise errors.GetV2TargetIdentifierAttributesAttributeNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    def patch_v2_target_identifier_attributes_attribute_(
        self,
        *,
        target: models.PatchV2TargetIdentifierAttributesAttributeTarget,
        identifier: str,
        attribute: str,
        data: Union[
            models.PatchV2TargetIdentifierAttributesAttributeData,
            models.PatchV2TargetIdentifierAttributesAttributeDataTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Attribute:
        r"""Update an attribute

        Updates a single attribute on a given object or list.

        Required scopes: `object_configuration:read-write`.

        :param target: Whether the attribute is on an object or a list.
        :param identifier:
        :param attribute:
        :param data:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PatchV2TargetIdentifierAttributesAttributeRequest(
            target=target,
            identifier=identifier,
            attribute=attribute,
            request_body=models.PatchV2TargetIdentifierAttributesAttributeRequestBody(
                data=utils.get_pydantic_model(
                    data, models.PatchV2TargetIdentifierAttributesAttributeData
                ),
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/v2/{target}/{identifier}/attributes/{attribute}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PatchV2TargetIdentifierAttributesAttributeRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="patch_/v2/{target}/{identifier}/attributes/{attribute}",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PatchV2TargetIdentifierAttributesAttributeResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.SystemEditUnauthorizedErrorData, http_res
            )
            raise errors.SystemEditUnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PatchV2TargetIdentifierAttributesAttributeNotFoundErrorData,
                http_res,
            )
            raise errors.PatchV2TargetIdentifierAttributesAttributeNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    async def patch_v2_target_identifier_attributes_attribute__async(
        self,
        *,
        target: models.PatchV2TargetIdentifierAttributesAttributeTarget,
        identifier: str,
        attribute: str,
        data: Union[
            models.PatchV2TargetIdentifierAttributesAttributeData,
            models.PatchV2TargetIdentifierAttributesAttributeDataTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Attribute:
        r"""Update an attribute

        Updates a single attribute on a given object or list.

        Required scopes: `object_configuration:read-write`.

        :param target: Whether the attribute is on an object or a list.
        :param identifier:
        :param attribute:
        :param data:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PatchV2TargetIdentifierAttributesAttributeRequest(
            target=target,
            identifier=identifier,
            attribute=attribute,
            request_body=models.PatchV2TargetIdentifierAttributesAttributeRequestBody(
                data=utils.get_pydantic_model(
                    data, models.PatchV2TargetIdentifierAttributesAttributeData
                ),
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/v2/{target}/{identifier}/attributes/{attribute}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PatchV2TargetIdentifierAttributesAttributeRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="patch_/v2/{target}/{identifier}/attributes/{attribute}",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PatchV2TargetIdentifierAttributesAttributeResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.SystemEditUnauthorizedErrorData, http_res
            )
            raise errors.SystemEditUnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PatchV2TargetIdentifierAttributesAttributeNotFoundErrorData,
                http_res,
            )
            raise errors.PatchV2TargetIdentifierAttributesAttributeNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    def get_v2_target_identifier_attributes_attribute_options(
        self,
        *,
        target: models.GetV2TargetIdentifierAttributesAttributeOptionsTarget,
        identifier: str,
        attribute: str,
        show_archived: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.SelectOption]:
        r"""List select options

        Lists all select options for a particular attribute on either an object or a list.

        Required scopes: `object_configuration:read`.

        :param target: Whether the attribute is on an object or a list.
        :param identifier:
        :param attribute:
        :param show_archived:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetV2TargetIdentifierAttributesAttributeOptionsRequest(
            target=target,
            identifier=identifier,
            attribute=attribute,
            show_archived=show_archived,
        )

        req = self._build_request(
            method="GET",
            path="/v2/{target}/{identifier}/attributes/{attribute}/options",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_/v2/{target}/{identifier}/attributes/{attribute}/options",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetV2TargetIdentifierAttributesAttributeOptionsResponse, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.GetV2TargetIdentifierAttributesAttributeOptionsNotFoundErrorData,
                http_res,
            )
            raise errors.GetV2TargetIdentifierAttributesAttributeOptionsNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    async def get_v2_target_identifier_attributes_attribute_options_async(
        self,
        *,
        target: models.GetV2TargetIdentifierAttributesAttributeOptionsTarget,
        identifier: str,
        attribute: str,
        show_archived: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.SelectOption]:
        r"""List select options

        Lists all select options for a particular attribute on either an object or a list.

        Required scopes: `object_configuration:read`.

        :param target: Whether the attribute is on an object or a list.
        :param identifier:
        :param attribute:
        :param show_archived:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetV2TargetIdentifierAttributesAttributeOptionsRequest(
            target=target,
            identifier=identifier,
            attribute=attribute,
            show_archived=show_archived,
        )

        req = self._build_request_async(
            method="GET",
            path="/v2/{target}/{identifier}/attributes/{attribute}/options",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_/v2/{target}/{identifier}/attributes/{attribute}/options",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetV2TargetIdentifierAttributesAttributeOptionsResponse, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.GetV2TargetIdentifierAttributesAttributeOptionsNotFoundErrorData,
                http_res,
            )
            raise errors.GetV2TargetIdentifierAttributesAttributeOptionsNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    def post_v2_target_identifier_attributes_attribute_options(
        self,
        *,
        target: models.PostV2TargetIdentifierAttributesAttributeOptionsTarget,
        identifier: str,
        attribute: str,
        data: Union[
            models.PostV2TargetIdentifierAttributesAttributeOptionsData,
            models.PostV2TargetIdentifierAttributesAttributeOptionsDataTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SelectOption:
        r"""Create a select option

        Adds a select option to a select attribute on an object or a list.

        Required scopes: `object_configuration:read-write`.

        :param target: Whether the attribute is on an object or a list.
        :param identifier:
        :param attribute:
        :param data:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PostV2TargetIdentifierAttributesAttributeOptionsRequest(
            target=target,
            identifier=identifier,
            attribute=attribute,
            request_body=models.PostV2TargetIdentifierAttributesAttributeOptionsRequestBody(
                data=utils.get_pydantic_model(
                    data, models.PostV2TargetIdentifierAttributesAttributeOptionsData
                ),
            ),
        )

        req = self._build_request(
            method="POST",
            path="/v2/{target}/{identifier}/attributes/{attribute}/options",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PostV2TargetIdentifierAttributesAttributeOptionsRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="post_/v2/{target}/{identifier}/attributes/{attribute}/options",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "404", "409", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PostV2TargetIdentifierAttributesAttributeOptionsResponse,
                http_res,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2TargetIdentifierAttributesAttributeOptionsValidationTypeErrorData,
                http_res,
            )
            raise errors.PostV2TargetIdentifierAttributesAttributeOptionsValidationTypeError(
                response_data, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2TargetIdentifierAttributesAttributeOptionsNotFoundErrorData,
                http_res,
            )
            raise errors.PostV2TargetIdentifierAttributesAttributeOptionsNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2TargetIdentifierAttributesAttributeOptionsSlugConflictErrorData,
                http_res,
            )
            raise errors.PostV2TargetIdentifierAttributesAttributeOptionsSlugConflictError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    async def post_v2_target_identifier_attributes_attribute_options_async(
        self,
        *,
        target: models.PostV2TargetIdentifierAttributesAttributeOptionsTarget,
        identifier: str,
        attribute: str,
        data: Union[
            models.PostV2TargetIdentifierAttributesAttributeOptionsData,
            models.PostV2TargetIdentifierAttributesAttributeOptionsDataTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SelectOption:
        r"""Create a select option

        Adds a select option to a select attribute on an object or a list.

        Required scopes: `object_configuration:read-write`.

        :param target: Whether the attribute is on an object or a list.
        :param identifier:
        :param attribute:
        :param data:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PostV2TargetIdentifierAttributesAttributeOptionsRequest(
            target=target,
            identifier=identifier,
            attribute=attribute,
            request_body=models.PostV2TargetIdentifierAttributesAttributeOptionsRequestBody(
                data=utils.get_pydantic_model(
                    data, models.PostV2TargetIdentifierAttributesAttributeOptionsData
                ),
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/v2/{target}/{identifier}/attributes/{attribute}/options",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PostV2TargetIdentifierAttributesAttributeOptionsRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="post_/v2/{target}/{identifier}/attributes/{attribute}/options",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "404", "409", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PostV2TargetIdentifierAttributesAttributeOptionsResponse,
                http_res,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2TargetIdentifierAttributesAttributeOptionsValidationTypeErrorData,
                http_res,
            )
            raise errors.PostV2TargetIdentifierAttributesAttributeOptionsValidationTypeError(
                response_data, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2TargetIdentifierAttributesAttributeOptionsNotFoundErrorData,
                http_res,
            )
            raise errors.PostV2TargetIdentifierAttributesAttributeOptionsNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2TargetIdentifierAttributesAttributeOptionsSlugConflictErrorData,
                http_res,
            )
            raise errors.PostV2TargetIdentifierAttributesAttributeOptionsSlugConflictError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    def patch_v2_target_identifier_attributes_attribute_options_option_(
        self,
        *,
        target: models.PatchV2TargetIdentifierAttributesAttributeOptionsOptionTarget,
        identifier: str,
        attribute: str,
        option: str,
        data: Union[
            models.PatchV2TargetIdentifierAttributesAttributeOptionsOptionData,
            models.PatchV2TargetIdentifierAttributesAttributeOptionsOptionDataTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SelectOption:
        r"""Update a select option

        Updates a select option on an attribute on either an object or a list.

        Required scopes: `object_configuration:read-write`.

        :param target: Whether the attribute is on an object or a list.
        :param identifier:
        :param attribute:
        :param option:
        :param data:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PatchV2TargetIdentifierAttributesAttributeOptionsOptionRequest(
            target=target,
            identifier=identifier,
            attribute=attribute,
            option=option,
            request_body=models.PatchV2TargetIdentifierAttributesAttributeOptionsOptionRequestBody(
                data=utils.get_pydantic_model(
                    data,
                    models.PatchV2TargetIdentifierAttributesAttributeOptionsOptionData,
                ),
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/v2/{target}/{identifier}/attributes/{attribute}/options/{option}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PatchV2TargetIdentifierAttributesAttributeOptionsOptionRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="patch_/v2/{target}/{identifier}/attributes/{attribute}/options/{option}",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "404", "409", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PatchV2TargetIdentifierAttributesAttributeOptionsOptionResponse,
                http_res,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.PatchV2TargetIdentifierAttributesAttributeOptionsOptionValueNotFoundErrorData,
                http_res,
            )
            raise errors.PatchV2TargetIdentifierAttributesAttributeOptionsOptionValueNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PatchV2TargetIdentifierAttributesAttributeOptionsOptionNotFoundErrorData,
                http_res,
            )
            raise errors.PatchV2TargetIdentifierAttributesAttributeOptionsOptionNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.PatchV2TargetIdentifierAttributesAttributeOptionsOptionSlugConflictErrorData,
                http_res,
            )
            raise errors.PatchV2TargetIdentifierAttributesAttributeOptionsOptionSlugConflictError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    async def patch_v2_target_identifier_attributes_attribute_options_option__async(
        self,
        *,
        target: models.PatchV2TargetIdentifierAttributesAttributeOptionsOptionTarget,
        identifier: str,
        attribute: str,
        option: str,
        data: Union[
            models.PatchV2TargetIdentifierAttributesAttributeOptionsOptionData,
            models.PatchV2TargetIdentifierAttributesAttributeOptionsOptionDataTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SelectOption:
        r"""Update a select option

        Updates a select option on an attribute on either an object or a list.

        Required scopes: `object_configuration:read-write`.

        :param target: Whether the attribute is on an object or a list.
        :param identifier:
        :param attribute:
        :param option:
        :param data:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PatchV2TargetIdentifierAttributesAttributeOptionsOptionRequest(
            target=target,
            identifier=identifier,
            attribute=attribute,
            option=option,
            request_body=models.PatchV2TargetIdentifierAttributesAttributeOptionsOptionRequestBody(
                data=utils.get_pydantic_model(
                    data,
                    models.PatchV2TargetIdentifierAttributesAttributeOptionsOptionData,
                ),
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/v2/{target}/{identifier}/attributes/{attribute}/options/{option}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PatchV2TargetIdentifierAttributesAttributeOptionsOptionRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="patch_/v2/{target}/{identifier}/attributes/{attribute}/options/{option}",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "404", "409", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PatchV2TargetIdentifierAttributesAttributeOptionsOptionResponse,
                http_res,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.PatchV2TargetIdentifierAttributesAttributeOptionsOptionValueNotFoundErrorData,
                http_res,
            )
            raise errors.PatchV2TargetIdentifierAttributesAttributeOptionsOptionValueNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PatchV2TargetIdentifierAttributesAttributeOptionsOptionNotFoundErrorData,
                http_res,
            )
            raise errors.PatchV2TargetIdentifierAttributesAttributeOptionsOptionNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.PatchV2TargetIdentifierAttributesAttributeOptionsOptionSlugConflictErrorData,
                http_res,
            )
            raise errors.PatchV2TargetIdentifierAttributesAttributeOptionsOptionSlugConflictError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    def get_v2_target_identifier_attributes_attribute_statuses(
        self,
        *,
        target: models.GetV2TargetIdentifierAttributesAttributeStatusesTarget,
        identifier: str,
        attribute: str,
        show_archived: Optional[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.Status]:
        r"""List statuses

        Lists all statuses for a particular status attribute on either an object or a list.

        Required scopes: `object_configuration:read`.

        :param target: Whether the attribute is on an object or a list. Please note that the company and people objects do not support status attributes at this time.
        :param identifier:
        :param attribute:
        :param show_archived:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetV2TargetIdentifierAttributesAttributeStatusesRequest(
            target=target,
            identifier=identifier,
            attribute=attribute,
            show_archived=show_archived,
        )

        req = self._build_request(
            method="GET",
            path="/v2/{target}/{identifier}/attributes/{attribute}/statuses",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_/v2/{target}/{identifier}/attributes/{attribute}/statuses",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetV2TargetIdentifierAttributesAttributeStatusesResponse,
                http_res,
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.GetV2TargetIdentifierAttributesAttributeStatusesNotFoundErrorData,
                http_res,
            )
            raise errors.GetV2TargetIdentifierAttributesAttributeStatusesNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    async def get_v2_target_identifier_attributes_attribute_statuses_async(
        self,
        *,
        target: models.GetV2TargetIdentifierAttributesAttributeStatusesTarget,
        identifier: str,
        attribute: str,
        show_archived: Optional[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.Status]:
        r"""List statuses

        Lists all statuses for a particular status attribute on either an object or a list.

        Required scopes: `object_configuration:read`.

        :param target: Whether the attribute is on an object or a list. Please note that the company and people objects do not support status attributes at this time.
        :param identifier:
        :param attribute:
        :param show_archived:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetV2TargetIdentifierAttributesAttributeStatusesRequest(
            target=target,
            identifier=identifier,
            attribute=attribute,
            show_archived=show_archived,
        )

        req = self._build_request_async(
            method="GET",
            path="/v2/{target}/{identifier}/attributes/{attribute}/statuses",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_/v2/{target}/{identifier}/attributes/{attribute}/statuses",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetV2TargetIdentifierAttributesAttributeStatusesResponse,
                http_res,
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.GetV2TargetIdentifierAttributesAttributeStatusesNotFoundErrorData,
                http_res,
            )
            raise errors.GetV2TargetIdentifierAttributesAttributeStatusesNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    def post_v2_target_identifier_attributes_attribute_statuses(
        self,
        *,
        target: models.PostV2TargetIdentifierAttributesAttributeStatusesTarget,
        identifier: str,
        attribute: str,
        data: Union[
            models.PostV2TargetIdentifierAttributesAttributeStatusesData,
            models.PostV2TargetIdentifierAttributesAttributeStatusesDataTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Status:
        r"""Create a status

        Add a new status to a status attribute on either an object or a list.

        Required scopes: `object_configuration:read-write`.

        :param target: Whether the attribute is on an object or a list. Please note that company and person objects do not support status attributes at this time.
        :param identifier:
        :param attribute:
        :param data:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PostV2TargetIdentifierAttributesAttributeStatusesRequest(
            target=target,
            identifier=identifier,
            attribute=attribute,
            request_body=models.PostV2TargetIdentifierAttributesAttributeStatusesRequestBody(
                data=utils.get_pydantic_model(
                    data, models.PostV2TargetIdentifierAttributesAttributeStatusesData
                ),
            ),
        )

        req = self._build_request(
            method="POST",
            path="/v2/{target}/{identifier}/attributes/{attribute}/statuses",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PostV2TargetIdentifierAttributesAttributeStatusesRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="post_/v2/{target}/{identifier}/attributes/{attribute}/statuses",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "404", "409", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PostV2TargetIdentifierAttributesAttributeStatusesResponse,
                http_res,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2TargetIdentifierAttributesAttributeStatusesValidationTypeErrorData,
                http_res,
            )
            raise errors.PostV2TargetIdentifierAttributesAttributeStatusesValidationTypeError(
                response_data, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2TargetIdentifierAttributesAttributeStatusesNotFoundErrorData,
                http_res,
            )
            raise errors.PostV2TargetIdentifierAttributesAttributeStatusesNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2TargetIdentifierAttributesAttributeStatusesSlugConflictErrorData,
                http_res,
            )
            raise errors.PostV2TargetIdentifierAttributesAttributeStatusesSlugConflictError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    async def post_v2_target_identifier_attributes_attribute_statuses_async(
        self,
        *,
        target: models.PostV2TargetIdentifierAttributesAttributeStatusesTarget,
        identifier: str,
        attribute: str,
        data: Union[
            models.PostV2TargetIdentifierAttributesAttributeStatusesData,
            models.PostV2TargetIdentifierAttributesAttributeStatusesDataTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Status:
        r"""Create a status

        Add a new status to a status attribute on either an object or a list.

        Required scopes: `object_configuration:read-write`.

        :param target: Whether the attribute is on an object or a list. Please note that company and person objects do not support status attributes at this time.
        :param identifier:
        :param attribute:
        :param data:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PostV2TargetIdentifierAttributesAttributeStatusesRequest(
            target=target,
            identifier=identifier,
            attribute=attribute,
            request_body=models.PostV2TargetIdentifierAttributesAttributeStatusesRequestBody(
                data=utils.get_pydantic_model(
                    data, models.PostV2TargetIdentifierAttributesAttributeStatusesData
                ),
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/v2/{target}/{identifier}/attributes/{attribute}/statuses",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PostV2TargetIdentifierAttributesAttributeStatusesRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="post_/v2/{target}/{identifier}/attributes/{attribute}/statuses",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "404", "409", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PostV2TargetIdentifierAttributesAttributeStatusesResponse,
                http_res,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2TargetIdentifierAttributesAttributeStatusesValidationTypeErrorData,
                http_res,
            )
            raise errors.PostV2TargetIdentifierAttributesAttributeStatusesValidationTypeError(
                response_data, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2TargetIdentifierAttributesAttributeStatusesNotFoundErrorData,
                http_res,
            )
            raise errors.PostV2TargetIdentifierAttributesAttributeStatusesNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2TargetIdentifierAttributesAttributeStatusesSlugConflictErrorData,
                http_res,
            )
            raise errors.PostV2TargetIdentifierAttributesAttributeStatusesSlugConflictError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    def patch_v2_target_identifier_attributes_attribute_statuses_status_(
        self,
        *,
        target: models.PatchV2TargetIdentifierAttributesAttributeStatusesStatusTarget,
        identifier: str,
        attribute: str,
        status: str,
        data: Union[
            models.PatchV2TargetIdentifierAttributesAttributeStatusesStatusData,
            models.PatchV2TargetIdentifierAttributesAttributeStatusesStatusDataTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Status:
        r"""Update a status

        Update a status on an status attribute on either an object or a list.

        Required scopes: `object_configuration:read-write`.

        :param target: Whether the attribute is on an object or a list. Please note that company and person objects do not support status attributes at this time.
        :param identifier:
        :param attribute:
        :param status:
        :param data:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PatchV2TargetIdentifierAttributesAttributeStatusesStatusRequest(
            target=target,
            identifier=identifier,
            attribute=attribute,
            status=status,
            request_body=models.PatchV2TargetIdentifierAttributesAttributeStatusesStatusRequestBody(
                data=utils.get_pydantic_model(
                    data,
                    models.PatchV2TargetIdentifierAttributesAttributeStatusesStatusData,
                ),
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/v2/{target}/{identifier}/attributes/{attribute}/statuses/{status}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PatchV2TargetIdentifierAttributesAttributeStatusesStatusRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="patch_/v2/{target}/{identifier}/attributes/{attribute}/statuses/{status}",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "404", "409", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PatchV2TargetIdentifierAttributesAttributeStatusesStatusResponse,
                http_res,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.PatchV2TargetIdentifierAttributesAttributeStatusesStatusValueNotFoundErrorData,
                http_res,
            )
            raise errors.PatchV2TargetIdentifierAttributesAttributeStatusesStatusValueNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PatchV2TargetIdentifierAttributesAttributeStatusesStatusNotFoundErrorData,
                http_res,
            )
            raise errors.PatchV2TargetIdentifierAttributesAttributeStatusesStatusNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.PatchV2TargetIdentifierAttributesAttributeStatusesStatusSlugConflictErrorData,
                http_res,
            )
            raise errors.PatchV2TargetIdentifierAttributesAttributeStatusesStatusSlugConflictError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    async def patch_v2_target_identifier_attributes_attribute_statuses_status__async(
        self,
        *,
        target: models.PatchV2TargetIdentifierAttributesAttributeStatusesStatusTarget,
        identifier: str,
        attribute: str,
        status: str,
        data: Union[
            models.PatchV2TargetIdentifierAttributesAttributeStatusesStatusData,
            models.PatchV2TargetIdentifierAttributesAttributeStatusesStatusDataTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Status:
        r"""Update a status

        Update a status on an status attribute on either an object or a list.

        Required scopes: `object_configuration:read-write`.

        :param target: Whether the attribute is on an object or a list. Please note that company and person objects do not support status attributes at this time.
        :param identifier:
        :param attribute:
        :param status:
        :param data:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PatchV2TargetIdentifierAttributesAttributeStatusesStatusRequest(
            target=target,
            identifier=identifier,
            attribute=attribute,
            status=status,
            request_body=models.PatchV2TargetIdentifierAttributesAttributeStatusesStatusRequestBody(
                data=utils.get_pydantic_model(
                    data,
                    models.PatchV2TargetIdentifierAttributesAttributeStatusesStatusData,
                ),
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/v2/{target}/{identifier}/attributes/{attribute}/statuses/{status}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PatchV2TargetIdentifierAttributesAttributeStatusesStatusRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="patch_/v2/{target}/{identifier}/attributes/{attribute}/statuses/{status}",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "404", "409", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PatchV2TargetIdentifierAttributesAttributeStatusesStatusResponse,
                http_res,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.PatchV2TargetIdentifierAttributesAttributeStatusesStatusValueNotFoundErrorData,
                http_res,
            )
            raise errors.PatchV2TargetIdentifierAttributesAttributeStatusesStatusValueNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PatchV2TargetIdentifierAttributesAttributeStatusesStatusNotFoundErrorData,
                http_res,
            )
            raise errors.PatchV2TargetIdentifierAttributesAttributeStatusesStatusNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.PatchV2TargetIdentifierAttributesAttributeStatusesStatusSlugConflictErrorData,
                http_res,
            )
            raise errors.PatchV2TargetIdentifierAttributesAttributeStatusesStatusSlugConflictError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)
