"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from attio.errors import AttioError
from attio.models import patch_v2_objects_object_op as models_patch_v2_objects_object_op
from attio.types import BaseModel
from dataclasses import dataclass, field
import httpx
from typing import Optional


class PatchV2ObjectsObjectSlugConflictErrorData(BaseModel):
    status_code: float

    type: models_patch_v2_objects_object_op.PatchV2ObjectsObjectConflictType

    code: models_patch_v2_objects_object_op.PatchV2ObjectsObjectConflictCode

    message: str


@dataclass(frozen=True)
class PatchV2ObjectsObjectSlugConflictError(AttioError):
    r"""Conflict"""

    data: PatchV2ObjectsObjectSlugConflictErrorData = field(hash=False)

    def __init__(
        self,
        data: PatchV2ObjectsObjectSlugConflictErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class PatchV2ObjectsObjectNotFoundErrorData(BaseModel):
    status_code: float

    type: models_patch_v2_objects_object_op.PatchV2ObjectsObjectNotFoundType

    code: models_patch_v2_objects_object_op.PatchV2ObjectsObjectNotFoundCode

    message: str


@dataclass(frozen=True)
class PatchV2ObjectsObjectNotFoundError(AttioError):
    r"""Not Found"""

    data: PatchV2ObjectsObjectNotFoundErrorData = field(hash=False)

    def __init__(
        self,
        data: PatchV2ObjectsObjectNotFoundErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class PatchV2ObjectsObjectValidationTypeErrorData(BaseModel):
    status_code: float

    type: models_patch_v2_objects_object_op.PatchV2ObjectsObjectBadRequestType

    code: models_patch_v2_objects_object_op.PatchV2ObjectsObjectCodeValidationType

    message: str


@dataclass(frozen=True)
class PatchV2ObjectsObjectValidationTypeError(AttioError):
    r"""Bad Request"""

    data: PatchV2ObjectsObjectValidationTypeErrorData = field(hash=False)

    def __init__(
        self,
        data: PatchV2ObjectsObjectValidationTypeErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
