"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from attio.errors import AttioError
from attio.models import (
    post_v2_lists_list_entriesop as models_post_v2_lists_list_entriesop,
)
from attio.types import BaseModel
from dataclasses import dataclass, field
import httpx
from typing import Optional


class PostV2ListsListEntriesNotFoundErrorData(BaseModel):
    status_code: float

    type: models_post_v2_lists_list_entriesop.PostV2ListsListEntriesNotFoundType

    code: models_post_v2_lists_list_entriesop.PostV2ListsListEntriesNotFoundCode

    message: str


@dataclass(frozen=True)
class PostV2ListsListEntriesNotFoundError(AttioError):
    r"""Not Found"""

    data: PostV2ListsListEntriesNotFoundErrorData = field(hash=False)

    def __init__(
        self,
        data: PostV2ListsListEntriesNotFoundErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class PostV2ListsListEntriesValueNotFoundErrorData(BaseModel):
    status_code: float

    type: models_post_v2_lists_list_entriesop.PostV2ListsListEntriesBadRequestType

    code: models_post_v2_lists_list_entriesop.PostV2ListsListEntriesCodeValueNotFound

    message: str


@dataclass(frozen=True)
class PostV2ListsListEntriesValueNotFoundError(AttioError):
    r"""Bad Request"""

    data: PostV2ListsListEntriesValueNotFoundErrorData = field(hash=False)

    def __init__(
        self,
        data: PostV2ListsListEntriesValueNotFoundErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
