"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from attio.errors import AttioError
from attio.models import (
    post_v2_target_identifier_attributesop as models_post_v2_target_identifier_attributesop,
)
from attio.types import BaseModel
from dataclasses import dataclass, field
import httpx
from typing import Optional


class PostV2TargetIdentifierAttributesSlugConflictErrorData(BaseModel):
    status_code: float

    type: models_post_v2_target_identifier_attributesop.PostV2TargetIdentifierAttributesConflictType

    code: models_post_v2_target_identifier_attributesop.PostV2TargetIdentifierAttributesConflictCode

    message: str


@dataclass(frozen=True)
class PostV2TargetIdentifierAttributesSlugConflictError(AttioError):
    r"""Conflict"""

    data: PostV2TargetIdentifierAttributesSlugConflictErrorData = field(hash=False)

    def __init__(
        self,
        data: PostV2TargetIdentifierAttributesSlugConflictErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class PostV2TargetIdentifierAttributesNotFoundErrorData(BaseModel):
    status_code: float

    type: models_post_v2_target_identifier_attributesop.PostV2TargetIdentifierAttributesNotFoundType

    code: models_post_v2_target_identifier_attributesop.PostV2TargetIdentifierAttributesNotFoundCode

    message: str


@dataclass(frozen=True)
class PostV2TargetIdentifierAttributesNotFoundError(AttioError):
    r"""Not Found"""

    data: PostV2TargetIdentifierAttributesNotFoundErrorData = field(hash=False)

    def __init__(
        self,
        data: PostV2TargetIdentifierAttributesNotFoundErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class PostV2TargetIdentifierAttributesValidationTypeErrorData(BaseModel):
    status_code: float

    type: models_post_v2_target_identifier_attributesop.PostV2TargetIdentifierAttributesBadRequestType

    code: models_post_v2_target_identifier_attributesop.PostV2TargetIdentifierAttributesCodeValidationType

    message: str


@dataclass(frozen=True)
class PostV2TargetIdentifierAttributesValidationTypeError(AttioError):
    r"""Bad Request"""

    data: PostV2TargetIdentifierAttributesValidationTypeErrorData = field(hash=False)

    def __init__(
        self,
        data: PostV2TargetIdentifierAttributesValidationTypeErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
