"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from attio.errors import AttioError
from attio.models import post_v2_tasksop as models_post_v2_tasksop
from attio.types import BaseModel
from dataclasses import dataclass, field
import httpx
from typing import Optional


class PostV2TasksNotFoundErrorData(BaseModel):
    status_code: float

    type: models_post_v2_tasksop.PostV2TasksNotFoundType

    code: models_post_v2_tasksop.PostV2TasksNotFoundCode

    message: str


@dataclass(frozen=True)
class PostV2TasksNotFoundError(AttioError):
    r"""Not Found"""

    data: PostV2TasksNotFoundErrorData = field(hash=False)

    def __init__(
        self,
        data: PostV2TasksNotFoundErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class PostV2TasksValidationTypeErrorData(BaseModel):
    status_code: float

    type: models_post_v2_tasksop.PostV2TasksBadRequestType

    code: models_post_v2_tasksop.PostV2TasksCodeValidationType

    message: str


@dataclass(frozen=True)
class PostV2TasksValidationTypeError(AttioError):
    r"""Bad Request"""

    data: PostV2TasksValidationTypeErrorData = field(hash=False)

    def __init__(
        self,
        data: PostV2TasksValidationTypeErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
