"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from attio.types import BaseModel, Nullable, UNSET_SENTINEL
from attio.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptRequestTypedDict(
    TypedDict
):
    meeting_id: str
    call_recording_id: str
    cursor: NotRequired[str]


class GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptRequest(BaseModel):
    meeting_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    call_recording_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    cursor: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None


class GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptIDTypedDict(
    TypedDict
):
    workspace_id: str
    r"""The ID of the workspace this transcript belongs to."""
    meeting_id: str
    r"""The ID of the meeting associated with this transcript."""
    call_recording_id: str
    r"""The ID of the call recording this transcript belongs to."""


class GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptID(BaseModel):
    workspace_id: str
    r"""The ID of the workspace this transcript belongs to."""

    meeting_id: str
    r"""The ID of the meeting associated with this transcript."""

    call_recording_id: str
    r"""The ID of the call recording this transcript belongs to."""


class SpeakerTypedDict(TypedDict):
    r"""The speaker of this transcript segment."""

    name: str
    r"""The name of the speaker."""


class Speaker(BaseModel):
    r"""The speaker of this transcript segment."""

    name: str
    r"""The name of the speaker."""


class TranscriptTypedDict(TypedDict):
    speech: str
    r"""The spoken text for this segment of the transcript."""
    start_time: float
    r"""The start time of this speech segment in seconds, measured from the start of the recording."""
    end_time: float
    r"""The end time of this speech segment in seconds, measured from the start of the recording."""
    speaker: SpeakerTypedDict
    r"""The speaker of this transcript segment."""


class Transcript(BaseModel):
    speech: str
    r"""The spoken text for this segment of the transcript."""

    start_time: float
    r"""The start time of this speech segment in seconds, measured from the start of the recording."""

    end_time: float
    r"""The end time of this speech segment in seconds, measured from the start of the recording."""

    speaker: Speaker
    r"""The speaker of this transcript segment."""


class GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptDataTypedDict(
    TypedDict
):
    id: GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptIDTypedDict
    transcript: List[TranscriptTypedDict]
    r"""The transcript segments with speech, timing, and speaker information."""
    raw_transcript: str
    r"""The raw transcript of the call recording."""
    web_url: str
    r"""A URL that links directly to the call recording transcript in the Attio web application."""


class GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptData(BaseModel):
    id: GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptID

    transcript: List[Transcript]
    r"""The transcript segments with speech, timing, and speaker information."""

    raw_transcript: str
    r"""The raw transcript of the call recording."""

    web_url: str
    r"""A URL that links directly to the call recording transcript in the Attio web application."""


class GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptPaginationTypedDict(
    TypedDict
):
    next_cursor: Nullable[str]


class GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptPagination(
    BaseModel
):
    next_cursor: Nullable[str]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["next_cursor"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptResponseTypedDict(
    TypedDict
):
    r"""Success"""

    data: GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptDataTypedDict
    pagination: (
        GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptPaginationTypedDict
    )


class GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptResponse(BaseModel):
    r"""Success"""

    data: GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptData

    pagination: GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptPagination
