"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from attio.types import BaseModel, Nullable, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Literal, Union
from typing_extensions import TypeAliasType, TypedDict


TokenType = Literal["Bearer",]
r"""The type of token, always Bearer for tokens acquired via the OAuth 2.0 flow."""


Iss = Literal["attio.com",]
r"""The issuer of the token. Always attio.com"""


class AttioComTypedDict(TypedDict):
    active: bool
    r"""Whether the token is currently active and usable."""
    scope: str
    r"""A space-separated list of scopes associated with this token"""
    client_id: str
    r"""The app ID of the OAuth application that requested this token"""
    token_type: TokenType
    r"""The type of token, always Bearer for tokens acquired via the OAuth 2.0 flow."""
    exp: Nullable[float]
    r"""The time at which this token will expire, if set, as a number of seconds since January 1 1970 UTC."""
    iat: float
    r"""The time at which this token was issued, as a number of seconds since January 1 1970 UTC."""
    sub: str
    r"""Since Bearer tokens grant Workspace-level permissions, this property contains the workspace_id."""
    aud: str
    r"""The intended audience for this token, for Bearer tokens this is the same as the client_id."""
    iss: Iss
    r"""The issuer of the token. Always attio.com"""
    authorized_by_workspace_member_id: str
    r"""The ID of the workspace member who authorised this token initially."""
    workspace_id: str
    r"""The ID of the workspace the token is scoped to."""
    workspace_name: str
    r"""The name of the workspace the token is scoped to."""
    workspace_slug: str
    r"""The slug of the workspace the token is scoped to."""
    workspace_logo_url: Nullable[str]
    r"""The logo URL of the workspace the token is scoped to."""


class AttioCom(BaseModel):
    active: bool
    r"""Whether the token is currently active and usable."""

    scope: str
    r"""A space-separated list of scopes associated with this token"""

    client_id: str
    r"""The app ID of the OAuth application that requested this token"""

    token_type: TokenType
    r"""The type of token, always Bearer for tokens acquired via the OAuth 2.0 flow."""

    exp: Nullable[float]
    r"""The time at which this token will expire, if set, as a number of seconds since January 1 1970 UTC."""

    iat: float
    r"""The time at which this token was issued, as a number of seconds since January 1 1970 UTC."""

    sub: str
    r"""Since Bearer tokens grant Workspace-level permissions, this property contains the workspace_id."""

    aud: str
    r"""The intended audience for this token, for Bearer tokens this is the same as the client_id."""

    iss: Iss
    r"""The issuer of the token. Always attio.com"""

    authorized_by_workspace_member_id: str
    r"""The ID of the workspace member who authorised this token initially."""

    workspace_id: str
    r"""The ID of the workspace the token is scoped to."""

    workspace_name: str
    r"""The name of the workspace the token is scoped to."""

    workspace_slug: str
    r"""The slug of the workspace the token is scoped to."""

    workspace_logo_url: Nullable[str]
    r"""The logo URL of the workspace the token is scoped to."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["exp", "workspace_logo_url"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ResponseBodyTypedDict(TypedDict):
    active: bool


class ResponseBody(BaseModel):
    active: bool


GetV2SelfResponseTypedDict = TypeAliasType(
    "GetV2SelfResponseTypedDict", Union[ResponseBodyTypedDict, AttioComTypedDict]
)
r"""Success"""


GetV2SelfResponse = TypeAliasType("GetV2SelfResponse", Union[ResponseBody, AttioCom])
r"""Success"""
