"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .task import Task, TaskTypedDict
from attio.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from attio.utils import FieldMetadata, QueryParamMetadata
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


GetV2TasksSort = Literal[
    "created_at:asc",
    "created_at:desc",
]
r"""Optionally sort the results. \"created_at:asc\" returns oldest results first, \"created_at:desc\" returns the newest results first. If unspecified, defaults to \"created_at:asc\" (oldest results first)."""


class GetV2TasksRequestTypedDict(TypedDict):
    limit: NotRequired[int]
    offset: NotRequired[int]
    sort: NotRequired[GetV2TasksSort]
    r"""Optionally sort the results. \"created_at:asc\" returns oldest results first, \"created_at:desc\" returns the newest results first. If unspecified, defaults to \"created_at:asc\" (oldest results first)."""
    linked_object: NotRequired[str]
    linked_record_id: NotRequired[str]
    assignee: NotRequired[Nullable[str]]
    is_completed: NotRequired[bool]


class GetV2TasksRequest(BaseModel):
    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    sort: Annotated[
        Optional[GetV2TasksSort],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Optionally sort the results. \"created_at:asc\" returns oldest results first, \"created_at:desc\" returns the newest results first. If unspecified, defaults to \"created_at:asc\" (oldest results first)."""

    linked_object: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    linked_record_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    assignee: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET

    is_completed: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "limit",
            "offset",
            "sort",
            "linked_object",
            "linked_record_id",
            "assignee",
            "is_completed",
        ]
        nullable_fields = ["assignee"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetV2TasksResponseTypedDict(TypedDict):
    r"""Success"""

    data: List[TaskTypedDict]


class GetV2TasksResponse(BaseModel):
    r"""Success"""

    data: List[Task]
