"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from attio.types import BaseModel, Nullable, UNSET_SENTINEL
from attio.utils import FieldMetadata, PathParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


class GetV2WebhooksWebhookIDRequestTypedDict(TypedDict):
    webhook_id: str


class GetV2WebhooksWebhookIDRequest(BaseModel):
    webhook_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]


GetV2WebhooksWebhookIDType = Literal["invalid_request_error",]


GetV2WebhooksWebhookIDCode = Literal["not_found",]


GetV2WebhooksWebhookIDEventType = Literal[
    "call-recording.created",
    "comment.created",
    "comment.resolved",
    "comment.unresolved",
    "comment.deleted",
    "list.created",
    "list.updated",
    "list.deleted",
    "list-attribute.created",
    "list-attribute.updated",
    "list-entry.created",
    "list-entry.updated",
    "list-entry.deleted",
    "object-attribute.created",
    "object-attribute.updated",
    "note.created",
    "note-content.updated",
    "note.updated",
    "note.deleted",
    "record.created",
    "record.merged",
    "record.updated",
    "record.deleted",
    "task.created",
    "task.updated",
    "task.deleted",
    "workspace-member.created",
]
r"""Type of event the webhook is subscribed to."""


GetV2WebhooksWebhookIDDollarAndOperatorNotEquals = Literal["not_equals",]


class GetV2WebhooksWebhookIDDollarAndNotEqualsTypedDict(TypedDict):
    field: str
    operator: GetV2WebhooksWebhookIDDollarAndOperatorNotEquals
    value: str


class GetV2WebhooksWebhookIDDollarAndNotEquals(BaseModel):
    field: str

    operator: GetV2WebhooksWebhookIDDollarAndOperatorNotEquals

    value: str


GetV2WebhooksWebhookIDDollarAndOperatorEquals = Literal["equals",]


class GetV2WebhooksWebhookIDDollarAndEqualsTypedDict(TypedDict):
    field: str
    operator: GetV2WebhooksWebhookIDDollarAndOperatorEquals
    value: str


class GetV2WebhooksWebhookIDDollarAndEquals(BaseModel):
    field: str

    operator: GetV2WebhooksWebhookIDDollarAndOperatorEquals

    value: str


GetV2WebhooksWebhookIDDollarAndUnionTypedDict = TypeAliasType(
    "GetV2WebhooksWebhookIDDollarAndUnionTypedDict",
    Union[
        GetV2WebhooksWebhookIDDollarAndEqualsTypedDict,
        GetV2WebhooksWebhookIDDollarAndNotEqualsTypedDict,
    ],
)


GetV2WebhooksWebhookIDDollarAndUnion = TypeAliasType(
    "GetV2WebhooksWebhookIDDollarAndUnion",
    Union[
        GetV2WebhooksWebhookIDDollarAndEquals, GetV2WebhooksWebhookIDDollarAndNotEquals
    ],
)


class GetV2WebhooksWebhookIDFilter2TypedDict(TypedDict):
    dollar_and: List[GetV2WebhooksWebhookIDDollarAndUnionTypedDict]


class GetV2WebhooksWebhookIDFilter2(BaseModel):
    dollar_and: Annotated[
        List[GetV2WebhooksWebhookIDDollarAndUnion], pydantic.Field(alias="$and")
    ]


GetV2WebhooksWebhookIDDollarOrOperatorNotEquals = Literal["not_equals",]


class GetV2WebhooksWebhookIDDollarOrNotEqualsTypedDict(TypedDict):
    field: str
    operator: GetV2WebhooksWebhookIDDollarOrOperatorNotEquals
    value: str


class GetV2WebhooksWebhookIDDollarOrNotEquals(BaseModel):
    field: str

    operator: GetV2WebhooksWebhookIDDollarOrOperatorNotEquals

    value: str


GetV2WebhooksWebhookIDDollarOrOperatorEquals = Literal["equals",]


class GetV2WebhooksWebhookIDDollarOrEqualsTypedDict(TypedDict):
    field: str
    operator: GetV2WebhooksWebhookIDDollarOrOperatorEquals
    value: str


class GetV2WebhooksWebhookIDDollarOrEquals(BaseModel):
    field: str

    operator: GetV2WebhooksWebhookIDDollarOrOperatorEquals

    value: str


GetV2WebhooksWebhookIDDollarOrUnionTypedDict = TypeAliasType(
    "GetV2WebhooksWebhookIDDollarOrUnionTypedDict",
    Union[
        GetV2WebhooksWebhookIDDollarOrEqualsTypedDict,
        GetV2WebhooksWebhookIDDollarOrNotEqualsTypedDict,
    ],
)


GetV2WebhooksWebhookIDDollarOrUnion = TypeAliasType(
    "GetV2WebhooksWebhookIDDollarOrUnion",
    Union[
        GetV2WebhooksWebhookIDDollarOrEquals, GetV2WebhooksWebhookIDDollarOrNotEquals
    ],
)


class GetV2WebhooksWebhookIDFilter1TypedDict(TypedDict):
    dollar_or: List[GetV2WebhooksWebhookIDDollarOrUnionTypedDict]


class GetV2WebhooksWebhookIDFilter1(BaseModel):
    dollar_or: Annotated[
        List[GetV2WebhooksWebhookIDDollarOrUnion], pydantic.Field(alias="$or")
    ]


GetV2WebhooksWebhookIDFilterUnionTypedDict = TypeAliasType(
    "GetV2WebhooksWebhookIDFilterUnionTypedDict",
    Union[
        GetV2WebhooksWebhookIDFilter1TypedDict, GetV2WebhooksWebhookIDFilter2TypedDict
    ],
)
r"""Filters to determine whether the webhook event should be sent. If null, the filter always passes."""


GetV2WebhooksWebhookIDFilterUnion = TypeAliasType(
    "GetV2WebhooksWebhookIDFilterUnion",
    Union[GetV2WebhooksWebhookIDFilter1, GetV2WebhooksWebhookIDFilter2],
)
r"""Filters to determine whether the webhook event should be sent. If null, the filter always passes."""


class GetV2WebhooksWebhookIDSubscriptionTypedDict(TypedDict):
    event_type: GetV2WebhooksWebhookIDEventType
    r"""Type of event the webhook is subscribed to."""
    filter_: Nullable[GetV2WebhooksWebhookIDFilterUnionTypedDict]
    r"""Filters to determine whether the webhook event should be sent. If null, the filter always passes."""


class GetV2WebhooksWebhookIDSubscription(BaseModel):
    event_type: GetV2WebhooksWebhookIDEventType
    r"""Type of event the webhook is subscribed to."""

    filter_: Annotated[
        Nullable[GetV2WebhooksWebhookIDFilterUnion], pydantic.Field(alias="filter")
    ]
    r"""Filters to determine whether the webhook event should be sent. If null, the filter always passes."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["filter"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetV2WebhooksWebhookIDIDTypedDict(TypedDict):
    workspace_id: str
    r"""The ID of the workspace the webhook belongs to."""
    webhook_id: str
    r"""The ID of the webhook."""


class GetV2WebhooksWebhookIDID(BaseModel):
    workspace_id: str
    r"""The ID of the workspace the webhook belongs to."""

    webhook_id: str
    r"""The ID of the webhook."""


GetV2WebhooksWebhookIDStatus = Literal[
    "active",
    "degraded",
    "inactive",
]
r"""The state of the webhook. Webhooks marked as active and degraded will receive events, inactive ones will not. If a webhook remains in the degraded state for 7 days, it will be marked inactive."""


class GetV2WebhooksWebhookIDDataTypedDict(TypedDict):
    target_url: str
    r"""URL where the webhook events will be delivered to."""
    subscriptions: List[GetV2WebhooksWebhookIDSubscriptionTypedDict]
    r"""One or more events the webhook is subscribed to."""
    id: GetV2WebhooksWebhookIDIDTypedDict
    status: GetV2WebhooksWebhookIDStatus
    r"""The state of the webhook. Webhooks marked as active and degraded will receive events, inactive ones will not. If a webhook remains in the degraded state for 7 days, it will be marked inactive."""
    created_at: str
    r"""When the webhook was created."""


class GetV2WebhooksWebhookIDData(BaseModel):
    target_url: str
    r"""URL where the webhook events will be delivered to."""

    subscriptions: List[GetV2WebhooksWebhookIDSubscription]
    r"""One or more events the webhook is subscribed to."""

    id: GetV2WebhooksWebhookIDID

    status: GetV2WebhooksWebhookIDStatus
    r"""The state of the webhook. Webhooks marked as active and degraded will receive events, inactive ones will not. If a webhook remains in the degraded state for 7 days, it will be marked inactive."""

    created_at: str
    r"""When the webhook was created."""


class GetV2WebhooksWebhookIDResponseTypedDict(TypedDict):
    r"""Success"""

    data: GetV2WebhooksWebhookIDDataTypedDict


class GetV2WebhooksWebhookIDResponse(BaseModel):
    r"""Success"""

    data: GetV2WebhooksWebhookIDData
