"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from attio.types import BaseModel, Nullable, UNSET_SENTINEL
from attio.utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class GetV2WebhooksRequestTypedDict(TypedDict):
    limit: NotRequired[int]
    offset: NotRequired[int]


class GetV2WebhooksRequest(BaseModel):
    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None


GetV2WebhooksEventType = Literal[
    "call-recording.created",
    "comment.created",
    "comment.resolved",
    "comment.unresolved",
    "comment.deleted",
    "list.created",
    "list.updated",
    "list.deleted",
    "list-attribute.created",
    "list-attribute.updated",
    "list-entry.created",
    "list-entry.updated",
    "list-entry.deleted",
    "object-attribute.created",
    "object-attribute.updated",
    "note.created",
    "note-content.updated",
    "note.updated",
    "note.deleted",
    "record.created",
    "record.merged",
    "record.updated",
    "record.deleted",
    "task.created",
    "task.updated",
    "task.deleted",
    "workspace-member.created",
]
r"""Type of event the webhook is subscribed to."""


GetV2WebhooksDollarAndOperatorNotEquals = Literal["not_equals",]


class GetV2WebhooksDollarAndNotEqualsTypedDict(TypedDict):
    field: str
    operator: GetV2WebhooksDollarAndOperatorNotEquals
    value: str


class GetV2WebhooksDollarAndNotEquals(BaseModel):
    field: str

    operator: GetV2WebhooksDollarAndOperatorNotEquals

    value: str


GetV2WebhooksDollarAndOperatorEquals = Literal["equals",]


class GetV2WebhooksDollarAndEqualsTypedDict(TypedDict):
    field: str
    operator: GetV2WebhooksDollarAndOperatorEquals
    value: str


class GetV2WebhooksDollarAndEquals(BaseModel):
    field: str

    operator: GetV2WebhooksDollarAndOperatorEquals

    value: str


GetV2WebhooksDollarAndUnionTypedDict = TypeAliasType(
    "GetV2WebhooksDollarAndUnionTypedDict",
    Union[
        GetV2WebhooksDollarAndEqualsTypedDict, GetV2WebhooksDollarAndNotEqualsTypedDict
    ],
)


GetV2WebhooksDollarAndUnion = TypeAliasType(
    "GetV2WebhooksDollarAndUnion",
    Union[GetV2WebhooksDollarAndEquals, GetV2WebhooksDollarAndNotEquals],
)


class GetV2WebhooksFilter2TypedDict(TypedDict):
    dollar_and: List[GetV2WebhooksDollarAndUnionTypedDict]


class GetV2WebhooksFilter2(BaseModel):
    dollar_and: Annotated[
        List[GetV2WebhooksDollarAndUnion], pydantic.Field(alias="$and")
    ]


GetV2WebhooksDollarOrOperatorNotEquals = Literal["not_equals",]


class GetV2WebhooksDollarOrNotEqualsTypedDict(TypedDict):
    field: str
    operator: GetV2WebhooksDollarOrOperatorNotEquals
    value: str


class GetV2WebhooksDollarOrNotEquals(BaseModel):
    field: str

    operator: GetV2WebhooksDollarOrOperatorNotEquals

    value: str


GetV2WebhooksDollarOrOperatorEquals = Literal["equals",]


class GetV2WebhooksDollarOrEqualsTypedDict(TypedDict):
    field: str
    operator: GetV2WebhooksDollarOrOperatorEquals
    value: str


class GetV2WebhooksDollarOrEquals(BaseModel):
    field: str

    operator: GetV2WebhooksDollarOrOperatorEquals

    value: str


GetV2WebhooksDollarOrUnionTypedDict = TypeAliasType(
    "GetV2WebhooksDollarOrUnionTypedDict",
    Union[
        GetV2WebhooksDollarOrEqualsTypedDict, GetV2WebhooksDollarOrNotEqualsTypedDict
    ],
)


GetV2WebhooksDollarOrUnion = TypeAliasType(
    "GetV2WebhooksDollarOrUnion",
    Union[GetV2WebhooksDollarOrEquals, GetV2WebhooksDollarOrNotEquals],
)


class GetV2WebhooksFilter1TypedDict(TypedDict):
    dollar_or: List[GetV2WebhooksDollarOrUnionTypedDict]


class GetV2WebhooksFilter1(BaseModel):
    dollar_or: Annotated[List[GetV2WebhooksDollarOrUnion], pydantic.Field(alias="$or")]


GetV2WebhooksFilterUnionTypedDict = TypeAliasType(
    "GetV2WebhooksFilterUnionTypedDict",
    Union[GetV2WebhooksFilter1TypedDict, GetV2WebhooksFilter2TypedDict],
)
r"""Filters to determine whether the webhook event should be sent. If null, the filter always passes."""


GetV2WebhooksFilterUnion = TypeAliasType(
    "GetV2WebhooksFilterUnion", Union[GetV2WebhooksFilter1, GetV2WebhooksFilter2]
)
r"""Filters to determine whether the webhook event should be sent. If null, the filter always passes."""


class GetV2WebhooksSubscriptionTypedDict(TypedDict):
    event_type: GetV2WebhooksEventType
    r"""Type of event the webhook is subscribed to."""
    filter_: Nullable[GetV2WebhooksFilterUnionTypedDict]
    r"""Filters to determine whether the webhook event should be sent. If null, the filter always passes."""


class GetV2WebhooksSubscription(BaseModel):
    event_type: GetV2WebhooksEventType
    r"""Type of event the webhook is subscribed to."""

    filter_: Annotated[
        Nullable[GetV2WebhooksFilterUnion], pydantic.Field(alias="filter")
    ]
    r"""Filters to determine whether the webhook event should be sent. If null, the filter always passes."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["filter"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetV2WebhooksIDTypedDict(TypedDict):
    workspace_id: str
    r"""The ID of the workspace the webhook belongs to."""
    webhook_id: str
    r"""The ID of the webhook."""


class GetV2WebhooksID(BaseModel):
    workspace_id: str
    r"""The ID of the workspace the webhook belongs to."""

    webhook_id: str
    r"""The ID of the webhook."""


GetV2WebhooksStatus = Literal[
    "active",
    "degraded",
    "inactive",
]
r"""The state of the webhook. Webhooks marked as active and degraded will receive events, inactive ones will not. If a webhook remains in the degraded state for 7 days, it will be marked inactive."""


class GetV2WebhooksDataTypedDict(TypedDict):
    target_url: str
    r"""URL where the webhook events will be delivered to."""
    subscriptions: List[GetV2WebhooksSubscriptionTypedDict]
    r"""One or more events the webhook is subscribed to."""
    id: GetV2WebhooksIDTypedDict
    status: GetV2WebhooksStatus
    r"""The state of the webhook. Webhooks marked as active and degraded will receive events, inactive ones will not. If a webhook remains in the degraded state for 7 days, it will be marked inactive."""
    created_at: str
    r"""When the webhook was created."""


class GetV2WebhooksData(BaseModel):
    target_url: str
    r"""URL where the webhook events will be delivered to."""

    subscriptions: List[GetV2WebhooksSubscription]
    r"""One or more events the webhook is subscribed to."""

    id: GetV2WebhooksID

    status: GetV2WebhooksStatus
    r"""The state of the webhook. Webhooks marked as active and degraded will receive events, inactive ones will not. If a webhook remains in the degraded state for 7 days, it will be marked inactive."""

    created_at: str
    r"""When the webhook was created."""


class GetV2WebhooksResponseTypedDict(TypedDict):
    r"""Success"""

    data: List[GetV2WebhooksDataTypedDict]


class GetV2WebhooksResponse(BaseModel):
    r"""Success"""

    data: List[GetV2WebhooksData]
