"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .list import ListT, ListTTypedDict
from attio.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from attio.utils import FieldMetadata, PathParamMetadata, RequestMetadata
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


PatchV2ListsListWorkspaceAccess = Literal[
    "full-access",
    "read-and-write",
    "read-only",
]
r"""The level of access granted to all members of the workspace for this list. Pass `null` to keep the list private and only grant access to specific workspace members."""


PatchV2ListsListLevel = Literal[
    "full-access",
    "read-and-write",
    "read-only",
]
r"""The level of access to the list."""


class PatchV2ListsListWorkspaceMemberAccessTypedDict(TypedDict):
    workspace_member_id: str
    r"""A UUID to identify the workspace member to grant access to."""
    level: PatchV2ListsListLevel
    r"""The level of access to the list."""


class PatchV2ListsListWorkspaceMemberAccess(BaseModel):
    workspace_member_id: str
    r"""A UUID to identify the workspace member to grant access to."""

    level: PatchV2ListsListLevel
    r"""The level of access to the list."""


class PatchV2ListsListDataTypedDict(TypedDict):
    name: NotRequired[str]
    r"""The human-readable name of the list."""
    api_slug: NotRequired[str]
    r"""A unique, human-readable slug to access the list through API calls. Should be formatted in snake case."""
    workspace_access: NotRequired[Nullable[PatchV2ListsListWorkspaceAccess]]
    r"""The level of access granted to all members of the workspace for this list. Pass `null` to keep the list private and only grant access to specific workspace members."""
    workspace_member_access: NotRequired[
        List[PatchV2ListsListWorkspaceMemberAccessTypedDict]
    ]
    r"""The level of access granted to specific workspace members for this list. Pass an empty array to grant access to no workspace members."""


class PatchV2ListsListData(BaseModel):
    name: Optional[str] = None
    r"""The human-readable name of the list."""

    api_slug: Optional[str] = None
    r"""A unique, human-readable slug to access the list through API calls. Should be formatted in snake case."""

    workspace_access: OptionalNullable[PatchV2ListsListWorkspaceAccess] = UNSET
    r"""The level of access granted to all members of the workspace for this list. Pass `null` to keep the list private and only grant access to specific workspace members."""

    workspace_member_access: Optional[List[PatchV2ListsListWorkspaceMemberAccess]] = (
        None
    )
    r"""The level of access granted to specific workspace members for this list. Pass an empty array to grant access to no workspace members."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "name",
            "api_slug",
            "workspace_access",
            "workspace_member_access",
        ]
        nullable_fields = ["workspace_access"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PatchV2ListsListRequestBodyTypedDict(TypedDict):
    data: PatchV2ListsListDataTypedDict


class PatchV2ListsListRequestBody(BaseModel):
    data: PatchV2ListsListData


class PatchV2ListsListRequestTypedDict(TypedDict):
    list: str
    request_body: PatchV2ListsListRequestBodyTypedDict


class PatchV2ListsListRequest(BaseModel):
    list: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    request_body: Annotated[
        PatchV2ListsListRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


PatchV2ListsListNotFoundType = Literal["invalid_request_error",]


PatchV2ListsListNotFoundCode = Literal["not_found",]


PatchV2ListsListBadRequestType = Literal["invalid_request_error",]


PatchV2ListsListCodeValueNotFound = Literal["value_not_found",]


class PatchV2ListsListResponseTypedDict(TypedDict):
    r"""Success"""

    data: ListTTypedDict


class PatchV2ListsListResponse(BaseModel):
    r"""Success"""

    data: ListT
