"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .status import Status, StatusTypedDict
from attio.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from attio.utils import FieldMetadata, PathParamMetadata, RequestMetadata
from pydantic import model_serializer
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


PatchV2TargetIdentifierAttributesAttributeStatusesStatusTarget = Literal[
    "lists",
    "objects",
]
r"""Whether the attribute is on an object or a list. Please note that company and person objects do not support status attributes at this time."""


class PatchV2TargetIdentifierAttributesAttributeStatusesStatusDataTypedDict(TypedDict):
    title: NotRequired[str]
    r"""The Title of the status"""
    celebration_enabled: NotRequired[bool]
    r"""Whether arriving at this status triggers a celebration effect"""
    target_time_in_status: NotRequired[Nullable[str]]
    r"""Target time for a record to spend in given status expressed as a ISO-8601 duration string"""
    is_archived: NotRequired[bool]
    r"""Whether or not to archive the status. See our [archiving guide](/docs/archiving-vs-deleting) for more information on archiving."""


class PatchV2TargetIdentifierAttributesAttributeStatusesStatusData(BaseModel):
    title: Optional[str] = None
    r"""The Title of the status"""

    celebration_enabled: Optional[bool] = False
    r"""Whether arriving at this status triggers a celebration effect"""

    target_time_in_status: OptionalNullable[str] = UNSET
    r"""Target time for a record to spend in given status expressed as a ISO-8601 duration string"""

    is_archived: Optional[bool] = None
    r"""Whether or not to archive the status. See our [archiving guide](/docs/archiving-vs-deleting) for more information on archiving."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "title",
            "celebration_enabled",
            "target_time_in_status",
            "is_archived",
        ]
        nullable_fields = ["target_time_in_status"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PatchV2TargetIdentifierAttributesAttributeStatusesStatusRequestBodyTypedDict(
    TypedDict
):
    data: PatchV2TargetIdentifierAttributesAttributeStatusesStatusDataTypedDict


class PatchV2TargetIdentifierAttributesAttributeStatusesStatusRequestBody(BaseModel):
    data: PatchV2TargetIdentifierAttributesAttributeStatusesStatusData


class PatchV2TargetIdentifierAttributesAttributeStatusesStatusRequestTypedDict(
    TypedDict
):
    target: PatchV2TargetIdentifierAttributesAttributeStatusesStatusTarget
    r"""Whether the attribute is on an object or a list. Please note that company and person objects do not support status attributes at this time."""
    identifier: str
    attribute: str
    status: str
    request_body: (
        PatchV2TargetIdentifierAttributesAttributeStatusesStatusRequestBodyTypedDict
    )


class PatchV2TargetIdentifierAttributesAttributeStatusesStatusRequest(BaseModel):
    target: Annotated[
        PatchV2TargetIdentifierAttributesAttributeStatusesStatusTarget,
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Whether the attribute is on an object or a list. Please note that company and person objects do not support status attributes at this time."""

    identifier: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    attribute: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    status: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    request_body: Annotated[
        PatchV2TargetIdentifierAttributesAttributeStatusesStatusRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


PatchV2TargetIdentifierAttributesAttributeStatusesStatusConflictType = Literal[
    "invalid_request_error",
]


PatchV2TargetIdentifierAttributesAttributeStatusesStatusConflictCode = Literal[
    "slug_conflict",
]


PatchV2TargetIdentifierAttributesAttributeStatusesStatusNotFoundType = Literal[
    "invalid_request_error",
]


PatchV2TargetIdentifierAttributesAttributeStatusesStatusNotFoundCode = Literal[
    "not_found",
]


PatchV2TargetIdentifierAttributesAttributeStatusesStatusBadRequestType = Literal[
    "invalid_request_error",
]


PatchV2TargetIdentifierAttributesAttributeStatusesStatusCodeValueNotFound = Literal[
    "value_not_found",
]


class PatchV2TargetIdentifierAttributesAttributeStatusesStatusResponseTypedDict(
    TypedDict
):
    r"""Success"""

    data: StatusTypedDict


class PatchV2TargetIdentifierAttributesAttributeStatusesStatusResponse(BaseModel):
    r"""Success"""

    data: Status
