"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .note import Note, NoteTypedDict
from attio.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


PostV2NotesFormat = Literal[
    "plaintext",
    "markdown",
]
r"""Specify the format for the note's content. Choose from:
- `plaintext`: Standard text format where `\n` signifies a new line.
- `markdown`: Enables rich text formatting using a subset of Markdown syntax:
- **Headings**: Levels 1-3 (`#`, `##`, `###`).
- **Lists**: Unordered (`-`, `*`, `+`) and ordered (`1.`, `2.`).
- **Text styles**: Bold (`**bold**` or `__bold__`), italic (`*italic*` or `_italic_`), strikethrough (`~~strikethrough~~`), and highlight (`==highlighted==`).
- **Links**: Standard Markdown links (`[link text](https://example.com)`).

*Note: While the Attio interface supports image embeds, they cannot currently be added or retrieved via the API's markdown format.*
"""


class PostV2NotesDataTypedDict(TypedDict):
    parent_object: str
    r"""The ID or slug of the parent object the note belongs to."""
    parent_record_id: str
    r"""The ID of the parent record the note belongs to."""
    title: str
    r"""The note title. The title is plaintext only and has no formatting."""
    format_: PostV2NotesFormat
    r"""Specify the format for the note's content. Choose from:
    - `plaintext`: Standard text format where `\n` signifies a new line.
    - `markdown`: Enables rich text formatting using a subset of Markdown syntax:
    - **Headings**: Levels 1-3 (`#`, `##`, `###`).
    - **Lists**: Unordered (`-`, `*`, `+`) and ordered (`1.`, `2.`).
    - **Text styles**: Bold (`**bold**` or `__bold__`), italic (`*italic*` or `_italic_`), strikethrough (`~~strikethrough~~`), and highlight (`==highlighted==`).
    - **Links**: Standard Markdown links (`[link text](https://example.com)`).

    *Note: While the Attio interface supports image embeds, they cannot currently be added or retrieved via the API's markdown format.*
    """
    content: str
    r"""The main content of the note, formatted according to the value provided in the `format` field. Use `\n` for line breaks in `plaintext`. For `markdown`, utilize the supported syntax elements to structure and style your note."""
    created_at: NotRequired[str]
    r"""`created_at` will default to the current time. However, if you wish to backdate a note for migration or other purposes, you can override with a custom `created_at` value. Note that dates before 1970 or in the future are not allowed."""
    meeting_id: NotRequired[Nullable[str]]
    r"""An optional ID to associate this note with a meeting. If provided, the meeting must exist. Use `null` to explicitly set no meeting association."""


class PostV2NotesData(BaseModel):
    parent_object: str
    r"""The ID or slug of the parent object the note belongs to."""

    parent_record_id: str
    r"""The ID of the parent record the note belongs to."""

    title: str
    r"""The note title. The title is plaintext only and has no formatting."""

    format_: Annotated[PostV2NotesFormat, pydantic.Field(alias="format")]
    r"""Specify the format for the note's content. Choose from:
    - `plaintext`: Standard text format where `\n` signifies a new line.
    - `markdown`: Enables rich text formatting using a subset of Markdown syntax:
    - **Headings**: Levels 1-3 (`#`, `##`, `###`).
    - **Lists**: Unordered (`-`, `*`, `+`) and ordered (`1.`, `2.`).
    - **Text styles**: Bold (`**bold**` or `__bold__`), italic (`*italic*` or `_italic_`), strikethrough (`~~strikethrough~~`), and highlight (`==highlighted==`).
    - **Links**: Standard Markdown links (`[link text](https://example.com)`).

    *Note: While the Attio interface supports image embeds, they cannot currently be added or retrieved via the API's markdown format.*
    """

    content: str
    r"""The main content of the note, formatted according to the value provided in the `format` field. Use `\n` for line breaks in `plaintext`. For `markdown`, utilize the supported syntax elements to structure and style your note."""

    created_at: Optional[str] = None
    r"""`created_at` will default to the current time. However, if you wish to backdate a note for migration or other purposes, you can override with a custom `created_at` value. Note that dates before 1970 or in the future are not allowed."""

    meeting_id: OptionalNullable[str] = UNSET
    r"""An optional ID to associate this note with a meeting. If provided, the meeting must exist. Use `null` to explicitly set no meeting association."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["created_at", "meeting_id"]
        nullable_fields = ["meeting_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostV2NotesRequestTypedDict(TypedDict):
    data: PostV2NotesDataTypedDict


class PostV2NotesRequest(BaseModel):
    data: PostV2NotesData


PostV2NotesType = Literal["invalid_request_error",]


PostV2NotesCode = Literal["not_found",]


class PostV2NotesResponseTypedDict(TypedDict):
    r"""Success"""

    data: NoteTypedDict


class PostV2NotesResponse(BaseModel):
    r"""Success"""

    data: Note
