"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .select_option import SelectOption, SelectOptionTypedDict
from .status import Status, StatusTypedDict
from attio.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from attio.utils import FieldMetadata, PathParamMetadata, RequestMetadata
from datetime import date, datetime
from pydantic import model_serializer
from typing import Any, Dict, List, Literal, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class PostV2ObjectsObjectRecordsDataRequestTypedDict(TypedDict):
    values: Dict[str, List[Any]]
    r"""An object with an attribute `api_slug` or `attribute_id` as the key, and a single value (for single-select attributes), or an array of values (for single or multi-select attributes) as the values. For complete documentation on values for all attribute types, please see our [attribute type docs](/docs/attribute-types)."""


class PostV2ObjectsObjectRecordsDataRequest(BaseModel):
    values: Dict[str, List[Any]]
    r"""An object with an attribute `api_slug` or `attribute_id` as the key, and a single value (for single-select attributes), or an array of values (for single or multi-select attributes) as the values. For complete documentation on values for all attribute types, please see our [attribute type docs](/docs/attribute-types)."""


class PostV2ObjectsObjectRecordsRequestBodyTypedDict(TypedDict):
    data: PostV2ObjectsObjectRecordsDataRequestTypedDict


class PostV2ObjectsObjectRecordsRequestBody(BaseModel):
    data: PostV2ObjectsObjectRecordsDataRequest


class PostV2ObjectsObjectRecordsRequestTypedDict(TypedDict):
    object: str
    request_body: PostV2ObjectsObjectRecordsRequestBodyTypedDict


class PostV2ObjectsObjectRecordsRequest(BaseModel):
    object: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    request_body: Annotated[
        PostV2ObjectsObjectRecordsRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


PostV2ObjectsObjectRecordsNotFoundType = Literal["invalid_request_error",]


PostV2ObjectsObjectRecordsNotFoundCode = Literal["not_found",]


PostV2ObjectsObjectRecordsBadRequestType = Literal["invalid_request_error",]


PostV2ObjectsObjectRecordsCodeValueNotFound = Literal["value_not_found",]


class PostV2ObjectsObjectRecordsIDTypedDict(TypedDict):
    workspace_id: str
    r"""A UUID identifying the workspace this record belongs to."""
    object_id: str
    r"""A UUID identifying the object this record belongs to."""
    record_id: str
    r"""A UUID identifying this record."""


class PostV2ObjectsObjectRecordsID(BaseModel):
    workspace_id: str
    r"""A UUID identifying the workspace this record belongs to."""

    object_id: str
    r"""A UUID identifying the object this record belongs to."""

    record_id: str
    r"""A UUID identifying this record."""


PostV2ObjectsObjectRecordsCreatedByActorType17 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor17TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsCreatedByActorType17]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor17(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsCreatedByActorType17] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsAttributeTypeTimestamp = Literal["timestamp",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueTimestampTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor17TypedDict
    r"""The actor that created this value."""
    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeTimestamp
    r"""The attribute type of the value."""
    value: date
    r"""A timestamp value represents a single, universal moment in time using an ISO 8601 formatted string. This means that a timestamp consists of a date, a time (with nanosecond precision), and a time zone. Attio will coerce timestamps which do not provide full nanosecond precision and UTC is assumed if no time zone is provided. For example, \"2023\", \"2023-01\", \"2023-01-02\", \"2023-01-02T13:00\", \"2023-01-02T13:00:00\", and \"2023-01-02T13:00:00.000000000\" will all be coerced to \"2023-01-02T13:00:00.000000000Z\". Timestamps are always returned in UTC. For example, writing a timestamp value using the string \"2023-01-02T13:00:00.000000000+02:00\" will result in the value \"2023-01-02T11:00:00.000000000Z\" being returned. The maximum date is \"9999-12-31T23:59:59.999999999Z\"."""


class PostV2ObjectsObjectRecordsValueTimestamp(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor17
    r"""The actor that created this value."""

    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeTimestamp
    r"""The attribute type of the value."""

    value: date
    r"""A timestamp value represents a single, universal moment in time using an ISO 8601 formatted string. This means that a timestamp consists of a date, a time (with nanosecond precision), and a time zone. Attio will coerce timestamps which do not provide full nanosecond precision and UTC is assumed if no time zone is provided. For example, \"2023\", \"2023-01\", \"2023-01-02\", \"2023-01-02T13:00\", \"2023-01-02T13:00:00\", and \"2023-01-02T13:00:00.000000000\" will all be coerced to \"2023-01-02T13:00:00.000000000Z\". Timestamps are always returned in UTC. For example, writing a timestamp value using the string \"2023-01-02T13:00:00.000000000+02:00\" will result in the value \"2023-01-02T11:00:00.000000000Z\" being returned. The maximum date is \"9999-12-31T23:59:59.999999999Z\"."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsCreatedByActorType16 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor16TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsCreatedByActorType16]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor16(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsCreatedByActorType16] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsAttributeTypeText = Literal["text",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueTextTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor16TypedDict
    r"""The actor that created this value."""
    value: str
    r"""A raw text field. Values are limited to 10MB."""
    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeText
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueText(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor16
    r"""The actor that created this value."""

    value: str
    r"""A raw text field. Values are limited to 10MB."""

    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeText
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsCreatedByActorType15 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor15TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsCreatedByActorType15]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor15(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsCreatedByActorType15] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsAttributeTypeSelect = Literal["select",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueSelectTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor15TypedDict
    r"""The actor that created this value."""
    option: SelectOptionTypedDict
    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeSelect
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueSelect(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor15
    r"""The actor that created this value."""

    option: SelectOption

    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeSelect
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsCreatedByActorType14 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor14TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsCreatedByActorType14]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor14(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsCreatedByActorType14] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsAttributeTypeRating = Literal["rating",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueRatingTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor14TypedDict
    r"""The actor that created this value."""
    value: float
    r"""A number between 0 and 5 (inclusive) to represent a star rating."""
    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeRating
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueRating(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor14
    r"""The actor that created this value."""

    value: float
    r"""A number between 0 and 5 (inclusive) to represent a star rating."""

    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeRating
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsCreatedByActorType13 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor13TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsCreatedByActorType13]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor13(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsCreatedByActorType13] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsAttributeTypeStatus = Literal["status",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueStatusTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor13TypedDict
    r"""The actor that created this value."""
    status: StatusTypedDict
    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeStatus
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueStatus(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor13
    r"""The actor that created this value."""

    status: Status

    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeStatus
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsCreatedByActorType12 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor12TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsCreatedByActorType12]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor12(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsCreatedByActorType12] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsCountryCode2 = Literal[
    "AF",
    "AX",
    "AL",
    "DZ",
    "AS",
    "AD",
    "AO",
    "AI",
    "AQ",
    "AG",
    "AR",
    "AM",
    "AW",
    "AU",
    "AT",
    "AZ",
    "BS",
    "BH",
    "BD",
    "BB",
    "BY",
    "BE",
    "BZ",
    "BJ",
    "BM",
    "BT",
    "BO",
    "BA",
    "BW",
    "BV",
    "BR",
    "IO",
    "BN",
    "BG",
    "BF",
    "BI",
    "KH",
    "CM",
    "CA",
    "CV",
    "KY",
    "CF",
    "TD",
    "CL",
    "CN",
    "CX",
    "CC",
    "CO",
    "KM",
    "CG",
    "CD",
    "CK",
    "CR",
    "CI",
    "HR",
    "CU",
    "CW",
    "CY",
    "CZ",
    "DK",
    "DJ",
    "DM",
    "DO",
    "EC",
    "EG",
    "SV",
    "GQ",
    "ER",
    "EE",
    "ET",
    "FK",
    "FO",
    "FJ",
    "FI",
    "FR",
    "GF",
    "PF",
    "TF",
    "GA",
    "GM",
    "GE",
    "DE",
    "GH",
    "GI",
    "GR",
    "GL",
    "GD",
    "GP",
    "GU",
    "GT",
    "GG",
    "GN",
    "GW",
    "GY",
    "HT",
    "HM",
    "VA",
    "HN",
    "HK",
    "HU",
    "IS",
    "IN",
    "ID",
    "IR",
    "IQ",
    "IE",
    "IM",
    "IL",
    "IT",
    "JM",
    "JP",
    "JE",
    "JO",
    "KZ",
    "KE",
    "KI",
    "KR",
    "KW",
    "KG",
    "LA",
    "LV",
    "LB",
    "LS",
    "LR",
    "LY",
    "LI",
    "LT",
    "LU",
    "MO",
    "MK",
    "MG",
    "MW",
    "MY",
    "MV",
    "ML",
    "MT",
    "MH",
    "MQ",
    "MR",
    "MU",
    "YT",
    "MX",
    "FM",
    "MD",
    "MC",
    "MN",
    "ME",
    "MS",
    "MA",
    "MZ",
    "MM",
    "NA",
    "NR",
    "NP",
    "NL",
    "AN",
    "NC",
    "NZ",
    "NI",
    "NE",
    "NG",
    "NU",
    "NF",
    "MP",
    "NO",
    "OM",
    "PK",
    "PW",
    "PS",
    "PA",
    "PG",
    "PY",
    "PE",
    "PH",
    "PN",
    "PL",
    "PT",
    "PR",
    "QA",
    "RE",
    "RO",
    "RU",
    "RW",
    "BL",
    "SH",
    "KN",
    "LC",
    "MF",
    "PM",
    "VC",
    "WS",
    "SM",
    "ST",
    "SA",
    "SN",
    "SS",
    "RS",
    "SC",
    "SL",
    "SG",
    "SK",
    "SI",
    "SB",
    "SO",
    "ZA",
    "GS",
    "ES",
    "LK",
    "SD",
    "SR",
    "SJ",
    "SZ",
    "SE",
    "CH",
    "SY",
    "TW",
    "TJ",
    "TZ",
    "TH",
    "TL",
    "TG",
    "TK",
    "TO",
    "TT",
    "TN",
    "TR",
    "TM",
    "TC",
    "TV",
    "UG",
    "UA",
    "AE",
    "GB",
    "US",
    "UM",
    "UY",
    "UZ",
    "VU",
    "VE",
    "VN",
    "VG",
    "VI",
    "WF",
    "EH",
    "YE",
    "ZM",
    "ZW",
    "BQ",
    "KP",
    "SX",
    "XK",
    "AC",
]
r"""The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to."""


PostV2ObjectsObjectRecordsAttributeTypePhoneNumber = Literal["phone-number",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValuePhoneNumberTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor12TypedDict
    r"""The actor that created this value."""
    original_phone_number: str
    r"""The raw, original phone number, as inputted."""
    country_code: PostV2ObjectsObjectRecordsCountryCode2
    r"""The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to."""
    phone_number: str
    attribute_type: PostV2ObjectsObjectRecordsAttributeTypePhoneNumber
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValuePhoneNumber(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor12
    r"""The actor that created this value."""

    original_phone_number: str
    r"""The raw, original phone number, as inputted."""

    country_code: PostV2ObjectsObjectRecordsCountryCode2
    r"""The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to."""

    phone_number: str

    attribute_type: PostV2ObjectsObjectRecordsAttributeTypePhoneNumber
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsCreatedByActorType11 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor11TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsCreatedByActorType11]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor11(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsCreatedByActorType11] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsAttributeTypePersonalName = Literal["personal-name",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValuePersonalNameTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor11TypedDict
    r"""The actor that created this value."""
    first_name: str
    r"""The first name."""
    last_name: str
    r"""The last name."""
    full_name: str
    r"""The full name."""
    attribute_type: PostV2ObjectsObjectRecordsAttributeTypePersonalName
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValuePersonalName(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor11
    r"""The actor that created this value."""

    first_name: str
    r"""The first name."""

    last_name: str
    r"""The last name."""

    full_name: str
    r"""The full name."""

    attribute_type: PostV2ObjectsObjectRecordsAttributeTypePersonalName
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsCreatedByActorType10 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor10TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsCreatedByActorType10]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor10(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsCreatedByActorType10] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsAttributeTypeNumber = Literal["number",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueNumberTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor10TypedDict
    r"""The actor that created this value."""
    value: float
    r"""Numbers are persisted as 64 bit floats."""
    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeNumber
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueNumber(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor10
    r"""The actor that created this value."""

    value: float
    r"""Numbers are persisted as 64 bit floats."""

    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeNumber
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsCreatedByActorType9 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor9TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsCreatedByActorType9]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor9(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsCreatedByActorType9] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsCountryCode1 = Literal[
    "AF",
    "AX",
    "AL",
    "DZ",
    "AS",
    "AD",
    "AO",
    "AI",
    "AQ",
    "AG",
    "AR",
    "AM",
    "AW",
    "AU",
    "AT",
    "AZ",
    "BS",
    "BH",
    "BD",
    "BB",
    "BY",
    "BE",
    "BZ",
    "BJ",
    "BM",
    "BT",
    "BO",
    "BA",
    "BW",
    "BV",
    "BR",
    "IO",
    "BN",
    "BG",
    "BF",
    "BI",
    "KH",
    "CM",
    "CA",
    "CV",
    "KY",
    "CF",
    "TD",
    "CL",
    "CN",
    "CX",
    "CC",
    "CO",
    "KM",
    "CG",
    "CD",
    "CK",
    "CR",
    "CI",
    "HR",
    "CU",
    "CW",
    "CY",
    "CZ",
    "DK",
    "DJ",
    "DM",
    "DO",
    "EC",
    "EG",
    "SV",
    "GQ",
    "ER",
    "EE",
    "ET",
    "FK",
    "FO",
    "FJ",
    "FI",
    "FR",
    "GF",
    "PF",
    "TF",
    "GA",
    "GM",
    "GE",
    "DE",
    "GH",
    "GI",
    "GR",
    "GL",
    "GD",
    "GP",
    "GU",
    "GT",
    "GG",
    "GN",
    "GW",
    "GY",
    "HT",
    "HM",
    "VA",
    "HN",
    "HK",
    "HU",
    "IS",
    "IN",
    "ID",
    "IR",
    "IQ",
    "IE",
    "IM",
    "IL",
    "IT",
    "JM",
    "JP",
    "JE",
    "JO",
    "KZ",
    "KE",
    "KI",
    "KR",
    "KW",
    "KG",
    "LA",
    "LV",
    "LB",
    "LS",
    "LR",
    "LY",
    "LI",
    "LT",
    "LU",
    "MO",
    "MK",
    "MG",
    "MW",
    "MY",
    "MV",
    "ML",
    "MT",
    "MH",
    "MQ",
    "MR",
    "MU",
    "YT",
    "MX",
    "FM",
    "MD",
    "MC",
    "MN",
    "ME",
    "MS",
    "MA",
    "MZ",
    "MM",
    "NA",
    "NR",
    "NP",
    "NL",
    "AN",
    "NC",
    "NZ",
    "NI",
    "NE",
    "NG",
    "NU",
    "NF",
    "MP",
    "NO",
    "OM",
    "PK",
    "PW",
    "PS",
    "PA",
    "PG",
    "PY",
    "PE",
    "PH",
    "PN",
    "PL",
    "PT",
    "PR",
    "QA",
    "RE",
    "RO",
    "RU",
    "RW",
    "BL",
    "SH",
    "KN",
    "LC",
    "MF",
    "PM",
    "VC",
    "WS",
    "SM",
    "ST",
    "SA",
    "SN",
    "SS",
    "RS",
    "SC",
    "SL",
    "SG",
    "SK",
    "SI",
    "SB",
    "SO",
    "ZA",
    "GS",
    "ES",
    "LK",
    "SD",
    "SR",
    "SJ",
    "SZ",
    "SE",
    "CH",
    "SY",
    "TW",
    "TJ",
    "TZ",
    "TH",
    "TL",
    "TG",
    "TK",
    "TO",
    "TT",
    "TN",
    "TR",
    "TM",
    "TC",
    "TV",
    "UG",
    "UA",
    "AE",
    "GB",
    "US",
    "UM",
    "UY",
    "UZ",
    "VU",
    "VE",
    "VN",
    "VG",
    "VI",
    "WF",
    "EH",
    "YE",
    "ZM",
    "ZW",
    "BQ",
    "KP",
    "SX",
    "XK",
    "AC",
]
r"""The ISO 3166-1 alpha-2 country code for the country this location is in."""


PostV2ObjectsObjectRecordsAttributeTypeLocation = Literal["location",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueLocationTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor9TypedDict
    r"""The actor that created this value."""
    line_1: Nullable[str]
    r"""The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""
    line_2: Nullable[str]
    r"""The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""
    line_3: Nullable[str]
    r"""The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""
    line_4: Nullable[str]
    r"""The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""
    locality: Nullable[str]
    r"""The town, neighborhood or area the location is in."""
    region: Nullable[str]
    r"""The state, county, province or region that the location is in."""
    postcode: Nullable[str]
    r"""The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""
    country_code: Nullable[PostV2ObjectsObjectRecordsCountryCode1]
    r"""The ISO 3166-1 alpha-2 country code for the country this location is in."""
    latitude: Nullable[str]
    r"""The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Values are stored with up to 9 decimal places of precision. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""
    longitude: Nullable[str]
    r"""The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`. Values are stored with up to 9 decimal places of precision. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""
    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeLocation
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueLocation(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor9
    r"""The actor that created this value."""

    line_1: Nullable[str]
    r"""The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""

    line_2: Nullable[str]
    r"""The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""

    line_3: Nullable[str]
    r"""The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""

    line_4: Nullable[str]
    r"""The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""

    locality: Nullable[str]
    r"""The town, neighborhood or area the location is in."""

    region: Nullable[str]
    r"""The state, county, province or region that the location is in."""

    postcode: Nullable[str]
    r"""The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""

    country_code: Nullable[PostV2ObjectsObjectRecordsCountryCode1]
    r"""The ISO 3166-1 alpha-2 country code for the country this location is in."""

    latitude: Nullable[str]
    r"""The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Values are stored with up to 9 decimal places of precision. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""

    longitude: Nullable[str]
    r"""The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`. Values are stored with up to 9 decimal places of precision. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""

    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeLocation
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = [
            "active_until",
            "line_1",
            "line_2",
            "line_3",
            "line_4",
            "locality",
            "region",
            "postcode",
            "country_code",
            "latitude",
            "longitude",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsCreatedByActorType8 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor8TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsCreatedByActorType8]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor8(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsCreatedByActorType8] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsInteractionType = Literal[
    "calendar-event",
    "call",
    "chat-thread",
    "email",
    "in-person-meeting",
    "meeting",
]
r"""The type of interaction e.g. calendar or email."""


PostV2ObjectsObjectRecordsOwnerActorType = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsOwnerActorTypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsOwnerActorType]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsOwnerActor(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsOwnerActorType] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsAttributeTypeInteraction = Literal["interaction",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueInteractionTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor8TypedDict
    r"""The actor that created this value."""
    interaction_type: PostV2ObjectsObjectRecordsInteractionType
    r"""The type of interaction e.g. calendar or email."""
    interacted_at: datetime
    r"""When the interaction occurred."""
    owner_actor: PostV2ObjectsObjectRecordsOwnerActorTypedDict
    r"""The actor that created this value."""
    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeInteraction
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueInteraction(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor8
    r"""The actor that created this value."""

    interaction_type: PostV2ObjectsObjectRecordsInteractionType
    r"""The type of interaction e.g. calendar or email."""

    interacted_at: datetime
    r"""When the interaction occurred."""

    owner_actor: PostV2ObjectsObjectRecordsOwnerActor
    r"""The actor that created this value."""

    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeInteraction
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsCreatedByActorType7 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor7TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsCreatedByActorType7]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor7(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsCreatedByActorType7] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsAttributeTypeRecordReference = Literal["record-reference",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueRecordReferenceTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor7TypedDict
    r"""The actor that created this value."""
    target_object: str
    r"""A slug identifying the object that the referenced record belongs to."""
    target_record_id: str
    r"""A UUID to identify the referenced record."""
    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeRecordReference
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueRecordReference(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor7
    r"""The actor that created this value."""

    target_object: str
    r"""A slug identifying the object that the referenced record belongs to."""

    target_record_id: str
    r"""A UUID to identify the referenced record."""

    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeRecordReference
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsCreatedByActorType6 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor6TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsCreatedByActorType6]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor6(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsCreatedByActorType6] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsAttributeTypeEmailAddress = Literal["email-address",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueEmailAddressTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor6TypedDict
    r"""The actor that created this value."""
    original_email_address: str
    email_address: str
    email_domain: str
    email_root_domain: str
    email_local_specifier: str
    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeEmailAddress
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueEmailAddress(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor6
    r"""The actor that created this value."""

    original_email_address: str

    email_address: str

    email_domain: str

    email_root_domain: str

    email_local_specifier: str

    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeEmailAddress
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsCreatedByActorType5 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor5TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsCreatedByActorType5]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor5(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsCreatedByActorType5] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsAttributeTypeDomain = Literal["domain",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueDomainTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor5TypedDict
    r"""The actor that created this value."""
    domain: str
    root_domain: str
    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeDomain
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueDomain(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor5
    r"""The actor that created this value."""

    domain: str

    root_domain: str

    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeDomain
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsCreatedByActorType4 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor4TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsCreatedByActorType4]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor4(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsCreatedByActorType4] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsAttributeTypeDate = Literal["date",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueDateTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor4TypedDict
    r"""The actor that created this value."""
    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeDate
    r"""The attribute type of the value."""
    value: str
    r"""A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, \"2023\" and \"2023-01\" will be coerced into \"2023-01-01\", and \"2023-01-02\", \"2023-01-02T13:00\", \"2023-01-02T14:00:00\", \"2023-01-02T15:00:00.000000000\", and \"2023-01-02T15:00:00.000000000+02:00\" will all be coerced to \"2023-01-02\". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value \"2023-01-02T23:00:00-10:00\" will be returned as \"2023-01-03\". The maximum date is \"9999-12-31\"."""


class PostV2ObjectsObjectRecordsValueDate(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor4
    r"""The actor that created this value."""

    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeDate
    r"""The attribute type of the value."""

    value: str
    r"""A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, \"2023\" and \"2023-01\" will be coerced into \"2023-01-01\", and \"2023-01-02\", \"2023-01-02T13:00\", \"2023-01-02T14:00:00\", \"2023-01-02T15:00:00.000000000\", and \"2023-01-02T15:00:00.000000000+02:00\" will all be coerced to \"2023-01-02\". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value \"2023-01-02T23:00:00-10:00\" will be returned as \"2023-01-03\". The maximum date is \"9999-12-31\"."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsCreatedByActorType3 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor3TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsCreatedByActorType3]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor3(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsCreatedByActorType3] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsCurrencyCode = Literal[
    "ARS",
    "AUD",
    "BRL",
    "BEL",
    "CAD",
    "CLP",
    "CNY",
    "COP",
    "CZK",
    "DKK",
    "EUR",
    "HKD",
    "ISK",
    "INR",
    "ILS",
    "JPY",
    "KRW",
    "MYR",
    "MXN",
    "NTD",
    "NZD",
    "NGN",
    "NOK",
    "XPF",
    "PEN",
    "PHP",
    "PLN",
    "GBP",
    "RWF",
    "SAR",
    "SGD",
    "ZAR",
    "SEK",
    "CHF",
    "AED",
    "UYU",
    "USD",
]
r"""The ISO4217 currency code representing the currency that the value is stored in."""


PostV2ObjectsObjectRecordsAttributeTypeCurrency = Literal["currency",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueCurrencyTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor3TypedDict
    r"""The actor that created this value."""
    currency_value: float
    r"""A numerical representation of the currency value. A decimal with a max of 4 decimal places."""
    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeCurrency
    r"""The attribute type of the value."""
    currency_code: NotRequired[Nullable[PostV2ObjectsObjectRecordsCurrencyCode]]
    r"""The ISO4217 currency code representing the currency that the value is stored in."""


class PostV2ObjectsObjectRecordsValueCurrency(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor3
    r"""The actor that created this value."""

    currency_value: float
    r"""A numerical representation of the currency value. A decimal with a max of 4 decimal places."""

    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeCurrency
    r"""The attribute type of the value."""

    currency_code: OptionalNullable[PostV2ObjectsObjectRecordsCurrencyCode] = UNSET
    r"""The ISO4217 currency code representing the currency that the value is stored in."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["currency_code"]
        nullable_fields = ["active_until", "currency_code"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsCreatedByActorType2 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor2TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsCreatedByActorType2]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor2(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsCreatedByActorType2] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsAttributeTypeCheckbox = Literal["checkbox",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueCheckboxTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor2TypedDict
    r"""The actor that created this value."""
    value: bool
    r"""A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted."""
    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeCheckbox
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueCheckbox(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor2
    r"""The actor that created this value."""

    value: bool
    r"""A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted."""

    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeCheckbox
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsCreatedByActorType1 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor1TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsCreatedByActorType1]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsCreatedByActor1(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsCreatedByActorType1] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsReferencedActorType = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of the referenced actor. [Read more information on actor types here](/docs/actors)."""


PostV2ObjectsObjectRecordsAttributeTypeActorReference = Literal["actor-reference",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueActorReferenceTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor1TypedDict
    r"""The actor that created this value."""
    referenced_actor_type: PostV2ObjectsObjectRecordsReferencedActorType
    r"""The type of the referenced actor. [Read more information on actor types here](/docs/actors)."""
    referenced_actor_id: Nullable[str]
    r"""The ID of the referenced actor."""
    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeActorReference
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsValueActorReference(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsCreatedByActor1
    r"""The actor that created this value."""

    referenced_actor_type: PostV2ObjectsObjectRecordsReferencedActorType
    r"""The type of the referenced actor. [Read more information on actor types here](/docs/actors)."""

    referenced_actor_id: Nullable[str]
    r"""The ID of the referenced actor."""

    attribute_type: PostV2ObjectsObjectRecordsAttributeTypeActorReference
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until", "referenced_actor_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsValueUnionTypedDict = TypeAliasType(
    "PostV2ObjectsObjectRecordsValueUnionTypedDict",
    Union[
        PostV2ObjectsObjectRecordsValueNumberTypedDict,
        PostV2ObjectsObjectRecordsValueCheckboxTypedDict,
        PostV2ObjectsObjectRecordsValueTimestampTypedDict,
        PostV2ObjectsObjectRecordsValueDateTypedDict,
        PostV2ObjectsObjectRecordsValueTextTypedDict,
        PostV2ObjectsObjectRecordsValueSelectTypedDict,
        PostV2ObjectsObjectRecordsValueRatingTypedDict,
        PostV2ObjectsObjectRecordsValueStatusTypedDict,
        PostV2ObjectsObjectRecordsValueDomainTypedDict,
        PostV2ObjectsObjectRecordsValueRecordReferenceTypedDict,
        PostV2ObjectsObjectRecordsValueActorReferenceTypedDict,
        PostV2ObjectsObjectRecordsValueCurrencyTypedDict,
        PostV2ObjectsObjectRecordsValuePersonalNameTypedDict,
        PostV2ObjectsObjectRecordsValuePhoneNumberTypedDict,
        PostV2ObjectsObjectRecordsValueInteractionTypedDict,
        PostV2ObjectsObjectRecordsValueEmailAddressTypedDict,
        PostV2ObjectsObjectRecordsValueLocationTypedDict,
    ],
)


PostV2ObjectsObjectRecordsValueUnion = TypeAliasType(
    "PostV2ObjectsObjectRecordsValueUnion",
    Union[
        PostV2ObjectsObjectRecordsValueNumber,
        PostV2ObjectsObjectRecordsValueCheckbox,
        PostV2ObjectsObjectRecordsValueTimestamp,
        PostV2ObjectsObjectRecordsValueDate,
        PostV2ObjectsObjectRecordsValueText,
        PostV2ObjectsObjectRecordsValueSelect,
        PostV2ObjectsObjectRecordsValueRating,
        PostV2ObjectsObjectRecordsValueStatus,
        PostV2ObjectsObjectRecordsValueDomain,
        PostV2ObjectsObjectRecordsValueRecordReference,
        PostV2ObjectsObjectRecordsValueActorReference,
        PostV2ObjectsObjectRecordsValueCurrency,
        PostV2ObjectsObjectRecordsValuePersonalName,
        PostV2ObjectsObjectRecordsValuePhoneNumber,
        PostV2ObjectsObjectRecordsValueInteraction,
        PostV2ObjectsObjectRecordsValueEmailAddress,
        PostV2ObjectsObjectRecordsValueLocation,
    ],
)


class PostV2ObjectsObjectRecordsDataResponseTypedDict(TypedDict):
    id: PostV2ObjectsObjectRecordsIDTypedDict
    created_at: str
    r"""When this record was created."""
    web_url: str
    r"""A URL that links directly to the record page in the Attio web application."""
    values: Dict[str, List[PostV2ObjectsObjectRecordsValueUnionTypedDict]]
    r"""A record type with an attribute `api_slug` as the key, and an array of value objects as the values."""


class PostV2ObjectsObjectRecordsDataResponse(BaseModel):
    id: PostV2ObjectsObjectRecordsID

    created_at: str
    r"""When this record was created."""

    web_url: str
    r"""A URL that links directly to the record page in the Attio web application."""

    values: Dict[str, List[PostV2ObjectsObjectRecordsValueUnion]]
    r"""A record type with an attribute `api_slug` as the key, and an array of value objects as the values."""


class PostV2ObjectsObjectRecordsResponseTypedDict(TypedDict):
    r"""Success"""

    data: PostV2ObjectsObjectRecordsDataResponseTypedDict


class PostV2ObjectsObjectRecordsResponse(BaseModel):
    r"""Success"""

    data: PostV2ObjectsObjectRecordsDataResponse
