"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from attio.types import BaseModel, Nullable, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List, Literal, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


RequestAsTypeWorkspaceMember2 = Literal["workspace-member",]


class RequestAsWorkspaceMember2TypedDict(TypedDict):
    type: RequestAsTypeWorkspaceMember2
    email_address: str


class RequestAsWorkspaceMember2(BaseModel):
    type: RequestAsTypeWorkspaceMember2

    email_address: str


RequestAsTypeWorkspaceMember1 = Literal["workspace-member",]


class RequestAsWorkspaceMember1TypedDict(TypedDict):
    type: RequestAsTypeWorkspaceMember1
    workspace_member_id: str


class RequestAsWorkspaceMember1(BaseModel):
    type: RequestAsTypeWorkspaceMember1

    workspace_member_id: str


TypeWorkspace = Literal["workspace",]


class RequestAsWorkspaceTypedDict(TypedDict):
    type: TypeWorkspace


class RequestAsWorkspace(BaseModel):
    type: TypeWorkspace


RequestAsTypedDict = TypeAliasType(
    "RequestAsTypedDict",
    Union[
        RequestAsWorkspaceTypedDict,
        RequestAsWorkspaceMember1TypedDict,
        RequestAsWorkspaceMember2TypedDict,
    ],
)
r"""Specifies the context in which to perform the search. Use 'workspace' to return all search results or specify a workspace member to limit results to what one specific person in your workspace can see."""


RequestAs = TypeAliasType(
    "RequestAs",
    Union[RequestAsWorkspace, RequestAsWorkspaceMember1, RequestAsWorkspaceMember2],
)
r"""Specifies the context in which to perform the search. Use 'workspace' to return all search results or specify a workspace member to limit results to what one specific person in your workspace can see."""


class PostV2ObjectsRecordsSearchRequestTypedDict(TypedDict):
    query: str
    r"""Query string to search for. An empty string returns a default set of results."""
    objects: List[str]
    r"""Specifies which objects to filter results by. At least one object must be specified. Accepts object slugs or IDs."""
    request_as: RequestAsTypedDict
    r"""Specifies the context in which to perform the search. Use 'workspace' to return all search results or specify a workspace member to limit results to what one specific person in your workspace can see."""
    limit: NotRequired[float]
    r"""The maximum number of results to return. Defaults to 25."""


class PostV2ObjectsRecordsSearchRequest(BaseModel):
    query: str
    r"""Query string to search for. An empty string returns a default set of results."""

    objects: List[str]
    r"""Specifies which objects to filter results by. At least one object must be specified. Accepts object slugs or IDs."""

    request_as: RequestAs
    r"""Specifies the context in which to perform the search. Use 'workspace' to return all search results or specify a workspace member to limit results to what one specific person in your workspace can see."""

    limit: Optional[float] = 25
    r"""The maximum number of results to return. Defaults to 25."""


PostV2ObjectsRecordsSearchBadRequestType = Literal["invalid_request_error",]


PostV2ObjectsRecordsSearchCode = Literal["value_not_found",]


class PostV2ObjectsRecordsSearchID3TypedDict(TypedDict):
    workspace_id: str
    r"""A UUID identifying the workspace this record belongs to."""
    object_id: str
    r"""A UUID identifying the object this record belongs to."""
    record_id: str
    r"""A UUID identifying this record."""


class PostV2ObjectsRecordsSearchID3(BaseModel):
    workspace_id: str
    r"""A UUID identifying the workspace this record belongs to."""

    object_id: str
    r"""A UUID identifying the object this record belongs to."""

    record_id: str
    r"""A UUID identifying this record."""


ObjectSlugCompanies = Literal["companies",]
r"""The slug of the object this record belongs to."""


class DataCompaniesTypedDict(TypedDict):
    id: PostV2ObjectsRecordsSearchID3TypedDict
    record_text: str
    r"""A human-readable label for the record. Present on records from all objects."""
    record_image: Nullable[str]
    r"""The image for the record."""
    object_slug: ObjectSlugCompanies
    r"""The slug of the object this record belongs to."""
    domains: List[str]
    r"""The company's domains."""


class DataCompanies(BaseModel):
    id: PostV2ObjectsRecordsSearchID3

    record_text: str
    r"""A human-readable label for the record. Present on records from all objects."""

    record_image: Nullable[str]
    r"""The image for the record."""

    object_slug: ObjectSlugCompanies
    r"""The slug of the object this record belongs to."""

    domains: List[str]
    r"""The company's domains."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["record_image"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostV2ObjectsRecordsSearchID2TypedDict(TypedDict):
    workspace_id: str
    r"""A UUID identifying the workspace this record belongs to."""
    object_id: str
    r"""A UUID identifying the object this record belongs to."""
    record_id: str
    r"""A UUID identifying this record."""


class PostV2ObjectsRecordsSearchID2(BaseModel):
    workspace_id: str
    r"""A UUID identifying the workspace this record belongs to."""

    object_id: str
    r"""A UUID identifying the object this record belongs to."""

    record_id: str
    r"""A UUID identifying this record."""


ObjectSlugPeople = Literal["people",]
r"""The slug of the object this record belongs to."""


class DataPeopleTypedDict(TypedDict):
    id: PostV2ObjectsRecordsSearchID2TypedDict
    record_text: str
    r"""A human-readable label for the record. Present on records from all objects."""
    record_image: Nullable[str]
    r"""The image for the record."""
    object_slug: ObjectSlugPeople
    r"""The slug of the object this record belongs to."""
    email_addresses: List[str]
    r"""The person's email addresses."""
    phone_numbers: List[str]
    r"""The person's phone numbers."""


class DataPeople(BaseModel):
    id: PostV2ObjectsRecordsSearchID2

    record_text: str
    r"""A human-readable label for the record. Present on records from all objects."""

    record_image: Nullable[str]
    r"""The image for the record."""

    object_slug: ObjectSlugPeople
    r"""The slug of the object this record belongs to."""

    email_addresses: List[str]
    r"""The person's email addresses."""

    phone_numbers: List[str]
    r"""The person's phone numbers."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["record_image"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostV2ObjectsRecordsSearchID1TypedDict(TypedDict):
    workspace_id: str
    r"""A UUID identifying the workspace this record belongs to."""
    object_id: str
    r"""A UUID identifying the object this record belongs to."""
    record_id: str
    r"""A UUID identifying this record."""


class PostV2ObjectsRecordsSearchID1(BaseModel):
    workspace_id: str
    r"""A UUID identifying the workspace this record belongs to."""

    object_id: str
    r"""A UUID identifying the object this record belongs to."""

    record_id: str
    r"""A UUID identifying this record."""


class PostV2ObjectsRecordsSearchDataTypedDict(TypedDict):
    id: PostV2ObjectsRecordsSearchID1TypedDict
    record_text: str
    r"""A human-readable label for the record. Present on records from all objects."""
    record_image: Nullable[str]
    r"""The image for the record."""
    object_slug: str
    r"""The slug of the object this record belongs to."""


class PostV2ObjectsRecordsSearchData(BaseModel):
    id: PostV2ObjectsRecordsSearchID1

    record_text: str
    r"""A human-readable label for the record. Present on records from all objects."""

    record_image: Nullable[str]
    r"""The image for the record."""

    object_slug: str
    r"""The slug of the object this record belongs to."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["record_image"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsRecordsSearchDataUnionTypedDict = TypeAliasType(
    "PostV2ObjectsRecordsSearchDataUnionTypedDict",
    Union[
        PostV2ObjectsRecordsSearchDataTypedDict,
        DataCompaniesTypedDict,
        DataPeopleTypedDict,
    ],
)


PostV2ObjectsRecordsSearchDataUnion = TypeAliasType(
    "PostV2ObjectsRecordsSearchDataUnion",
    Union[PostV2ObjectsRecordsSearchData, DataCompanies, DataPeople],
)


class PostV2ObjectsRecordsSearchResponseTypedDict(TypedDict):
    r"""Success"""

    data: List[PostV2ObjectsRecordsSearchDataUnionTypedDict]


class PostV2ObjectsRecordsSearchResponse(BaseModel):
    r"""Success"""

    data: List[PostV2ObjectsRecordsSearchDataUnion]
