"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .task import Task, TaskTypedDict
from attio.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


PostV2TasksFormat = Literal["plaintext",]
r"""The format of the task content to be created. Rich text formatting, links and @references are not supported."""


class PostV2TasksSlugOrIDOfMatchingAttribute5TypedDict(TypedDict):
    value: NotRequired[str]
    r"""A raw text field. Values are limited to 10MB."""


class PostV2TasksSlugOrIDOfMatchingAttribute5(BaseModel):
    value: Optional[str] = None
    r"""A raw text field. Values are limited to 10MB."""


PostV2TasksCountryCode = Literal[
    "AF",
    "AX",
    "AL",
    "DZ",
    "AS",
    "AD",
    "AO",
    "AI",
    "AQ",
    "AG",
    "AR",
    "AM",
    "AW",
    "AU",
    "AT",
    "AZ",
    "BS",
    "BH",
    "BD",
    "BB",
    "BY",
    "BE",
    "BZ",
    "BJ",
    "BM",
    "BT",
    "BO",
    "BA",
    "BW",
    "BV",
    "BR",
    "IO",
    "BN",
    "BG",
    "BF",
    "BI",
    "KH",
    "CM",
    "CA",
    "CV",
    "KY",
    "CF",
    "TD",
    "CL",
    "CN",
    "CX",
    "CC",
    "CO",
    "KM",
    "CG",
    "CD",
    "CK",
    "CR",
    "CI",
    "HR",
    "CU",
    "CW",
    "CY",
    "CZ",
    "DK",
    "DJ",
    "DM",
    "DO",
    "EC",
    "EG",
    "SV",
    "GQ",
    "ER",
    "EE",
    "ET",
    "FK",
    "FO",
    "FJ",
    "FI",
    "FR",
    "GF",
    "PF",
    "TF",
    "GA",
    "GM",
    "GE",
    "DE",
    "GH",
    "GI",
    "GR",
    "GL",
    "GD",
    "GP",
    "GU",
    "GT",
    "GG",
    "GN",
    "GW",
    "GY",
    "HT",
    "HM",
    "VA",
    "HN",
    "HK",
    "HU",
    "IS",
    "IN",
    "ID",
    "IR",
    "IQ",
    "IE",
    "IM",
    "IL",
    "IT",
    "JM",
    "JP",
    "JE",
    "JO",
    "KZ",
    "KE",
    "KI",
    "KR",
    "KW",
    "KG",
    "LA",
    "LV",
    "LB",
    "LS",
    "LR",
    "LY",
    "LI",
    "LT",
    "LU",
    "MO",
    "MK",
    "MG",
    "MW",
    "MY",
    "MV",
    "ML",
    "MT",
    "MH",
    "MQ",
    "MR",
    "MU",
    "YT",
    "MX",
    "FM",
    "MD",
    "MC",
    "MN",
    "ME",
    "MS",
    "MA",
    "MZ",
    "MM",
    "NA",
    "NR",
    "NP",
    "NL",
    "AN",
    "NC",
    "NZ",
    "NI",
    "NE",
    "NG",
    "NU",
    "NF",
    "MP",
    "NO",
    "OM",
    "PK",
    "PW",
    "PS",
    "PA",
    "PG",
    "PY",
    "PE",
    "PH",
    "PN",
    "PL",
    "PT",
    "PR",
    "QA",
    "RE",
    "RO",
    "RU",
    "RW",
    "BL",
    "SH",
    "KN",
    "LC",
    "MF",
    "PM",
    "VC",
    "WS",
    "SM",
    "ST",
    "SA",
    "SN",
    "SS",
    "RS",
    "SC",
    "SL",
    "SG",
    "SK",
    "SI",
    "SB",
    "SO",
    "ZA",
    "GS",
    "ES",
    "LK",
    "SD",
    "SR",
    "SJ",
    "SZ",
    "SE",
    "CH",
    "SY",
    "TW",
    "TJ",
    "TZ",
    "TH",
    "TL",
    "TG",
    "TK",
    "TO",
    "TT",
    "TN",
    "TR",
    "TM",
    "TC",
    "TV",
    "UG",
    "UA",
    "AE",
    "GB",
    "US",
    "UM",
    "UY",
    "UZ",
    "VU",
    "VE",
    "VN",
    "VG",
    "VI",
    "WF",
    "EH",
    "YE",
    "ZM",
    "ZW",
    "BQ",
    "KP",
    "SX",
    "XK",
    "AC",
]
r"""The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to."""


class PostV2TasksSlugOrIDOfMatchingAttribute4TypedDict(TypedDict):
    original_phone_number: NotRequired[str]
    r"""The raw, original phone number, as inputted."""
    country_code: NotRequired[Nullable[PostV2TasksCountryCode]]
    r"""The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to."""


class PostV2TasksSlugOrIDOfMatchingAttribute4(BaseModel):
    original_phone_number: Optional[str] = None
    r"""The raw, original phone number, as inputted."""

    country_code: OptionalNullable[PostV2TasksCountryCode] = UNSET
    r"""The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["original_phone_number", "country_code"]
        nullable_fields = ["country_code"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostV2TasksSlugOrIDOfMatchingAttribute3TypedDict(TypedDict):
    value: NotRequired[float]
    r"""Numbers are persisted as 64 bit floats."""


class PostV2TasksSlugOrIDOfMatchingAttribute3(BaseModel):
    value: Optional[float] = None
    r"""Numbers are persisted as 64 bit floats."""


class PostV2TasksSlugOrIDOfMatchingAttribute2TypedDict(TypedDict):
    email_address: NotRequired[str]
    r"""An email address string"""


class PostV2TasksSlugOrIDOfMatchingAttribute2(BaseModel):
    email_address: Optional[str] = None
    r"""An email address string"""


class PostV2TasksSlugOrIDOfMatchingAttribute1TypedDict(TypedDict):
    domain: NotRequired[str]
    r"""The full domain of the website."""


class PostV2TasksSlugOrIDOfMatchingAttribute1(BaseModel):
    domain: Optional[str] = None
    r"""The full domain of the website."""


PostV2TasksSlugOrIDOfMatchingAttributeUnionTypedDict = TypeAliasType(
    "PostV2TasksSlugOrIDOfMatchingAttributeUnionTypedDict",
    Union[
        PostV2TasksSlugOrIDOfMatchingAttribute1TypedDict,
        PostV2TasksSlugOrIDOfMatchingAttribute2TypedDict,
        PostV2TasksSlugOrIDOfMatchingAttribute3TypedDict,
        PostV2TasksSlugOrIDOfMatchingAttribute5TypedDict,
        PostV2TasksSlugOrIDOfMatchingAttribute4TypedDict,
    ],
)


PostV2TasksSlugOrIDOfMatchingAttributeUnion = TypeAliasType(
    "PostV2TasksSlugOrIDOfMatchingAttributeUnion",
    Union[
        PostV2TasksSlugOrIDOfMatchingAttribute1,
        PostV2TasksSlugOrIDOfMatchingAttribute2,
        PostV2TasksSlugOrIDOfMatchingAttribute3,
        PostV2TasksSlugOrIDOfMatchingAttribute5,
        PostV2TasksSlugOrIDOfMatchingAttribute4,
    ],
)


class PostV2TasksLinkedRecord2TypedDict(TypedDict):
    target_object: str
    r"""A UUID or slug to identify the object that the referenced record belongs to."""
    slug_or_id_of_matching_attribute: List[
        PostV2TasksSlugOrIDOfMatchingAttributeUnionTypedDict
    ]
    r"""In addition to referencing records directly by record ID, you may also reference by a matching attribute of your choice. For example, if you want to add a reference to the person record with email \"alice@website.com\", you should pass a value with `target_object` set to `\"people\"` and `email_addresses` set to `[{email_address:\"alice@website.com\"}]`. The key should be the slug or ID of the matching attribute you would like to use and the value should be an array containing a single value of the appropriate attribute type (as specified below). Matching on multiple values is not currently supported. Matching attributes must be unique. This process is similar to how you use the `matching_attribute` query param in Attio's [assert endpoints](/rest-api/endpoint-reference/records/assert-a-record)."""


class PostV2TasksLinkedRecord2(BaseModel):
    target_object: str
    r"""A UUID or slug to identify the object that the referenced record belongs to."""

    slug_or_id_of_matching_attribute: Annotated[
        List[PostV2TasksSlugOrIDOfMatchingAttributeUnion],
        pydantic.Field(alias="[slug_or_id_of_matching_attribute]"),
    ]
    r"""In addition to referencing records directly by record ID, you may also reference by a matching attribute of your choice. For example, if you want to add a reference to the person record with email \"alice@website.com\", you should pass a value with `target_object` set to `\"people\"` and `email_addresses` set to `[{email_address:\"alice@website.com\"}]`. The key should be the slug or ID of the matching attribute you would like to use and the value should be an array containing a single value of the appropriate attribute type (as specified below). Matching on multiple values is not currently supported. Matching attributes must be unique. This process is similar to how you use the `matching_attribute` query param in Attio's [assert endpoints](/rest-api/endpoint-reference/records/assert-a-record)."""


class PostV2TasksLinkedRecord1TypedDict(TypedDict):
    target_object: str
    r"""The ID or slug of the parent object the tasks refers to. This can reference both standard and custom objects.`"""
    target_record_id: str
    r"""The ID of the parent record the task refers to."""


class PostV2TasksLinkedRecord1(BaseModel):
    target_object: str
    r"""The ID or slug of the parent object the tasks refers to. This can reference both standard and custom objects.`"""

    target_record_id: str
    r"""The ID of the parent record the task refers to."""


PostV2TasksLinkedRecordUnionTypedDict = TypeAliasType(
    "PostV2TasksLinkedRecordUnionTypedDict",
    Union[PostV2TasksLinkedRecord1TypedDict, PostV2TasksLinkedRecord2TypedDict],
)


PostV2TasksLinkedRecordUnion = TypeAliasType(
    "PostV2TasksLinkedRecordUnion",
    Union[PostV2TasksLinkedRecord1, PostV2TasksLinkedRecord2],
)


class PostV2TasksAssigneeTypedDict(TypedDict):
    workspace_member_email_address: str
    r"""Workspace member actors can be referenced by email address as well as actor ID."""


class PostV2TasksAssignee(BaseModel):
    workspace_member_email_address: str
    r"""Workspace member actors can be referenced by email address as well as actor ID."""


PostV2TasksReferencedActorType = Literal["workspace-member",]
r"""The actor type of the task assignee. Only `workspace-member` actors can be assigned to tasks. [Read more information on actor types here](/docs/actors)."""


class PostV2TasksAssigneeWorkspaceMemberTypedDict(TypedDict):
    referenced_actor_type: PostV2TasksReferencedActorType
    r"""The actor type of the task assignee. Only `workspace-member` actors can be assigned to tasks. [Read more information on actor types here](/docs/actors)."""
    referenced_actor_id: str
    r"""The ID of the actor assigned to this task."""


class PostV2TasksAssigneeWorkspaceMember(BaseModel):
    referenced_actor_type: PostV2TasksReferencedActorType
    r"""The actor type of the task assignee. Only `workspace-member` actors can be assigned to tasks. [Read more information on actor types here](/docs/actors)."""

    referenced_actor_id: str
    r"""The ID of the actor assigned to this task."""


PostV2TasksAssigneeUnionTypedDict = TypeAliasType(
    "PostV2TasksAssigneeUnionTypedDict",
    Union[PostV2TasksAssigneeTypedDict, PostV2TasksAssigneeWorkspaceMemberTypedDict],
)


PostV2TasksAssigneeUnion = TypeAliasType(
    "PostV2TasksAssigneeUnion",
    Union[PostV2TasksAssignee, PostV2TasksAssigneeWorkspaceMember],
)


class PostV2TasksDataTypedDict(TypedDict):
    content: str
    r"""The text content of the task, in the format specified by the `format` property. A max length of 2000 characters is enforced."""
    format_: PostV2TasksFormat
    r"""The format of the task content to be created. Rich text formatting, links and @references are not supported."""
    deadline_at: Nullable[str]
    r"""The deadline of the task, in ISO 8601 format."""
    is_completed: bool
    r"""Whether the task has been completed."""
    linked_records: List[PostV2TasksLinkedRecordUnionTypedDict]
    r"""Records linked to the task. Creating record links within task content text is not possible via the API at present."""
    assignees: List[PostV2TasksAssigneeUnionTypedDict]
    r"""Workspace members assigned to this task."""


class PostV2TasksData(BaseModel):
    content: str
    r"""The text content of the task, in the format specified by the `format` property. A max length of 2000 characters is enforced."""

    format_: Annotated[PostV2TasksFormat, pydantic.Field(alias="format")]
    r"""The format of the task content to be created. Rich text formatting, links and @references are not supported."""

    deadline_at: Nullable[str]
    r"""The deadline of the task, in ISO 8601 format."""

    is_completed: bool
    r"""Whether the task has been completed."""

    linked_records: List[PostV2TasksLinkedRecordUnion]
    r"""Records linked to the task. Creating record links within task content text is not possible via the API at present."""

    assignees: List[PostV2TasksAssigneeUnion]
    r"""Workspace members assigned to this task."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["deadline_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostV2TasksRequestTypedDict(TypedDict):
    data: PostV2TasksDataTypedDict


class PostV2TasksRequest(BaseModel):
    data: PostV2TasksData


PostV2TasksNotFoundType = Literal["invalid_request_error",]


PostV2TasksNotFoundCode = Literal["not_found",]


PostV2TasksBadRequestType = Literal["invalid_request_error",]


PostV2TasksCodeValidationType = Literal["validation_type",]


class PostV2TasksResponseTypedDict(TypedDict):
    r"""Success"""

    data: TaskTypedDict


class PostV2TasksResponse(BaseModel):
    r"""Success"""

    data: Task
