"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from attio.types import BaseModel, Nullable, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import TypedDict


class StatusIDTypedDict(TypedDict):
    workspace_id: str
    r"""The ID of the workspace"""
    object_id: str
    r"""The ID of the object"""
    attribute_id: str
    r"""The ID of the attribute"""
    status_id: str
    r"""The ID of the status"""


class StatusID(BaseModel):
    workspace_id: str
    r"""The ID of the workspace"""

    object_id: str
    r"""The ID of the object"""

    attribute_id: str
    r"""The ID of the attribute"""

    status_id: str
    r"""The ID of the status"""


class StatusTypedDict(TypedDict):
    id: StatusIDTypedDict
    title: str
    r"""The title of the status"""
    is_archived: bool
    r"""Whether or not to archive the status. See our [archiving guide](/docs/archiving-vs-deleting) for more information on archiving."""
    celebration_enabled: bool
    r"""Whether arriving at this status triggers a celebration effect in the UI"""
    target_time_in_status: Nullable[str]
    r"""Target time for a record to spend in given status expressed as a ISO-8601 duration string"""


class Status(BaseModel):
    id: StatusID

    title: str
    r"""The title of the status"""

    is_archived: bool
    r"""Whether or not to archive the status. See our [archiving guide](/docs/archiving-vs-deleting) for more information on archiving."""

    celebration_enabled: bool
    r"""Whether arriving at this status triggers a celebration effect in the UI"""

    target_time_in_status: Nullable[str]
    r"""Target time for a record to spend in given status expressed as a ISO-8601 duration string"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["target_time_in_status"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
