"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from attio.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List, Literal
from typing_extensions import NotRequired, TypedDict


class TaskIDTypedDict(TypedDict):
    workspace_id: str
    r"""The ID of the workspace the task belongs to."""
    task_id: str
    r"""The ID of the task."""


class TaskID(BaseModel):
    workspace_id: str
    r"""The ID of the workspace the task belongs to."""

    task_id: str
    r"""The ID of the task."""


class TaskLinkedRecordTypedDict(TypedDict):
    target_object_id: str
    r"""The ID of the parent object the task refers to. At present, only `people` and `companies` are supported."""
    target_record_id: str
    r"""The ID of the parent record the task refers to."""


class TaskLinkedRecord(BaseModel):
    target_object_id: str
    r"""The ID of the parent object the task refers to. At present, only `people` and `companies` are supported."""

    target_record_id: str
    r"""The ID of the parent record the task refers to."""


TaskReferencedActorType = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class AssigneeTypedDict(TypedDict):
    referenced_actor_type: TaskReferencedActorType
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""
    referenced_actor_id: str
    r"""The ID of the workspace member actor assigned to this task."""


class Assignee(BaseModel):
    referenced_actor_type: TaskReferencedActorType
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    referenced_actor_id: str
    r"""The ID of the workspace member actor assigned to this task."""


TaskType = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class TaskCreatedByActorTypedDict(TypedDict):
    r"""The actor that created this task."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[TaskType]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class TaskCreatedByActor(BaseModel):
    r"""The actor that created this task."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[TaskType] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TaskTypedDict(TypedDict):
    id: TaskIDTypedDict
    content_plaintext: str
    r"""The plaintext representation of the task content. Inline linked records will appear as \"@record name\" and are returned in the `linked_records` property."""
    deadline_at: Nullable[str]
    r"""The deadline date of the task. Returned as an ISO 8601 timestamp."""
    is_completed: bool
    r"""Whether the task has been completed."""
    linked_records: List[TaskLinkedRecordTypedDict]
    r"""Records linked to the task. Creating record links within task content text is not possible via the API at present."""
    assignees: List[AssigneeTypedDict]
    r"""Workspace members assigned to this task."""
    created_by_actor: TaskCreatedByActorTypedDict
    r"""The actor that created this task."""
    created_at: str
    r"""When the task was created."""


class Task(BaseModel):
    id: TaskID

    content_plaintext: str
    r"""The plaintext representation of the task content. Inline linked records will appear as \"@record name\" and are returned in the `linked_records` property."""

    deadline_at: Nullable[str]
    r"""The deadline date of the task. Returned as an ISO 8601 timestamp."""

    is_completed: bool
    r"""Whether the task has been completed."""

    linked_records: List[TaskLinkedRecord]
    r"""Records linked to the task. Creating record links within task content text is not possible via the API at present."""

    assignees: List[Assignee]
    r"""Workspace members assigned to this task."""

    created_by_actor: TaskCreatedByActor
    r"""The actor that created this task."""

    created_at: str
    r"""When the task was created."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["deadline_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
