"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from attio.types import BaseModel, Nullable, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Literal
from typing_extensions import TypedDict


class WorkspaceMemberIDTypedDict(TypedDict):
    workspace_id: str
    r"""The ID of the workspace the workspace member belongs to."""
    workspace_member_id: str
    r"""The ID of the workspace member."""


class WorkspaceMemberID(BaseModel):
    workspace_id: str
    r"""The ID of the workspace the workspace member belongs to."""

    workspace_member_id: str
    r"""The ID of the workspace member."""


AccessLevel = Literal[
    "admin",
    "member",
    "suspended",
]
r"""Whether the workspace member is suspended or not and what level of privileges they have inside the workspace. We do not delete workspace members so that you can successfully attribute past actions to suspended workspace members."""


class WorkspaceMemberTypedDict(TypedDict):
    id: WorkspaceMemberIDTypedDict
    first_name: str
    r"""The first name of the user."""
    last_name: str
    r"""The last name of the user."""
    avatar_url: Nullable[str]
    r"""A URL to the user's avatar image."""
    email_address: str
    r"""The user's email address."""
    created_at: str
    r"""When the workspace member was created."""
    access_level: AccessLevel
    r"""Whether the workspace member is suspended or not and what level of privileges they have inside the workspace. We do not delete workspace members so that you can successfully attribute past actions to suspended workspace members."""


class WorkspaceMember(BaseModel):
    id: WorkspaceMemberID

    first_name: str
    r"""The first name of the user."""

    last_name: str
    r"""The last name of the user."""

    avatar_url: Nullable[str]
    r"""A URL to the user's avatar image."""

    email_address: str
    r"""The user's email address."""

    created_at: str
    r"""When the workspace member was created."""

    access_level: AccessLevel
    r"""Whether the workspace member is suspended or not and what level of privileges they have inside the workspace. We do not delete workspace members so that you can successfully attribute past actions to suspended workspace members."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["avatar_url"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
