"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from attio import errors, models, utils
from attio._hooks import HookContext
from attio.types import OptionalNullable, UNSET
from attio.utils import get_security_from_env
from attio.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, List, Mapping, Optional


class Threads(BaseSDK):
    r"""Threads are groups of [comments](/rest-api/endpoint-reference/comments/get-a-comment) on either a record or entry."""

    def get_v2_threads(
        self,
        *,
        record_id: Optional[str] = None,
        object: Optional[str] = None,
        entry_id: Optional[str] = None,
        list: Optional[str] = None,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.Thread]:
        r"""List threads

        List threads of comments on a record or list entry.

        To view threads on records, you will need the `object_configuration:read` and `record_permission:read` scopes.

        To view threads on list entries, you will need the `list_configuration:read` and `list_entry:read` scopes.

        Required scopes: `comment:read`.

        :param record_id:
        :param object:
        :param entry_id:
        :param list:
        :param limit:
        :param offset:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetV2ThreadsRequest(
            record_id=record_id,
            object=object,
            entry_id=entry_id,
            list=list,
            limit=limit,
            offset=offset,
        )

        req = self._build_request(
            method="GET",
            path="/v2/threads",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_/v2/threads",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.GetV2ThreadsResponse, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    async def get_v2_threads_async(
        self,
        *,
        record_id: Optional[str] = None,
        object: Optional[str] = None,
        entry_id: Optional[str] = None,
        list: Optional[str] = None,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.Thread]:
        r"""List threads

        List threads of comments on a record or list entry.

        To view threads on records, you will need the `object_configuration:read` and `record_permission:read` scopes.

        To view threads on list entries, you will need the `list_configuration:read` and `list_entry:read` scopes.

        Required scopes: `comment:read`.

        :param record_id:
        :param object:
        :param entry_id:
        :param list:
        :param limit:
        :param offset:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetV2ThreadsRequest(
            record_id=record_id,
            object=object,
            entry_id=entry_id,
            list=list,
            limit=limit,
            offset=offset,
        )

        req = self._build_request_async(
            method="GET",
            path="/v2/threads",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_/v2/threads",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.GetV2ThreadsResponse, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    def get_v2_threads_thread_id_(
        self,
        *,
        thread_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Thread:
        r"""Get a thread

        Get all comments in a thread.

        To view threads on records, you will need the `object_configuration:read` and `record_permission:read` scopes.

        To view threads on list entries, you will need the `list_configuration:read` and `list_entry:read` scopes.

        Required scopes: `comment:read`.

        :param thread_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetV2ThreadsThreadIDRequest(
            thread_id=thread_id,
        )

        req = self._build_request(
            method="GET",
            path="/v2/threads/{thread_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_/v2/threads/{thread_id}",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetV2ThreadsThreadIDResponse, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.GetV2ThreadsThreadIDNotFoundErrorData, http_res
            )
            raise errors.GetV2ThreadsThreadIDNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    async def get_v2_threads_thread_id__async(
        self,
        *,
        thread_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Thread:
        r"""Get a thread

        Get all comments in a thread.

        To view threads on records, you will need the `object_configuration:read` and `record_permission:read` scopes.

        To view threads on list entries, you will need the `list_configuration:read` and `list_entry:read` scopes.

        Required scopes: `comment:read`.

        :param thread_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetV2ThreadsThreadIDRequest(
            thread_id=thread_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/v2/threads/{thread_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_/v2/threads/{thread_id}",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetV2ThreadsThreadIDResponse, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.GetV2ThreadsThreadIDNotFoundErrorData, http_res
            )
            raise errors.GetV2ThreadsThreadIDNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)
