"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from attio import errors, models, utils
from attio._hooks import HookContext
from attio.types import OptionalNullable, UNSET
from attio.utils import get_security_from_env
from attio.utils.unmarshal_json_response import unmarshal_json_response
from typing import Mapping, Optional


class Transcripts(BaseSDK):
    r"""Transcripts contain the speech segments and speaker information for a call recording. They are linked to call recordings."""

    def get_v2_meetings_meeting_id_call_recordings_call_recording_id_transcript(
        self,
        *,
        meeting_id: str,
        call_recording_id: str,
        cursor: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptData:
        r"""Get call transcript

        Get the transcript for a call recording.

        This endpoint is in beta. We will aim to avoid breaking changes, but small updates may be made as we roll out to more users.

        Required scopes: `meeting:read`, `call_recording:read`.

        :param meeting_id:
        :param call_recording_id:
        :param cursor:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = (
            models.GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptRequest(
                meeting_id=meeting_id,
                call_recording_id=call_recording_id,
                cursor=cursor,
            )
        )

        req = self._build_request(
            method="GET",
            path="/v2/meetings/{meeting_id}/call_recordings/{call_recording_id}/transcript",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_/v2/meetings/{meeting_id}/call_recordings/{call_recording_id}/transcript",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptResponse,
                http_res,
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)

    async def get_v2_meetings_meeting_id_call_recordings_call_recording_id_transcript_async(
        self,
        *,
        meeting_id: str,
        call_recording_id: str,
        cursor: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptData:
        r"""Get call transcript

        Get the transcript for a call recording.

        This endpoint is in beta. We will aim to avoid breaking changes, but small updates may be made as we roll out to more users.

        Required scopes: `meeting:read`, `call_recording:read`.

        :param meeting_id:
        :param call_recording_id:
        :param cursor:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = (
            models.GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptRequest(
                meeting_id=meeting_id,
                call_recording_id=call_recording_id,
                cursor=cursor,
            )
        )

        req = self._build_request_async(
            method="GET",
            path="/v2/meetings/{meeting_id}/call_recordings/{call_recording_id}/transcript",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_/v2/meetings/{meeting_id}/call_recordings/{call_recording_id}/transcript",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetV2MeetingsMeetingIDCallRecordingsCallRecordingIDTranscriptResponse,
                http_res,
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.AttioDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.AttioDefaultError("Unexpected response received", http_res)
