from setuptools import setup, Extension
from Cython.Build import cythonize
import glob
import sys

source_files = ["enet/enet.pyx"]

_enet_files = glob.glob("enet/enet/*.c")

if not _enet_files:
    print("You need to download and extract the enet 1.3 source to enet/")
    print("Download the source from: http://enet.bespin.org/Downloads.html")
    print("See the README for more instructions")
    sys.exit(1)

source_files.extend(_enet_files)

define_macros = [('HAS_POLL', None),
                 ('HAS_FCNTL', None),
                 ('HAS_MSGHDR_FLAGS', None),
                 ('HAS_SOCKLEN_T', None) ]

libraries = []

if sys.platform == 'win32':
    define_macros.extend([('WIN32', None)])
    libraries.extend(['ws2_32', 'Winmm'])

if sys.platform != 'darwin':
    define_macros.extend([('HAS_GETHOSTBYNAME_R', None), ('HAS_GETHOSTBYADDR_R', None)])

ext_modules = [
    Extension(
        "enet.enet",
        extra_compile_args=["-O2"],
        sources=source_files,
        include_dirs=["enet/enet/include/"],
        define_macros=define_macros,
        libraries=libraries)]

setup(
  name = 'pyenet313',
  version='1.3.21',
  packages=['enet'],
  ext_modules = cythonize(ext_modules),
  zip_safe=False,
  description='Python bindings for ENet networking library (fork adapted to python 3.13 and later)',
  maintainer='Caio Martins',
maintainer_email='caiomarcossi2019@gmail.com',
)
