from pydantic import HttpUrl

from toadr3.models import DocstringBaseModel


class Problem(DocstringBaseModel):
    """Reusable error response."""

    type: HttpUrl | None = None
    """An absolute URI that identifies the problem type.

    When dereferenced, it SHOULD provide human-readable documentation for the problem type
    (e.g., using HTML).
    """

    title: str
    """A short, summary of the problem type.

    Written in english and readable for engineers (usually not suited for non
    technical stakeholders and not localized); example: Service Unavailable.
    """

    status: int
    """The HTTP status code.

    Generated by the origin server for this occurrence of the problem.
    """

    detail: str | None = None
    """A human readable explanation specific to this occurrence of the problem."""

    instance: HttpUrl | None = None
    """An absolute URI that identifies the specific occurrence of the problem.

    It may or may not yield further information if dereferenced.
    """
