def get_known_countries(locale=None):
    """
    List compiled using the pycountry package v20.7.3 with

    ::

        sorted([(lang.alpha_2, lang.name) for lang in pycountry.countries
            if hasattr(lang, 'alpha_2')], key=lambda country: country[1])
    """
    from psynet.utils import get_translator

    _p = get_translator(context=True)
    return [
        ("AF", _p("country_name", "Afghanistan")),
        ("AL", _p("country_name", "Albania")),
        ("DZ", _p("country_name", "Algeria")),
        ("AS", _p("country_name", "American Samoa")),
        ("AD", _p("country_name", "Andorra")),
        ("AO", _p("country_name", "Angola")),
        ("AI", _p("country_name", "Anguilla")),
        ("AQ", _p("country_name", "Antarctica")),
        ("AG", _p("country_name", "Antigua and Barbuda")),
        ("AR", _p("country_name", "Argentina")),
        ("AM", _p("country_name", "Armenia")),
        ("AW", _p("country_name", "Aruba")),
        ("AU", _p("country_name", "Australia")),
        ("AT", _p("country_name", "Austria")),
        ("AZ", _p("country_name", "Azerbaijan")),
        ("BS", _p("country_name", "Bahamas")),
        ("BH", _p("country_name", "Bahrain")),
        ("BD", _p("country_name", "Bangladesh")),
        ("BB", _p("country_name", "Barbados")),
        ("BY", _p("country_name", "Belarus")),
        ("BE", _p("country_name", "Belgium")),
        ("BZ", _p("country_name", "Belize")),
        ("BJ", _p("country_name", "Benin")),
        ("BM", _p("country_name", "Bermuda")),
        ("BT", _p("country_name", "Bhutan")),
        ("BO", _p("country_name", "Bolivia")),
        ("BQ", _p("country_name", "Bonaire, Sint Eustatius and Saba")),
        ("BA", _p("country_name", "Bosnia and Herzegovina")),
        ("BW", _p("country_name", "Botswana")),
        ("BV", _p("country_name", "Bouvet Island")),
        ("BR", _p("country_name", "Brazil")),
        ("IO", _p("country_name", "British Indian Ocean Territory")),
        ("BN", _p("country_name", "Brunei Darussalam")),
        ("BG", _p("country_name", "Bulgaria")),
        ("BF", _p("country_name", "Burkina Faso")),
        ("BI", _p("country_name", "Burundi")),
        ("CV", _p("country_name", "Cabo Verde")),
        ("KH", _p("country_name", "Cambodia")),
        ("CM", _p("country_name", "Cameroon")),
        ("CA", _p("country_name", "Canada")),
        ("KY", _p("country_name", "Cayman Islands")),
        ("CF", _p("country_name", "Central African Republic")),
        ("TD", _p("country_name", "Chad")),
        ("CL", _p("country_name", "Chile")),
        ("CN", _p("country_name", "China")),
        ("CX", _p("country_name", "Christmas Island")),
        ("CC", _p("country_name", "Cocos  Islands")),
        ("CO", _p("country_name", "Colombia")),
        ("KM", _p("country_name", "Comoros")),
        ("CG", _p("country_name", "Congo")),
        ("CD", _p("country_name", "Congo (Democratic Republic)")),
        ("CK", _p("country_name", "Cook Islands")),
        ("CR", _p("country_name", "Costa Rica")),
        ("HR", _p("country_name", "Croatia")),
        ("CU", _p("country_name", "Cuba")),
        ("CW", _p("country_name", "Curaçao")),
        ("CY", _p("country_name", "Cyprus")),
        ("CZ", _p("country_name", "Czechia")),
        ("CI", _p("country_name", "Côte d'Ivoire")),
        ("DK", _p("country_name", "Denmark")),
        ("DJ", _p("country_name", "Djibouti")),
        ("DM", _p("country_name", "Dominica")),
        ("DO", _p("country_name", "Dominican Republic")),
        ("EC", _p("country_name", "Ecuador")),
        ("EG", _p("country_name", "Egypt")),
        ("SV", _p("country_name", "El Salvador")),
        ("GQ", _p("country_name", "Equatorial Guinea")),
        ("ER", _p("country_name", "Eritrea")),
        ("EE", _p("country_name", "Estonia")),
        ("SZ", _p("country_name", "Eswatini")),
        ("ET", _p("country_name", "Ethiopia")),
        ("FK", _p("country_name", "Falkland Islands (Malvinas)")),
        ("FO", _p("country_name", "Faroe Islands")),
        ("FJ", _p("country_name", "Fiji")),
        ("FI", _p("country_name", "Finland")),
        ("FR", _p("country_name", "France")),
        ("GF", _p("country_name", "French Guiana")),
        ("PF", _p("country_name", "French Polynesia")),
        ("TF", _p("country_name", "French Southern Territories")),
        ("GA", _p("country_name", "Gabon")),
        ("GM", _p("country_name", "Gambia")),
        ("GE", _p("country_name", "Georgia")),
        ("DE", _p("country_name", "Germany")),
        ("GH", _p("country_name", "Ghana")),
        ("GI", _p("country_name", "Gibraltar")),
        ("GR", _p("country_name", "Greece")),
        ("GL", _p("country_name", "Greenland")),
        ("GD", _p("country_name", "Grenada")),
        ("GP", _p("country_name", "Guadeloupe")),
        ("GU", _p("country_name", "Guam")),
        ("GT", _p("country_name", "Guatemala")),
        ("GG", _p("country_name", "Guernsey")),
        ("GN", _p("country_name", "Guinea")),
        ("GW", _p("country_name", "Guinea-Bissau")),
        ("GY", _p("country_name", "Guyana")),
        ("HT", _p("country_name", "Haiti")),
        ("HM", _p("country_name", "Heard Island and McDonald Islands")),
        ("VA", _p("country_name", "Vatican City State")),
        ("HN", _p("country_name", "Honduras")),
        ("HK", _p("country_name", "Hong Kong")),
        ("HU", _p("country_name", "Hungary")),
        ("IS", _p("country_name", "Iceland")),
        ("IN", _p("country_name", "India")),
        ("ID", _p("country_name", "Indonesia")),
        ("IR", _p("country_name", "Iran")),
        ("IQ", _p("country_name", "Iraq")),
        ("IE", _p("country_name", "Ireland")),
        ("IM", _p("country_name", "Isle of Man")),
        ("IL", _p("country_name", "Israel")),
        ("IT", _p("country_name", "Italy")),
        ("JM", _p("country_name", "Jamaica")),
        ("JP", _p("country_name", "Japan")),
        ("JE", _p("country_name", "Jersey")),
        ("JO", _p("country_name", "Jordan")),
        ("KZ", _p("country_name", "Kazakhstan")),
        ("KE", _p("country_name", "Kenya")),
        ("KI", _p("country_name", "Kiribati")),
        ("KP", _p("country_name", "North Korea")),
        ("KR", _p("country_name", "South Korea")),
        ("KW", _p("country_name", "Kuwait")),
        ("KG", _p("country_name", "Kyrgyzstan")),
        ("LA", _p("country_name", "Lao")),
        ("LV", _p("country_name", "Latvia")),
        ("LB", _p("country_name", "Lebanon")),
        ("LS", _p("country_name", "Lesotho")),
        ("LR", _p("country_name", "Liberia")),
        ("LY", _p("country_name", "Libya")),
        ("LI", _p("country_name", "Liechtenstein")),
        ("LT", _p("country_name", "Lithuania")),
        ("LU", _p("country_name", "Luxembourg")),
        ("MO", _p("country_name", "Macao")),
        ("MG", _p("country_name", "Madagascar")),
        ("MW", _p("country_name", "Malawi")),
        ("MY", _p("country_name", "Malaysia")),
        ("MV", _p("country_name", "Maldives")),
        ("ML", _p("country_name", "Mali")),
        ("MT", _p("country_name", "Malta")),
        ("MH", _p("country_name", "Marshall Islands")),
        ("MQ", _p("country_name", "Martinique")),
        ("MR", _p("country_name", "Mauritania")),
        ("MU", _p("country_name", "Mauritius")),
        ("YT", _p("country_name", "Mayotte")),
        ("MX", _p("country_name", "Mexico")),
        ("FM", _p("country_name", "Micronesia")),
        ("MD", _p("country_name", "Moldova")),
        ("MC", _p("country_name", "Monaco")),
        ("MN", _p("country_name", "Mongolia")),
        ("ME", _p("country_name", "Montenegro")),
        ("MS", _p("country_name", "Montserrat")),
        ("MA", _p("country_name", "Morocco")),
        ("MZ", _p("country_name", "Mozambique")),
        ("MM", _p("country_name", "Myanmar")),
        ("NA", _p("country_name", "Namibia")),
        ("NR", _p("country_name", "Nauru")),
        ("NP", _p("country_name", "Nepal")),
        ("NL", _p("country_name", "Netherlands")),
        ("NC", _p("country_name", "New Caledonia")),
        ("NZ", _p("country_name", "New Zealand")),
        ("NI", _p("country_name", "Nicaragua")),
        ("NE", _p("country_name", "Niger")),
        ("NG", _p("country_name", "Nigeria")),
        ("NU", _p("country_name", "Niue")),
        ("NF", _p("country_name", "Norfolk Island")),
        ("MK", _p("country_name", "North Macedonia")),
        ("MP", _p("country_name", "Northern Mariana Islands")),
        ("NO", _p("country_name", "Norway")),
        ("OM", _p("country_name", "Oman")),
        ("PK", _p("country_name", "Pakistan")),
        ("PW", _p("country_name", "Palau")),
        ("PS", _p("country_name", "Palestine")),
        ("PA", _p("country_name", "Panama")),
        ("PG", _p("country_name", "Papua New Guinea")),
        ("PY", _p("country_name", "Paraguay")),
        ("PE", _p("country_name", "Peru")),
        ("PH", _p("country_name", "Philippines")),
        ("PN", _p("country_name", "Pitcairn")),
        ("PL", _p("country_name", "Poland")),
        ("PT", _p("country_name", "Portugal")),
        ("PR", _p("country_name", "Puerto Rico")),
        ("QA", _p("country_name", "Qatar")),
        ("RO", _p("country_name", "Romania")),
        ("RU", _p("country_name", "Russian Federation")),
        ("RW", _p("country_name", "Rwanda")),
        ("RE", _p("country_name", "Réunion")),
        ("BL", _p("country_name", "Saint Barthélemy")),
        ("SH", _p("country_name", "Saint Helena, Ascension and Tristan da Cunha")),
        ("KN", _p("country_name", "Saint Kitts and Nevis")),
        ("LC", _p("country_name", "Saint Lucia")),
        ("PM", _p("country_name", "Saint Pierre and Miquelon")),
        ("VC", _p("country_name", "Saint Vincent and the Grenadines")),
        ("WS", _p("country_name", "Samoa")),
        ("SM", _p("country_name", "San Marino")),
        ("ST", _p("country_name", "Sao Tome and Principe")),
        ("SA", _p("country_name", "Saudi Arabia")),
        ("SN", _p("country_name", "Senegal")),
        ("RS", _p("country_name", "Serbia")),
        ("SC", _p("country_name", "Seychelles")),
        ("SL", _p("country_name", "Sierra Leone")),
        ("SG", _p("country_name", "Singapore")),
        ("SX", _p("country_name", "Sint Maarten")),
        ("SK", _p("country_name", "Slovakia")),
        ("SI", _p("country_name", "Slovenia")),
        ("SB", _p("country_name", "Solomon Islands")),
        ("SO", _p("country_name", "Somalia")),
        ("ZA", _p("country_name", "South Africa")),
        ("GS", _p("country_name", "South Georgia and the South Sandwich Islands")),
        ("SS", _p("country_name", "South Sudan")),
        ("ES", _p("country_name", "Spain")),
        ("LK", _p("country_name", "Sri Lanka")),
        ("SD", _p("country_name", "Sudan")),
        ("SR", _p("country_name", "Suriname")),
        ("SJ", _p("country_name", "Svalbard and Jan Mayen")),
        ("SE", _p("country_name", "Sweden")),
        ("CH", _p("country_name", "Switzerland")),
        ("SY", _p("country_name", "Syria")),
        ("TW", _p("country_name", "Taiwan")),
        ("TJ", _p("country_name", "Tajikistan")),
        ("TZ", _p("country_name", "Tanzania")),
        ("TH", _p("country_name", "Thailand")),
        ("TL", _p("country_name", "Timor-Leste")),
        ("TG", _p("country_name", "Togo")),
        ("TK", _p("country_name", "Tokelau")),
        ("TO", _p("country_name", "Tonga")),
        ("TT", _p("country_name", "Trinidad and Tobago")),
        ("TN", _p("country_name", "Tunisia")),
        ("TR", _p("country_name", "Turkey")),
        ("TM", _p("country_name", "Turkmenistan")),
        ("TC", _p("country_name", "Turks and Caicos Islands")),
        ("TV", _p("country_name", "Tuvalu")),
        ("UG", _p("country_name", "Uganda")),
        ("UA", _p("country_name", "Ukraine")),
        ("AE", _p("country_name", "United Arab Emirates")),
        ("GB", _p("country_name", "United Kingdom")),
        ("US", _p("country_name", "United States")),
        ("UM", _p("country_name", "United States Minor Outlying Islands")),
        ("UY", _p("country_name", "Uruguay")),
        ("UZ", _p("country_name", "Uzbekistan")),
        ("VU", _p("country_name", "Vanuatu")),
        ("VE", _p("country_name", "Venezuela")),
        ("VN", _p("country_name", "Vietnam")),
        ("VG", _p("country_name", "Virgin Islands (British)")),
        ("VI", _p("country_name", "Virgin Islands (U.S.)")),
        ("WF", _p("country_name", "Wallis and Futuna")),
        ("EH", _p("country_name", "Western Sahara")),
        ("YE", _p("country_name", "Yemen")),
        ("ZM", _p("country_name", "Zambia")),
        ("ZW", _p("country_name", "Zimbabwe")),
        ("AX", _p("country_name", "Åland Islands")),
    ]
