# Generated by Django 5.1.2 on 2024-11-14 20:53

import _socket
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_sites.managers
import simple_history.models
import uuid
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("edc_registration", "0031_alter_historicalregisteredsubject_site_and_more"),
        ("meta_pharmacy", "0007_lotnumber_medication"),
        ("sites", "0002_alter_domain_unique"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.RemoveField(
            model_name="lotnumber",
            name="medication",
        ),
        migrations.AlterField(
            model_name="historicalrx",
            name="registered_subject",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_registration.registeredsubject",
                verbose_name="Subject Identifier",
            ),
        ),
        migrations.CreateModel(
            name="HistoricalLabelData",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=15, null=True)),
                ("sid", models.IntegerField(help_text="Pharmacy reference", null=True)),
                (
                    "reference",
                    models.CharField(
                        db_index=True,
                        help_text="Bottle reference",
                        max_length=10,
                        null=True,
                    ),
                ),
                ("site_name", models.CharField(max_length=15, null=True)),
                ("gender", models.CharField(max_length=5, null=True)),
                ("pills_per_bottle", models.IntegerField(default=128, null=True)),
                ("printed_datetime", models.DateTimeField(null=True)),
                ("printed", models.BooleanField(default=False)),
                ("scanned", models.BooleanField(default=False)),
                ("scanned_datetime", models.DateTimeField(null=True)),
                ("received_datetime", models.DateTimeField(null=True)),
                (
                    "received",
                    models.BooleanField(default=False, help_text="Received at site"),
                ),
                (
                    "dispensed",
                    models.BooleanField(default=False, help_text="Dispensed to clinic"),
                ),
                ("dispensed_datetime", models.DateTimeField(null=True)),
                (
                    "crf",
                    models.BooleanField(default=False, help_text="Entered into subject's CRF"),
                ),
                ("crf_datetime", models.DateTimeField(null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Label Data",
                "verbose_name_plural": "historical Label Data",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="LabelData",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=15, null=True)),
                ("sid", models.IntegerField(help_text="Pharmacy reference", null=True)),
                (
                    "reference",
                    models.CharField(
                        help_text="Bottle reference",
                        max_length=10,
                        null=True,
                        unique=True,
                    ),
                ),
                ("site_name", models.CharField(max_length=15, null=True)),
                ("gender", models.CharField(max_length=5, null=True)),
                ("pills_per_bottle", models.IntegerField(default=128, null=True)),
                ("printed_datetime", models.DateTimeField(null=True)),
                ("printed", models.BooleanField(default=False)),
                ("scanned", models.BooleanField(default=False)),
                ("scanned_datetime", models.DateTimeField(null=True)),
                ("received_datetime", models.DateTimeField(null=True)),
                (
                    "received",
                    models.BooleanField(default=False, help_text="Received at site"),
                ),
                (
                    "dispensed",
                    models.BooleanField(default=False, help_text="Dispensed to clinic"),
                ),
                ("dispensed_datetime", models.DateTimeField(null=True)),
                (
                    "crf",
                    models.BooleanField(default=False, help_text="Entered into subject's CRF"),
                ),
                ("crf_datetime", models.DateTimeField(null=True)),
                (
                    "site",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Label Data",
                "verbose_name_plural": "Label Data",
            },
            managers=[
                ("on_site", edc_sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.DeleteModel(
            name="Label",
        ),
        migrations.DeleteModel(
            name="LotNumber",
        ),
    ]
