# Generated by Django 4.0.5 on 2022-07-03 12:48

import uuid

import _socket
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_action_item.models.action_model_mixin
import edc_model.validators.date
import edc_utils.date
import simple_history.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("sites", "0002_alter_domain_unique"),
        ("edc_action_item", "0028_auto_20210203_0706"),
        ("meta_prn", "0037_endofstudy_delivery_date_endofstudy_pregnancy_date_and_more"),
    ]

    operations = [
        migrations.AlterField(
            model_name="endofstudy",
            name="delivery_date",
            field=models.DateField(
                blank=True,
                help_text="A Delivery CRF must be on file. Use delivery date, if reported, or report date from Delivery CRF",
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="Date of delivery, if applicable",
            ),
        ),
        migrations.AlterField(
            model_name="endofstudy",
            name="ltfu_date",
            field=models.DateField(
                blank=True,
                help_text="A Loss to followup report must be on file",
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="Date lost to followup, if applicable",
            ),
        ),
        migrations.AlterField(
            model_name="endofstudy",
            name="pregnancy_date",
            field=models.DateField(
                blank=True,
                help_text="A UPT CRF must be on file and participant not on the delivery schedule. Use UPT date or, if UPT not needed, use report date on last UPT CRF.",
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="Date pregnancy known/UPT, if applicable",
            ),
        ),
        migrations.AlterField(
            model_name="historicalendofstudy",
            name="delivery_date",
            field=models.DateField(
                blank=True,
                help_text="A Delivery CRF must be on file. Use delivery date, if reported, or report date from Delivery CRF",
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="Date of delivery, if applicable",
            ),
        ),
        migrations.AlterField(
            model_name="historicalendofstudy",
            name="ltfu_date",
            field=models.DateField(
                blank=True,
                help_text="A Loss to followup report must be on file",
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="Date lost to followup, if applicable",
            ),
        ),
        migrations.AlterField(
            model_name="historicalendofstudy",
            name="pregnancy_date",
            field=models.DateField(
                blank=True,
                help_text="A UPT CRF must be on file and participant not on the delivery schedule. Use UPT date or, if UPT not needed, use report date on last UPT CRF.",
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="Date pregnancy known/UPT, if applicable",
            ),
        ),
        migrations.CreateModel(
            name="OffStudyMedication",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                ("tracking_identifier", models.CharField(max_length=32, unique=True)),
                ("action_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow, verbose_name="Report Date and Time"
                    ),
                ),
                (
                    "stop_date",
                    models.DateField(verbose_name="Date decision to stop study medication"),
                ),
                ("last_dose_date", models.DateField(verbose_name="Date of last known dose")),
                (
                    "reason",
                    models.CharField(
                        choices=[
                            ("pregnancy", "Pregnancy"),
                            ("sae", "Participant is experiencing a serious adverse event"),
                            (
                                "clinician",
                                "Other condition that justifies discontinuation of treatment in the clinician’s opinion (specify below)",
                            ),
                            ("investigator", " Investigator decision"),
                            ("patient", "Patient decision"),
                            ("OTHER", "Other reason (specify below)"),
                        ],
                        max_length=25,
                        verbose_name="Reason for stopping study medication",
                    ),
                ),
                (
                    "permanently_discontinued",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is study medication being permanently discontinued",
                    ),
                ),
                (
                    "permanently_discontinued_reason",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Reason study medication being permanently discontinued",
                    ),
                ),
                (
                    "expected_restart_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_is_future],
                        verbose_name="If not permanently discontinued, expected restart date",
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Withdrawal of Study Drug",
                "verbose_name_plural": "Withdrawal of Study Drug",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                (
                    "objects",
                    edc_action_item.models.action_model_mixin.ActionIdentifierModelManager(),
                ),
            ],
        ),
        migrations.CreateModel(
            name="HistoricalOffStudyMedication",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                ("tracking_identifier", models.CharField(db_index=True, max_length=32)),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow, verbose_name="Report Date and Time"
                    ),
                ),
                (
                    "stop_date",
                    models.DateField(verbose_name="Date decision to stop study medication"),
                ),
                ("last_dose_date", models.DateField(verbose_name="Date of last known dose")),
                (
                    "reason",
                    models.CharField(
                        choices=[
                            ("pregnancy", "Pregnancy"),
                            ("sae", "Participant is experiencing a serious adverse event"),
                            (
                                "clinician",
                                "Other condition that justifies discontinuation of treatment in the clinician’s opinion (specify below)",
                            ),
                            ("investigator", " Investigator decision"),
                            ("patient", "Patient decision"),
                            ("OTHER", "Other reason (specify below)"),
                        ],
                        max_length=25,
                        verbose_name="Reason for stopping study medication",
                    ),
                ),
                (
                    "permanently_discontinued",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is study medication being permanently discontinued",
                    ),
                ),
                (
                    "permanently_discontinued_reason",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Reason study medication being permanently discontinued",
                    ),
                ),
                (
                    "expected_restart_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_is_future],
                        verbose_name="If not permanently discontinued, expected restart date",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Withdrawal of Study Drug",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
