# Generated by Django 3.0.6 on 2020-05-19 21:20

import uuid

import _socket
import django.contrib.sites.managers
import django.core.validators
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_model.validators.date
import edc_protocol.validators
import edc_utils.date
import edc_visit_tracking.managers
import simple_history.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("sites", "0002_alter_domain_unique"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("meta_subject", "0037_auto_20200517_0207"),
    ]

    operations = [
        migrations.AlterField(
            model_name="historicalmissedvisit",
            name="contact_attempts_count",
            field=models.IntegerField(
                blank=True,
                help_text="Not including pre-appointment reminders",
                null=True,
                validators=[django.core.validators.MinValueValidator(1)],
                verbose_name="Number of attempts made to contact participant since the expected appointment date",
            ),
        ),
        migrations.AlterField(
            model_name="historicalmissedvisit",
            name="contact_attempts_explained",
            field=models.TextField(
                blank=True,
                null=True,
                verbose_name="If contact not made and less than 3 attempts, please explain",
            ),
        ),
        migrations.AlterField(
            model_name="missedvisit",
            name="contact_attempts_count",
            field=models.IntegerField(
                blank=True,
                help_text="Not including pre-appointment reminders",
                null=True,
                validators=[django.core.validators.MinValueValidator(1)],
                verbose_name="Number of attempts made to contact participant since the expected appointment date",
            ),
        ),
        migrations.AlterField(
            model_name="missedvisit",
            name="contact_attempts_explained",
            field=models.TextField(
                blank=True,
                null=True,
                verbose_name="If contact not made and less than 3 attempts, please explain",
            ),
        ),
        migrations.CreateModel(
            name="HistoricalGlucose",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "fasted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Has the participant fasted?",
                    ),
                ),
                (
                    "fasted_duration_str",
                    models.CharField(
                        blank=True,
                        help_text="Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc",
                        max_length=8,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                                message="Invalid format. Expected something like 1h20m, 11h5m, etc",
                            )
                        ],
                        verbose_name="How long have they fasted in hours and/or minutes?",
                    ),
                ),
                (
                    "fasted_duration_minutes",
                    models.IntegerField(help_text="system calculated value", null=True),
                ),
                (
                    "fasting_glucose",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        verbose_name="Fasting glucose <u>level</u>",
                    ),
                ),
                (
                    "fasting_glucose_quantifier",
                    models.CharField(
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                    ),
                ),
                (
                    "fasting_glucose_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="Units (fasting glucose)",
                    ),
                ),
                (
                    "fasting_glucose_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="<u>Time</u> fasting glucose <u>level</u> measured",
                    ),
                ),
                (
                    "ogtt_base_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="(glucose solution given)",
                        null=True,
                        verbose_name="<u>Time</u> oral glucose solution was given",
                    ),
                ),
                (
                    "ogtt_two_hr",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        verbose_name="Blood glucose <u>level</u> 2-hours after oral glucose solution given",
                    ),
                ),
                (
                    "ogtt_two_hr_quantifier",
                    models.CharField(
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                    ),
                ),
                (
                    "ogtt_two_hr_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="Units (Blood glucose 2hrs after...)",
                    ),
                ),
                (
                    "ogtt_two_hr_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="(2 hours after glucose solution given)",
                        null=True,
                        verbose_name="<u>Time</u> blood glucose measured 2-hours after oral glucose solution given",
                    ),
                ),
                (
                    "ifg_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Was the IFG test performed?",
                    ),
                ),
                (
                    "ifg_not_performed_reason",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If NO, provide reason",
                    ),
                ),
                (
                    "ogtt_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Was the OGTT test performed?",
                    ),
                ),
                (
                    "ogtt_not_performed_reason",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If NO, provide reason",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Glucose (IFG, OGTT)",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="Glucose",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "fasted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Has the participant fasted?",
                    ),
                ),
                (
                    "fasted_duration_str",
                    models.CharField(
                        blank=True,
                        help_text="Duration of fast. Format is `HHhMMm`. For example 1h23m, 12h7m, etc",
                        max_length=8,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                                message="Invalid format. Expected something like 1h20m, 11h5m, etc",
                            )
                        ],
                        verbose_name="How long have they fasted in hours and/or minutes?",
                    ),
                ),
                (
                    "fasted_duration_minutes",
                    models.IntegerField(help_text="system calculated value", null=True),
                ),
                (
                    "fasting_glucose",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        verbose_name="Fasting glucose <u>level</u>",
                    ),
                ),
                (
                    "fasting_glucose_quantifier",
                    models.CharField(
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                    ),
                ),
                (
                    "fasting_glucose_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="Units (fasting glucose)",
                    ),
                ),
                (
                    "fasting_glucose_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="<u>Time</u> fasting glucose <u>level</u> measured",
                    ),
                ),
                (
                    "ogtt_base_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="(glucose solution given)",
                        null=True,
                        verbose_name="<u>Time</u> oral glucose solution was given",
                    ),
                ),
                (
                    "ogtt_two_hr",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        verbose_name="Blood glucose <u>level</u> 2-hours after oral glucose solution given",
                    ),
                ),
                (
                    "ogtt_two_hr_quantifier",
                    models.CharField(
                        choices=[
                            ("=", "="),
                            (">", ">"),
                            (">=", ">="),
                            ("<", "<"),
                            ("<=", "<="),
                        ],
                        default="=",
                        max_length=10,
                    ),
                ),
                (
                    "ogtt_two_hr_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="Units (Blood glucose 2hrs after...)",
                    ),
                ),
                (
                    "ogtt_two_hr_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="(2 hours after glucose solution given)",
                        null=True,
                        verbose_name="<u>Time</u> blood glucose measured 2-hours after oral glucose solution given",
                    ),
                ),
                (
                    "ifg_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Was the IFG test performed?",
                    ),
                ),
                (
                    "ifg_not_performed_reason",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If NO, provide reason",
                    ),
                ),
                (
                    "ogtt_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Was the OGTT test performed?",
                    ),
                ),
                (
                    "ogtt_not_performed_reason",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If NO, provide reason",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Glucose (IFG, OGTT)",
                "verbose_name_plural": "Glucose (IFG, OGTT)",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.AddIndex(
            model_name="glucose",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="meta_subjec_subject_35e440_idx",
            ),
        ),
    ]
