# Generated by Django 3.2.13 on 2022-09-13 21:39
from django.db import migrations
from tqdm import tqdm


def update_rs_missing_ethnicity(apps, schema_editor):
    register_subject_model_cls = apps.get_model("edc_registration.registeredsubject")
    subject_consent_model_cls = apps.get_model("meta_consent.subjectconsent")
    try:
        subject_screening_model_cls = apps.get_model("meta_screening.subjectscreening")
    except LookupError:
        pass
    else:
        total = subject_consent_model_cls.objects.all().count()
        for subject_consent in tqdm(subject_consent_model_cls.objects.all(), total=total):
            subject_screening = subject_screening_model_cls.objects.get(
                subject_identifier=subject_consent.subject_identifier
            )
            register_subject = register_subject_model_cls.objects.get(
                subject_identifier=subject_consent.subject_identifier
            )
            register_subject.ethnicity = subject_screening.ethnicity
            register_subject.save(update_fields=["ethnicity"])


class Migration(migrations.Migration):
    dependencies = [
        ("meta_consent", "0014_alter_subjectconsent_managers"),
        ("meta_subject", "0149_auto_20220913_2139"),
    ]

    operations = [migrations.RunPython(update_rs_missing_ethnicity)]
