# Generated by Django 5.0.1 on 2024-02-12 22:37

import _socket
import django.core.validators
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_crf.model_mixins.crf_status_model_mixin
import edc_model.validators.date
import edc_model_fields.fields.other_charfield
import edc_protocol.validators
import edc_utils.date
import edc_visit_tracking.managers
import simple_history.models
import uuid
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("meta_lists", "0017_complications_dmmedications_dmtreatments_and_more"),
        ("meta_subject", "0163_alter_birthoutcomes_options_and_more"),
        ("sites", "0002_alter_domain_unique"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="DmReferralFollowup",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "referral_date",
                    models.DateField(verbose_name="Date of referral to diabetes clinic"),
                ),
                (
                    "attended",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Did you attend the diabetes clinic following referral from the META Trial",
                    ),
                ),
                (
                    "not_attended_reason",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If 'No', please provide a reason for not seeking further care or follow up?",
                    ),
                ),
                (
                    "facility_attended",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If ‘Yes’, please give the name of the facility you attended",
                    ),
                ),
                (
                    "attended_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="What was the date you attended the health facility named above?",
                    ),
                ),
                (
                    "healthcare_workers_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other 'healthcare worker', please specify ...",
                    ),
                ),
                (
                    "investigations_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        max_length=25,
                        verbose_name="Were any further investigations conducted at this visit?",
                    ),
                ),
                (
                    "investigations_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other 'investigations', please specify ...",
                    ),
                ),
                (
                    "on_dm_medications",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Are you currently taking any drug therapy for diabetes?",
                    ),
                ),
                (
                    "dm_medications_init_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="If ‘Yes’, please give the date when drug treatment was started.",
                    ),
                ),
                (
                    "dm_medications_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other 'drug treatments', please specify ...",
                    ),
                ),
                (
                    "medications_adherent",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Are you taking the diabetes drug treatments regularly, i.e. every day?",
                    ),
                ),
                (
                    "visual_score_slider",
                    models.CharField(help_text="%", max_length=3, verbose_name="Visual score"),
                ),
                (
                    "visual_score_confirmed",
                    models.IntegerField(
                        help_text="%",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                        verbose_name="<B><font color='orange'>Interviewer</font></B>: please transcribe the score indicated from above.",
                    ),
                ),
                (
                    "last_missed_pill",
                    models.CharField(
                        choices=[
                            ("today", "today"),
                            ("yesterday", "yesterday"),
                            ("earlier_this_week", "earlier this week"),
                            ("last_week", "last week"),
                            ("lt_month_ago", "less than a month ago"),
                            ("gt_month_ago", "more than a month ago"),
                            ("NEVER", "have never missed taking my study pills"),
                        ],
                        max_length=25,
                        verbose_name="When was the last time you missed your study pill?",
                    ),
                ),
                (
                    "complications_checks",
                    models.ManyToManyField(
                        blank=True,
                        to="meta_lists.complications",
                        verbose_name="Have any tests for diabetes related complications been done?",
                    ),
                ),
                (
                    "dm_medications",
                    models.ManyToManyField(
                        to="meta_lists.dmmedications",
                        verbose_name="If ‘Yes’, please indicate which diabetes drug treatments you are currently taking.",
                    ),
                ),
                (
                    "dm_treatments",
                    models.ManyToManyField(
                        to="meta_lists.dmtreatments",
                        verbose_name="What treatment was prescribed at this visit?",
                    ),
                ),
                (
                    "healthcare_workers",
                    models.ManyToManyField(blank=True, to="meta_lists.healthcareworkers"),
                ),
                (
                    "investigations",
                    models.ManyToManyField(
                        blank=True,
                        to="meta_lists.investigations",
                        verbose_name="If ‘Yes’, please indicate what investigations were conducted.",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Diabetes referral follow-up",
                "verbose_name_plural": "Diabetes referral follow-up",
            },
            managers=[
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name="HistoricalDmReferralFollowup",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default=edc_crf.model_mixins.crf_status_model_mixin.get_crf_status_default,
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "referral_date",
                    models.DateField(verbose_name="Date of referral to diabetes clinic"),
                ),
                (
                    "attended",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Did you attend the diabetes clinic following referral from the META Trial",
                    ),
                ),
                (
                    "not_attended_reason",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If 'No', please provide a reason for not seeking further care or follow up?",
                    ),
                ),
                (
                    "facility_attended",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If ‘Yes’, please give the name of the facility you attended",
                    ),
                ),
                (
                    "attended_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="What was the date you attended the health facility named above?",
                    ),
                ),
                (
                    "healthcare_workers_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other 'healthcare worker', please specify ...",
                    ),
                ),
                (
                    "investigations_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        max_length=25,
                        verbose_name="Were any further investigations conducted at this visit?",
                    ),
                ),
                (
                    "investigations_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other 'investigations', please specify ...",
                    ),
                ),
                (
                    "on_dm_medications",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Are you currently taking any drug therapy for diabetes?",
                    ),
                ),
                (
                    "dm_medications_init_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="If ‘Yes’, please give the date when drug treatment was started.",
                    ),
                ),
                (
                    "dm_medications_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other 'drug treatments', please specify ...",
                    ),
                ),
                (
                    "medications_adherent",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Are you taking the diabetes drug treatments regularly, i.e. every day?",
                    ),
                ),
                (
                    "visual_score_slider",
                    models.CharField(help_text="%", max_length=3, verbose_name="Visual score"),
                ),
                (
                    "visual_score_confirmed",
                    models.IntegerField(
                        help_text="%",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                        verbose_name="<B><font color='orange'>Interviewer</font></B>: please transcribe the score indicated from above.",
                    ),
                ),
                (
                    "last_missed_pill",
                    models.CharField(
                        choices=[
                            ("today", "today"),
                            ("yesterday", "yesterday"),
                            ("earlier_this_week", "earlier this week"),
                            ("last_week", "last week"),
                            ("lt_month_ago", "less than a month ago"),
                            ("gt_month_ago", "more than a month ago"),
                            ("NEVER", "have never missed taking my study pills"),
                        ],
                        max_length=25,
                        verbose_name="When was the last time you missed your study pill?",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Diabetes referral follow-up",
                "verbose_name_plural": "historical Diabetes referral follow-up",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
