# Generated by Django 4.2.11 on 2024-05-16 00:15
from django.db import migrations
from edc_model.utils import duration_hm_to_timedelta
from tqdm import tqdm


def update_duration(apps, schema_editor):
    for model in [
        "meta_subject.glucosefbg",
        "meta_subject.glucose",
        "meta_subject.bloodresultsins",
    ]:
        model_cls = apps.get_model(model)
        qs = model_cls.objects.all()
        total = qs.count()
        for obj in tqdm(qs, total=total):
            if obj.fasting_duration_str:
                tdelta = duration_hm_to_timedelta(obj.fasting_duration_str)
                obj.fasting_duration_delta = tdelta
                obj.save()


class Migration(migrations.Migration):

    dependencies = [
        (
            "meta_subject",
            "0201_alter_bloodresultsins_fasting_duration_delta_and_more",
        ),
    ]

    operations = [migrations.RunPython(update_duration)]
