/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.mpxj.BaselineStrategy;
import org.mpxj.FieldType;
import org.mpxj.ProjectFile;
import org.mpxj.Task;
import org.mpxj.TaskField;
import org.mpxj.common.TaskFieldLists;

public abstract class AbstractBaselineStrategy
implements BaselineStrategy {
    private static final TaskField[] SOURCE_FIELDS = new TaskField[]{TaskField.COST, TaskField.DURATION, TaskField.FINISH, TaskField.FIXED_COST_ACCRUAL, TaskField.FIXED_COST, TaskField.START, TaskField.WORK};
    private static final TaskField[] BASELINE0_FIELDS = new TaskField[]{TaskField.BASELINE_COST, TaskField.BASELINE_DURATION, TaskField.BASELINE_FINISH, TaskField.BASELINE_FIXED_COST_ACCRUAL, TaskField.BASELINE_FIXED_COST, TaskField.BASELINE_START, TaskField.BASELINE_WORK};

    @Override
    public void clearBaseline(ProjectFile project, int index) {
        TaskField[] baselineFields = this.getBaselineFields(index);
        project.getTasks().forEach(t -> this.populateBaseline((Task)t, null, baselineFields));
    }

    @Override
    public void populateBaseline(ProjectFile project, ProjectFile baseline, int index) {
        TaskField[] baselineFields = this.getBaselineFields(index);
        Map<Object, Task> map = baseline.getTasks().stream().filter(t -> this.getKeyForTask((Task)t) != null).collect(Collectors.toMap(this::getKeyForTask, t -> t, (u, v) -> null));
        Map<Task, Task> baselineTaskMap = project.getTasks().stream().filter(t -> map.get(this.getKeyForTask((Task)t)) != null).collect(Collectors.toMap(t -> t, t -> (Task)map.get(this.getKeyForTask((Task)t))));
        project.setBaselineTaskMap(index, baselineTaskMap);
        project.getTasks().forEach(t -> this.populateBaseline((Task)t, (Task)baselineTaskMap.get(t), baselineFields));
    }

    private void populateBaseline(Task task, Task baseline, TaskField[] baselineFields) {
        TaskField[] sourceFields = this.getSourceFields();
        IntStream.range(0, sourceFields.length).forEach(i -> task.set((FieldType)baselineFields[i], baseline == null ? null : baseline.getCachedValue(sourceFields[i])));
    }

    protected Object getKeyForTask(Task task) {
        return task.getGUID();
    }

    protected TaskField[] getBaselineFields(int index) {
        TaskField[] fields = index == 0 ? BASELINE0_FIELDS : new TaskField[]{TaskFieldLists.BASELINE_COSTS[--index], TaskFieldLists.BASELINE_DURATIONS[index], TaskFieldLists.BASELINE_FINISHES[index], TaskFieldLists.BASELINE_FIXED_COST_ACCRUALS[index], TaskFieldLists.BASELINE_FIXED_COSTS[index], TaskFieldLists.BASELINE_STARTS[index], TaskFieldLists.BASELINE_WORKS[index]};
        return fields;
    }

    protected TaskField[] getSourceFields() {
        return SOURCE_FIELDS;
    }
}

