/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.mpxj.FieldContainer;
import org.mpxj.FieldType;
import org.mpxj.ProjectEntity;
import org.mpxj.ProjectFile;
import org.mpxj.listener.FieldListener;

public abstract class AbstractFieldContainer<T>
extends ProjectEntity
implements FieldContainer {
    private boolean m_clearDependentFieldsEnabled = true;
    private final Map<FieldType, Object> m_fields = new HashMap<FieldType, Object>();
    private List<FieldListener> m_listeners;

    protected AbstractFieldContainer(ProjectFile file) {
        super(file);
    }

    abstract void handleFieldChange(FieldType var1, Object var2, Object var3);

    abstract boolean getAlwaysCalculatedField(FieldType var1);

    abstract Function<T, Object> getCalculationMethod(FieldType var1);

    void clearDependentFields(Map<FieldType, List<FieldType>> dependencyMap, FieldType field) {
        if (!this.m_clearDependentFieldsEnabled) {
            return;
        }
        List<FieldType> dependencies = dependencyMap.get(field);
        if (dependencies == null) {
            return;
        }
        dependencies.forEach(f -> this.set((FieldType)f, null));
    }

    public void disableEvents() {
        this.m_clearDependentFieldsEnabled = false;
    }

    public void enableEvents() {
        this.m_clearDependentFieldsEnabled = true;
    }

    @Override
    public void set(FieldType field, Object value) {
        Object oldValue;
        if (field == null) {
            return;
        }
        Object object = oldValue = value == null ? this.m_fields.remove(field) : this.m_fields.put(field, value);
        if (oldValue == value) {
            return;
        }
        if (oldValue == null && value != null || oldValue != null && value == null || oldValue != null && !oldValue.equals(value)) {
            this.handleFieldChange(field, oldValue, value);
            this.fireFieldChangeEvent(field, oldValue, value);
        }
    }

    @Override
    public Object get(FieldType field) {
        Function<AbstractFieldContainer, Object> f;
        Object result;
        if (field == null) {
            return null;
        }
        boolean alwaysCalculatedField = this.getAlwaysCalculatedField(field);
        Object object = result = alwaysCalculatedField ? null : this.m_fields.get(field);
        if (result == null && (f = this.getCalculationMethod(field)) != null && (result = f.apply(this)) != null && !alwaysCalculatedField) {
            this.set(field, result);
        }
        return result;
    }

    @Override
    public Object getCachedValue(FieldType field) {
        return this.m_fields.get(field);
    }

    @Override
    public void addFieldListener(FieldListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList<FieldListener>();
        }
        this.m_listeners.add(listener);
    }

    @Override
    public void removeFieldListener(FieldListener listener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(listener);
        }
    }

    private void fireFieldChangeEvent(FieldType field, Object oldValue, Object newValue) {
        if (this.m_listeners != null) {
            this.m_listeners.forEach(l -> l.fieldChange(this, field, oldValue, newValue));
        }
    }
}

