/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.awt.Color;
import java.util.List;
import java.util.stream.Collectors;
import org.mpxj.ActivityCode;
import org.mpxj.CodeValue;
import org.mpxj.UniqueIdObjectSequenceProvider;

public final class ActivityCodeValue
implements CodeValue {
    private final ActivityCode m_activityCode;
    private final Integer m_uniqueID;
    private final Integer m_sequenceNumber;
    private final String m_name;
    private final String m_description;
    private final Color m_color;
    private final ActivityCodeValue m_parentValue;

    private ActivityCodeValue(Builder builder) {
        this.m_uniqueID = builder.m_sequenceProvider.getUniqueIdObjectSequence(ActivityCodeValue.class).syncOrGetNext(builder.m_uniqueID);
        this.m_activityCode = builder.m_activityCode;
        this.m_sequenceNumber = builder.m_sequenceNumber;
        this.m_name = builder.m_name;
        this.m_description = builder.m_description;
        this.m_color = builder.m_color;
        this.m_parentValue = builder.m_parentValue;
    }

    @Override
    public ActivityCode getParentCode() {
        return this.m_activityCode;
    }

    @Override
    public Integer getParentCodeUniqueID() {
        return this.m_activityCode == null ? null : this.m_activityCode.getUniqueID();
    }

    @Override
    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    @Override
    public Integer getSequenceNumber() {
        return this.m_sequenceNumber;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public Color getColor() {
        return this.m_color;
    }

    public ActivityCodeValue getParentValue() {
        return this.m_parentValue;
    }

    @Override
    public Integer getParentValueUniqueID() {
        return this.m_parentValue == null ? null : this.m_parentValue.getUniqueID();
    }

    public List<ActivityCodeValue> getChildValues() {
        return this.m_activityCode.getValues().stream().filter(a -> a.m_parentValue == this).collect(Collectors.toList());
    }

    public String toString() {
        return this.m_activityCode.getName() + ": " + this.m_name;
    }

    public static class Builder {
        private final UniqueIdObjectSequenceProvider m_sequenceProvider;
        private ActivityCode m_activityCode;
        private Integer m_uniqueID;
        private Integer m_sequenceNumber;
        private String m_name;
        private String m_description;
        private Color m_color;
        private ActivityCodeValue m_parentValue;

        public Builder(UniqueIdObjectSequenceProvider sequenceProvider) {
            this.m_sequenceProvider = sequenceProvider;
        }

        public Builder from(ActivityCodeValue value) {
            this.m_activityCode = value.m_activityCode;
            this.m_uniqueID = value.m_uniqueID;
            this.m_sequenceNumber = value.m_sequenceNumber;
            this.m_name = value.m_name;
            this.m_description = value.m_description;
            this.m_color = value.m_color;
            this.m_parentValue = value.m_parentValue;
            return this;
        }

        public Builder activityCode(ActivityCode value) {
            this.m_activityCode = value;
            return this;
        }

        public Builder uniqueID(Integer value) {
            this.m_uniqueID = value;
            return this;
        }

        public Builder sequenceNumber(Integer value) {
            this.m_sequenceNumber = value;
            return this;
        }

        public Builder name(String value) {
            this.m_name = value;
            return this;
        }

        public Builder description(String value) {
            this.m_description = value;
            return this;
        }

        public Builder color(Color value) {
            this.m_color = value;
            return this;
        }

        public Builder parentValue(ActivityCodeValue value) {
            this.m_parentValue = value;
            return this;
        }

        public ActivityCodeValue build() {
            return new ActivityCodeValue(this);
        }
    }
}

