/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import org.mpxj.Notes;
import org.mpxj.ProjectEntityWithUniqueID;
import org.mpxj.UniqueIdObjectSequenceProvider;

public final class CostAccount
implements ProjectEntityWithUniqueID {
    private final Integer m_uniqueID;
    private final String m_id;
    private final String m_name;
    private final Notes m_notes;
    private final Integer m_sequenceNumber;
    private final CostAccount m_parent;

    private CostAccount(Builder builder) {
        this.m_uniqueID = builder.m_sequenceProvider.getUniqueIdObjectSequence(CostAccount.class).syncOrGetNext(builder.m_uniqueID);
        this.m_id = builder.m_id;
        this.m_name = builder.m_name;
        this.m_notes = builder.m_notes;
        this.m_sequenceNumber = builder.m_sequenceNumber;
        this.m_parent = builder.m_parent;
    }

    @Override
    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public String getID() {
        return this.m_id;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNotes() {
        return this.m_notes == null ? null : this.m_notes.toString();
    }

    public Notes getNotesObject() {
        return this.m_notes;
    }

    public Integer getSequenceNumber() {
        return this.m_sequenceNumber;
    }

    public Integer getParentUniqueID() {
        return this.m_parent == null ? null : this.m_parent.getUniqueID();
    }

    public CostAccount getParent() {
        return this.m_parent;
    }

    public String toString() {
        return "[CostAccount uniqueID=" + this.m_uniqueID + " name=" + this.m_name + "]";
    }

    public static class Builder {
        private final UniqueIdObjectSequenceProvider m_sequenceProvider;
        private Integer m_uniqueID;
        private String m_id;
        private String m_name;
        private Notes m_notes;
        private Integer m_sequenceNumber;
        private CostAccount m_parent;

        public Builder(UniqueIdObjectSequenceProvider sequenceProvider) {
            this.m_sequenceProvider = sequenceProvider;
        }

        public Builder from(CostAccount value) {
            this.m_uniqueID = value.m_uniqueID;
            this.m_id = value.m_id;
            this.m_name = value.m_name;
            this.m_notes = value.m_notes;
            this.m_sequenceNumber = value.m_sequenceNumber;
            this.m_parent = value.m_parent;
            return this;
        }

        public Builder uniqueID(Integer value) {
            this.m_uniqueID = value;
            return this;
        }

        public Builder id(String value) {
            this.m_id = value;
            return this;
        }

        public Builder name(String value) {
            this.m_name = value;
            return this;
        }

        public Builder notes(String value) {
            this.m_notes = new Notes(value);
            return this;
        }

        public Builder notes(Notes value) {
            this.m_notes = value;
            return this;
        }

        public Builder sequenceNumber(Integer value) {
            this.m_sequenceNumber = value;
            return this;
        }

        public Builder parent(CostAccount value) {
            this.m_parent = value;
            return this;
        }

        public CostAccount build() {
            return new CostAccount(this);
        }
    }
}

