/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.util.ArrayList;
import java.util.List;
import org.mpxj.CustomFieldContainer;
import org.mpxj.CustomFieldLookupTable;
import org.mpxj.CustomFieldValueMask;
import org.mpxj.FieldType;
import org.mpxj.GraphicalIndicator;
import org.mpxj.common.FieldTypeHelper;

public class CustomField
implements Comparable<CustomField> {
    private final FieldType m_field;
    private final CustomFieldContainer m_parent;
    private final CustomFieldLookupTable m_table;
    private final GraphicalIndicator m_indicator;
    private final List<CustomFieldValueMask> m_masks;
    private Integer m_uniqueID;
    private String m_alias;

    public CustomField(FieldType field, CustomFieldContainer parent) {
        this.m_field = field;
        this.m_parent = parent;
        this.m_table = new CustomFieldLookupTable();
        this.m_indicator = new GraphicalIndicator(field);
        this.m_masks = new ArrayList<CustomFieldValueMask>();
    }

    public FieldType getFieldType() {
        return this.m_field;
    }

    public CustomFieldLookupTable getLookupTable() {
        return this.m_table;
    }

    public GraphicalIndicator getGraphicalIndicator() {
        return this.m_indicator;
    }

    public String getAlias() {
        return this.m_alias;
    }

    public CustomField setAlias(String alias) {
        this.m_alias = alias;
        this.m_parent.registerAlias(this.m_field, alias);
        return this;
    }

    public Integer getUniqueID() {
        if (this.m_uniqueID == null) {
            this.m_uniqueID = FieldTypeHelper.getFieldID(this.m_field);
        }
        return this.m_uniqueID;
    }

    public CustomField setUniqueID(Integer uniqueID) {
        this.m_uniqueID = uniqueID;
        return this;
    }

    public List<CustomFieldValueMask> getMasks() {
        return this.m_masks;
    }

    @Override
    public int compareTo(CustomField f) {
        String name1 = this.getFieldType().getFieldTypeClass().name() + "." + this.getUniqueID() + "." + this.getAlias();
        String name2 = f.getFieldType().getFieldTypeClass().name() + "." + f.getUniqueID() + "." + f.getAlias();
        return name1.compareTo(name2);
    }

    public String toString() {
        return "[CustomField field=" + this.m_field + " alias=" + this.m_alias + "]";
    }
}

