/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mpxj.EpsNode;
import org.mpxj.EpsProjectNode;

public class EPS {
    private final Map<Integer, EpsNode> m_nodes = new LinkedHashMap<Integer, EpsNode>();
    private final Map<Integer, EpsProjectNode> m_projectNodes = new LinkedHashMap<Integer, EpsProjectNode>();

    public List<EpsNode> getEpsNodes() {
        return new ArrayList<EpsNode>(this.m_nodes.values());
    }

    public EpsNode getRootEpsNode() {
        return this.m_nodes.values().stream().filter(n -> n.getParentUniqueID() == null).findFirst().orElse(null);
    }

    public EpsNode getEpsNodeByUniqueID(Integer value) {
        return this.m_nodes.get(value);
    }

    public List<EpsProjectNode> getEpsProjectNodes() {
        return new ArrayList<EpsProjectNode>(this.m_projectNodes.values());
    }

    public EpsProjectNode getProjectNodeByUniqueID(Integer value) {
        return this.m_projectNodes.get(value);
    }

    void addEpsChildNode(Integer uniqueID, EpsNode node) {
        this.m_nodes.put(uniqueID, node);
    }

    void addEpsProjectNode(Integer uniqueID, EpsProjectNode node) {
        this.m_projectNodes.put(uniqueID, node);
    }
}

