/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.util.List;
import java.util.stream.Collectors;
import org.mpxj.EPS;
import org.mpxj.EpsProjectNode;

public class EpsNode {
    private final EPS m_eps;
    private final Integer m_uniqueID;
    private final Integer m_parentUniqueID;
    private final String m_name;
    private final String m_shortName;

    public EpsNode(EPS eps, Integer uniqueID, Integer parentUniqueID, String name, String shortName) {
        this.m_eps = eps;
        this.m_uniqueID = uniqueID;
        this.m_parentUniqueID = parentUniqueID;
        this.m_name = name;
        this.m_shortName = shortName;
        eps.addEpsChildNode(this.m_uniqueID, this);
    }

    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public Integer getParentUniqueID() {
        return this.m_parentUniqueID;
    }

    public String getName() {
        return this.m_name;
    }

    public String getShortName() {
        return this.m_shortName;
    }

    public List<EpsNode> getChildEpsNodes() {
        return this.m_eps.getEpsNodes().stream().filter(n -> this.m_uniqueID.equals(n.getParentUniqueID())).collect(Collectors.toList());
    }

    public List<EpsProjectNode> getEpsProjectNodes() {
        return this.m_eps.getEpsProjectNodes().stream().filter(n -> n.getParentEpsUniqueID().equals(this.m_uniqueID)).collect(Collectors.toList());
    }
}

