/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import org.mpxj.ProjectEntityWithUniqueID;
import org.mpxj.UniqueIdObjectSequenceProvider;

public final class ExpenseCategory
implements ProjectEntityWithUniqueID {
    private final Integer m_uniqueID;
    private final String m_name;
    private final Integer m_sequenceNumber;

    private ExpenseCategory(Builder builder) {
        this.m_uniqueID = builder.m_sequenceProvider.getUniqueIdObjectSequence(ExpenseCategory.class).syncOrGetNext(builder.m_uniqueID);
        this.m_name = builder.m_name;
        this.m_sequenceNumber = builder.m_sequenceNumber;
    }

    @Override
    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public String getName() {
        return this.m_name;
    }

    public Integer getSequenceNumber() {
        return this.m_sequenceNumber;
    }

    public String toString() {
        return "[ExpenseCategory uniqueID=" + this.m_uniqueID + " name=" + this.m_name + "]";
    }

    public static class Builder {
        private final UniqueIdObjectSequenceProvider m_sequenceProvider;
        private Integer m_uniqueID;
        private String m_name;
        private Integer m_sequenceNumber;

        public Builder(UniqueIdObjectSequenceProvider sequenceProvider) {
            this.m_sequenceProvider = sequenceProvider;
        }

        public Builder from(ExpenseCategory value) {
            this.m_uniqueID = value.m_uniqueID;
            this.m_name = value.m_name;
            this.m_sequenceNumber = value.m_sequenceNumber;
            return this;
        }

        public Builder uniqueID(Integer value) {
            this.m_uniqueID = value;
            return this;
        }

        public Builder name(String value) {
            this.m_name = value;
            return this;
        }

        public Builder sequenceNumber(Integer value) {
            this.m_sequenceNumber = value;
            return this;
        }

        public ExpenseCategory build() {
            return new ExpenseCategory(this);
        }
    }
}

