/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import org.mpxj.ProjectEntityWithUniqueID;
import org.mpxj.UniqueIdObjectSequenceProvider;

public final class Location
implements ProjectEntityWithUniqueID {
    private final String m_addressLine1;
    private final String m_addressLine2;
    private final String m_addressLine3;
    private final String m_city;
    private final String m_country;
    private final String m_countryCode;
    private final Double m_latitude;
    private final Double m_longitude;
    private final String m_municipality;
    private final String m_name;
    private final Integer m_uniqueID;
    private final String m_postalCode;
    private final String m_state;
    private final String m_stateCode;

    private Location(Builder builder) {
        this.m_uniqueID = builder.m_sequenceProvider.getUniqueIdObjectSequence(Location.class).syncOrGetNext(builder.m_uniqueID);
        this.m_addressLine1 = builder.m_addressLine1;
        this.m_addressLine2 = builder.m_addressLine2;
        this.m_addressLine3 = builder.m_addressLine3;
        this.m_city = builder.m_city;
        this.m_country = builder.m_country;
        this.m_countryCode = builder.m_countryCode;
        this.m_latitude = builder.m_latitude;
        this.m_longitude = builder.m_longitude;
        this.m_municipality = builder.m_municipality;
        this.m_name = builder.m_name;
        this.m_postalCode = builder.m_postalCode;
        this.m_state = builder.m_state;
        this.m_stateCode = builder.m_stateCode;
    }

    @Override
    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public String getAddressLine1() {
        return this.m_addressLine1;
    }

    public String getAddressLine2() {
        return this.m_addressLine2;
    }

    public String getAddressLine3() {
        return this.m_addressLine3;
    }

    public String getCity() {
        return this.m_city;
    }

    public String getCountry() {
        return this.m_country;
    }

    public String getCountryCode() {
        return this.m_countryCode;
    }

    public Double getLatitude() {
        return this.m_latitude;
    }

    public Double getLongitude() {
        return this.m_longitude;
    }

    public String getMunicipality() {
        return this.m_municipality;
    }

    public String getName() {
        return this.m_name;
    }

    public String getPostalCode() {
        return this.m_postalCode;
    }

    public String getState() {
        return this.m_state;
    }

    public String getStateCode() {
        return this.m_stateCode;
    }

    public static class Builder {
        private final UniqueIdObjectSequenceProvider m_sequenceProvider;
        private String m_addressLine1;
        private String m_addressLine2;
        private String m_addressLine3;
        private String m_city;
        private String m_country;
        private String m_countryCode;
        private Double m_latitude;
        private Double m_longitude;
        private String m_municipality;
        private String m_name;
        private Integer m_uniqueID;
        private String m_postalCode;
        private String m_state;
        private String m_stateCode;

        public Builder(UniqueIdObjectSequenceProvider sequenceProvider) {
            this.m_sequenceProvider = sequenceProvider;
        }

        Builder from(Location value) {
            this.m_addressLine1 = value.m_addressLine1;
            this.m_addressLine2 = value.m_addressLine2;
            this.m_addressLine3 = value.m_addressLine3;
            this.m_city = value.m_city;
            this.m_country = value.m_country;
            this.m_countryCode = value.m_countryCode;
            this.m_latitude = value.m_latitude;
            this.m_longitude = value.m_longitude;
            this.m_municipality = value.m_municipality;
            this.m_name = value.m_name;
            this.m_uniqueID = value.m_uniqueID;
            this.m_postalCode = value.m_postalCode;
            this.m_state = value.m_state;
            this.m_stateCode = value.m_stateCode;
            return this;
        }

        public Builder addressLine1(String value) {
            this.m_addressLine1 = value;
            return this;
        }

        public Builder addressLine2(String value) {
            this.m_addressLine2 = value;
            return this;
        }

        public Builder addressLine3(String value) {
            this.m_addressLine3 = value;
            return this;
        }

        public Builder city(String value) {
            this.m_city = value;
            return this;
        }

        public Builder country(String value) {
            this.m_country = value;
            return this;
        }

        public Builder countryCode(String value) {
            this.m_countryCode = value;
            return this;
        }

        public Builder latitude(Double value) {
            this.m_latitude = value;
            return this;
        }

        public Builder longitude(Double value) {
            this.m_longitude = value;
            return this;
        }

        public Builder municipality(String value) {
            this.m_municipality = value;
            return this;
        }

        public Builder name(String value) {
            this.m_name = value;
            return this;
        }

        public Builder uniqueID(Integer value) {
            this.m_uniqueID = value;
            return this;
        }

        public Builder postalCode(String value) {
            this.m_postalCode = value;
            return this;
        }

        public Builder state(String value) {
            this.m_state = value;
            return this;
        }

        public Builder stateCode(String value) {
            this.m_stateCode = value;
            return this;
        }

        public Location build() {
            return new Location(this);
        }
    }
}

