/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.time.DayOfWeek;
import java.util.Iterator;
import org.mpxj.DayType;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectEntityContainer;
import org.mpxj.ProjectFile;
import org.mpxj.common.NumberHelper;

public class ProjectCalendarContainer
extends ProjectEntityContainer<ProjectCalendar> {
    private final ProjectFile m_projectFile;

    public ProjectCalendarContainer(ProjectFile projectFile) {
        super(projectFile);
        this.m_projectFile = projectFile;
    }

    @Override
    public void removed(ProjectCalendar calendar) {
        super.removed(calendar);
        calendar.getDerivedCalendars().forEach(c -> c.setParent(null));
        calendar.getResources().forEach(r -> r.setCalendar(null));
        calendar.getTasks().forEach(t -> t.setCalendar(null));
        calendar.setParent(null);
    }

    public ProjectCalendar add() {
        ProjectCalendar calendar = new ProjectCalendar(this.m_projectFile);
        this.add(calendar);
        return calendar;
    }

    public ProjectCalendar addDefaultBaseCalendar() {
        ProjectCalendar calendar = this.add();
        calendar.setName("Standard");
        calendar.addDefaultCalendarDays();
        calendar.addDefaultCalendarHours();
        return calendar;
    }

    public ProjectCalendar addDefaultDerivedCalendar() {
        ProjectCalendar calendar = this.add();
        calendar.setCalendarDayType(DayOfWeek.SUNDAY, DayType.DEFAULT);
        calendar.setCalendarDayType(DayOfWeek.MONDAY, DayType.DEFAULT);
        calendar.setCalendarDayType(DayOfWeek.TUESDAY, DayType.DEFAULT);
        calendar.setCalendarDayType(DayOfWeek.WEDNESDAY, DayType.DEFAULT);
        calendar.setCalendarDayType(DayOfWeek.THURSDAY, DayType.DEFAULT);
        calendar.setCalendarDayType(DayOfWeek.FRIDAY, DayType.DEFAULT);
        calendar.setCalendarDayType(DayOfWeek.SATURDAY, DayType.DEFAULT);
        return calendar;
    }

    public ProjectCalendar findOrCreateDefaultCalendar() {
        ProjectCalendar result = this.getByName("Standard");
        if (result == null) {
            if (!this.isEmpty()) {
                result = (ProjectCalendar)this.get(0);
            } else {
                result = this.addDefaultBaseCalendar();
                if (NumberHelper.getInt(result.getUniqueID()) == 0) {
                    result.setUniqueID(this.m_projectFile.getUniqueIdObjectSequence(ProjectCalendar.class).getNext());
                }
            }
        }
        return result;
    }

    public ProjectCalendar getByName(String calendarName) {
        ProjectCalendar calendar = null;
        if (calendarName != null && !calendarName.isEmpty()) {
            ProjectCalendar projectCalendar;
            String name;
            Iterator iterator = this.iterator();
            while (iterator.hasNext() && ((name = (calendar = (projectCalendar = (ProjectCalendar)iterator.next())).getName()) == null || !name.equalsIgnoreCase(calendarName))) {
                calendar = null;
            }
        }
        return calendar;
    }
}

