/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.mpxj.LocalTimeRange;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.RecurrenceType;
import org.mpxj.RecurringData;
import org.mpxj.common.LocalDateHelper;
import org.mpxj.common.NumberHelper;

public final class ProjectCalendarException
extends ProjectCalendarHours
implements Comparable<ProjectCalendarException> {
    private final LocalDate m_fromDate;
    private final LocalDate m_toDate;
    private final RecurringData m_recurring;
    private String m_name;

    ProjectCalendarException(LocalDate fromDate, LocalDate toDate) {
        this(fromDate, toDate, null);
    }

    ProjectCalendarException(RecurringData recurringData) {
        this(null, null, recurringData);
    }

    ProjectCalendarException(LocalDate fromDate, LocalDate toDate, RecurringData recurringData) {
        this.m_fromDate = fromDate;
        this.m_toDate = toDate;
        this.m_recurring = recurringData;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public LocalDate getFromDate() {
        return this.m_recurring == null ? this.m_fromDate : this.m_recurring.getCalculatedFirstDate();
    }

    public LocalDate getToDate() {
        return this.m_recurring == null ? this.m_toDate : this.m_recurring.getCalculatedLastDate();
    }

    public RecurringData getRecurring() {
        return this.m_recurring;
    }

    public boolean getWorking() {
        return this.size() != 0;
    }

    public List<ProjectCalendarException> getExpandedExceptions() {
        ArrayList<ProjectCalendarException> result = new ArrayList<ProjectCalendarException>();
        if (this.m_recurring == null || this.m_recurring.getRecurrenceType() == RecurrenceType.DAILY && NumberHelper.getInt(this.m_recurring.getFrequency()) == 1) {
            result.add(this);
        } else {
            for (LocalDate date : this.m_recurring.getDates()) {
                ProjectCalendarException newException = new ProjectCalendarException(date, date);
                int rangeCount = this.size();
                for (int rangeIndex = 0; rangeIndex < rangeCount; ++rangeIndex) {
                    newException.add(this.get(rangeIndex));
                }
                result.add(newException);
            }
        }
        return result;
    }

    public boolean contains(LocalDateTime date) {
        boolean result = false;
        if (date != null) {
            result = LocalDateHelper.compare(this.getFromDate(), this.getToDate(), LocalDateHelper.getLocalDate(date)) == 0;
        }
        return result;
    }

    public boolean contains(LocalDate date) {
        boolean result = false;
        if (date != null) {
            result = LocalDateHelper.compare(this.getFromDate(), this.getToDate(), date) == 0;
        }
        return result;
    }

    public boolean contains(ProjectCalendarException exception) {
        return LocalDateHelper.compare(this.getToDate(), exception.getFromDate()) >= 0 && LocalDateHelper.compare(exception.getToDate(), this.getFromDate()) >= 0;
    }

    @Override
    public int compareTo(ProjectCalendarException o) {
        return this.getFromDate().compareTo(o.getFromDate());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ProjectCalendarException");
        if (this.m_name != null && !this.m_name.isEmpty()) {
            sb.append(" name=").append(this.m_name);
        }
        sb.append(" working=").append(this.getWorking());
        if (this.m_recurring == null) {
            sb.append(" fromDate=").append(this.m_fromDate);
            sb.append(" toDate=").append(this.m_toDate);
        } else {
            sb.append(" recurring=").append(this.m_recurring);
        }
        for (LocalTimeRange range : this) {
            sb.append(range.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

