/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.mpxj.DayType;
import org.mpxj.LocalDateRange;
import org.mpxj.ProjectCalendarDays;
import org.mpxj.ProjectCalendarException;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.RecurrenceType;
import org.mpxj.RecurringData;
import org.mpxj.common.LocalDateHelper;

public class ProjectCalendarWeek
extends ProjectCalendarDays
implements Comparable<ProjectCalendarWeek> {
    private LocalDateRange m_dateRange;

    public LocalDateRange getDateRange() {
        return this.m_dateRange;
    }

    public void setDateRange(LocalDateRange range) {
        this.m_dateRange = range;
    }

    public List<ProjectCalendarException> convertToRecurringExceptions(LocalDate earliestStartDate, LocalDate latestFinishDate) {
        LocalDate toDate;
        if (this.m_dateRange == null) {
            throw new UnsupportedOperationException();
        }
        ArrayList<ProjectCalendarException> result = new ArrayList<ProjectCalendarException>();
        LocalDate fromDate = this.m_dateRange.getStart();
        if (LocalDateHelper.compare(earliestStartDate, fromDate) > 0) {
            fromDate = earliestStartDate;
        }
        if (LocalDateHelper.compare(toDate = this.m_dateRange.getEnd(), latestFinishDate) > 0) {
            toDate = latestFinishDate;
        }
        for (DayOfWeek day : DayOfWeek.values()) {
            if (this.getCalendarDayType(day) == DayType.DEFAULT) continue;
            RecurringData recurrence = new RecurringData();
            recurrence.setRecurrenceType(RecurrenceType.WEEKLY);
            recurrence.setStartDate(fromDate);
            recurrence.setFinishDate(toDate);
            recurrence.setUseEndDate(true);
            recurrence.setWeeklyDay(day, true);
            ProjectCalendarException ex = new ProjectCalendarException(recurrence);
            ProjectCalendarHours hours = this.getCalendarHours(day);
            if (hours != null) {
                ex.addAll(hours);
            }
            result.add(ex);
        }
        return result;
    }

    @Override
    public int compareTo(ProjectCalendarWeek o) {
        return this.m_dateRange.getStart().compareTo(o.m_dateRange.getStart());
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.println("[ProjectCalendarWeek");
        pw.println("   name=" + this.getName());
        pw.println("   date_range=" + this.getDateRange());
        for (DayOfWeek day : DayOfWeek.values()) {
            pw.println("   [Day " + day);
            pw.println("      type=" + this.getCalendarDayType(day));
            pw.println("      hours=" + this.getCalendarHours(day));
            pw.println("   ]");
        }
        pw.println("]");
        pw.flush();
        return os.toString();
    }
}

