/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mpxj.ListWithCallbacks;
import org.mpxj.ProjectEntityWithMutableUniqueID;
import org.mpxj.ProjectEntityWithUniqueID;
import org.mpxj.UniqueIdObjectSequenceProvider;
import org.mpxj.common.ObjectSequence;

public abstract class ProjectEntityContainer<T extends ProjectEntityWithUniqueID>
extends ListWithCallbacks<T> {
    protected final UniqueIdObjectSequenceProvider m_sequenceProvider;
    private final Map<Integer, T> m_uniqueIDMap = new HashMap<Integer, T>();
    private final List<ProjectEntityWithMutableUniqueID> m_uniqueIDClashList = new ArrayList<ProjectEntityWithMutableUniqueID>();

    public ProjectEntityContainer(UniqueIdObjectSequenceProvider sequenceProvider) {
        this.m_sequenceProvider = sequenceProvider;
    }

    protected int firstUniqueID() {
        return 1;
    }

    public T getByUniqueID(Integer id) {
        return (T)((ProjectEntityWithUniqueID)this.m_uniqueIDMap.get(id));
    }

    @Override
    protected void added(T element) {
        if (element.getUniqueID() == null) {
            return;
        }
        Integer uniqueID = element.getUniqueID();
        ProjectEntityWithUniqueID currentElement = (ProjectEntityWithUniqueID)this.m_uniqueIDMap.get(uniqueID);
        if (currentElement == element) {
            return;
        }
        if (currentElement instanceof ProjectEntityWithMutableUniqueID) {
            this.m_uniqueIDClashList.add((ProjectEntityWithMutableUniqueID)element);
        }
        this.m_uniqueIDMap.put(element.getUniqueID(), element);
    }

    @Override
    protected void removed(T element) {
        this.m_uniqueIDMap.remove(element.getUniqueID());
    }

    public void updateUniqueID(T element, Integer oldUniqueID, Integer newUniqueID) {
        ProjectEntityWithUniqueID currentElement;
        if (oldUniqueID != null) {
            this.m_uniqueIDMap.remove(oldUniqueID);
        }
        if ((currentElement = (ProjectEntityWithUniqueID)this.m_uniqueIDMap.get(newUniqueID)) == element) {
            return;
        }
        if (currentElement instanceof ProjectEntityWithMutableUniqueID) {
            this.m_uniqueIDClashList.add((ProjectEntityWithMutableUniqueID)element);
        }
        this.m_uniqueIDMap.put(newUniqueID, element);
        this.m_sequenceProvider.getUniqueIdObjectSequence(element.getClass()).sync(newUniqueID);
    }

    public void fixUniqueIdClashes() {
        if (this.m_uniqueIDClashList.isEmpty()) {
            return;
        }
        ObjectSequence sequence = this.m_sequenceProvider.getUniqueIdObjectSequence(this.m_uniqueIDClashList.get(0).getClass());
        this.m_uniqueIDClashList.forEach(i -> i.setUniqueID(sequence.getNext()));
        this.m_uniqueIDClashList.clear();
        this.m_uniqueIDMap.clear();
        this.forEach(i -> this.m_uniqueIDMap.put(i.getUniqueID(), i));
    }
}

