/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.mpxj.AbstractFieldContainer;
import org.mpxj.AccrueType;
import org.mpxj.CodePage;
import org.mpxj.CriticalActivityType;
import org.mpxj.CurrencySymbolPosition;
import org.mpxj.DateOrder;
import org.mpxj.Duration;
import org.mpxj.EarnedValueMethod;
import org.mpxj.FieldType;
import org.mpxj.FileVersion;
import org.mpxj.Location;
import org.mpxj.Notes;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCode;
import org.mpxj.ProjectCodeValue;
import org.mpxj.ProjectDateFormat;
import org.mpxj.ProjectField;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectTimeFormat;
import org.mpxj.Rate;
import org.mpxj.RelationshipLagCalendar;
import org.mpxj.ScheduleFrom;
import org.mpxj.SchedulingProgressedActivities;
import org.mpxj.TaskField;
import org.mpxj.TaskType;
import org.mpxj.TimeUnit;
import org.mpxj.TimeUnitDefaultsContainer;
import org.mpxj.TotalSlackCalculationType;
import org.mpxj.common.BooleanHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.PopulatedFields;
import org.mpxj.common.ProjectFieldLists;

public final class ProjectProperties
extends AbstractFieldContainer<ProjectProperties>
implements TimeUnitDefaultsContainer {
    private static final char DEFAULT_TIME_SEPARATOR = ':';
    private static final char DEFAULT_DATE_SEPARATOR = '/';
    private static final char DEFAULT_THOUSANDS_SEPARATOR = ',';
    private static final char DEFAULT_DECIMAL_SEPARATOR = '.';
    private static final String DEFAULT_CURRENCY_SYMBOL = "$";
    private static final Integer DEFAULT_CURRENCY_DIGITS = 2;
    private static final CurrencySymbolPosition DEFAULT_CURRENCY_SYMBOL_POSITION = CurrencySymbolPosition.BEFORE;
    private static final Double DEFAULT_COST = 0.0;
    private static final char DEFAULT_MPX_DELIMITER = ',';
    private static final Duration DEFAULT_CRITICAL_SLACK_LIMIT = Duration.getInstance(0, TimeUnit.DAYS);
    private static final Integer DEFAULT_BASELINE_FOR_EARNED_VALUE = 0;
    private static final Integer DEFAULT_FISCAL_YEAR_START_MONTH = 1;
    private static final DayOfWeek DEFAULT_WEEK_START_DAY = DayOfWeek.MONDAY;
    private static final Duration DEFAULT_WORK = Duration.getInstance(0, TimeUnit.HOURS);
    private static final Double DEFAULT_WORK2 = 0.0;
    private static final Duration DEFAULT_DURATION = Duration.getInstance(0, TimeUnit.DAYS);
    private static final ScheduleFrom DEFAULT_SCHEDULE_FROM = ScheduleFrom.START;
    private static final Double DEFAULT_PERCENT_COMPLETE = 0.0;
    private static final int DEFAULT_DAYS_PER_WEEK = 5;
    private static final Integer DEFAULT_DAYS_PER_MONTH = 20;
    private static final Integer DEFAULT_MINUTES_PER_DAY = 480;
    private static final Integer DEFAULT_MINUTES_PER_WEEK = 2400;
    private static final Integer DEFAULT_OTHER_PROJECT_ASSIGNMENT_PRIORITY = 5;
    private static final Duration DEFAULT_MINIMUM_FLOAT = Duration.getInstance(1, TimeUnit.HOURS);
    private static final Double DEFAULT_OVERALLOCATION = 25.0;
    private static final Integer DEFAULT_FLOAT_PATHS = 10;
    private static final Map<FieldType, Function<ProjectProperties, Object>> CALCULATED_FIELD_MAP = new HashMap<FieldType, Function<ProjectProperties, Object>>();

    ProjectProperties(ProjectFile file) {
        super(file);
        this.setMpxDelimiter(',');
        this.setMpxProgramName("Microsoft Project for Windows");
        this.setMpxFileVersion(FileVersion.VERSION_4_0);
        this.setMpxCodePage(CodePage.ANSI);
        this.setCurrencySymbol(DEFAULT_CURRENCY_SYMBOL);
        this.setSymbolPosition(DEFAULT_CURRENCY_SYMBOL_POSITION);
        this.setCurrencyDigits(DEFAULT_CURRENCY_DIGITS);
        this.setThousandsSeparator(',');
        this.setDecimalSeparator('.');
        this.setDateOrder(DateOrder.DMY);
        this.setTimeFormat(ProjectTimeFormat.TWELVE_HOUR);
        this.setDefaultStartTime(LocalTime.of(8, 0));
        this.setDateSeparator('/');
        this.setTimeSeparator(':');
        this.setAMText("am");
        this.setPMText("pm");
        this.setDateFormat(ProjectDateFormat.DD_MM_YYYY);
        this.setBarTextDateFormat(ProjectDateFormat.DD_MM_YYYY);
        this.setDefaultDurationUnits(TimeUnit.DAYS);
        this.setDefaultDurationIsFixed(false);
        this.setDefaultWorkUnits(TimeUnit.HOURS);
        this.setMinutesPerDay(DEFAULT_MINUTES_PER_DAY);
        this.setMinutesPerWeek(DEFAULT_MINUTES_PER_WEEK);
        this.setDefaultStandardRate(new Rate(10.0, TimeUnit.HOURS));
        this.setDefaultOvertimeRate(new Rate(15.0, TimeUnit.HOURS));
        this.setUpdatingTaskStatusUpdatesResourceStatus(true);
        this.setSplitInProgressTasks(false);
        this.setProjectTitle("Project1");
        this.setCompany(null);
        this.setManager(null);
        this.setStartDate(null);
        this.setFinishDate(null);
        this.setScheduleFrom(DEFAULT_SCHEDULE_FROM);
        this.setCurrentDate(LocalDateTime.now());
        this.setComments(null);
        this.setCost(DEFAULT_COST);
        this.setBaselineCost(DEFAULT_COST);
        this.setActualCost(DEFAULT_COST);
        this.setWork(DEFAULT_WORK);
        this.setBaselineWork(DEFAULT_WORK);
        this.setActualWork(DEFAULT_WORK);
        this.setWork2(DEFAULT_WORK2);
        this.setDuration(DEFAULT_DURATION);
        this.setBaselineDuration(DEFAULT_DURATION);
        this.setActualDuration(DEFAULT_DURATION);
        this.setPercentageComplete(DEFAULT_PERCENT_COMPLETE);
        this.setBaselineStart(null);
        this.setBaselineFinish(null);
        this.setActualStart(null);
        this.setActualFinish(null);
        this.setStartVariance(DEFAULT_DURATION);
        this.setFinishVariance(DEFAULT_DURATION);
        this.setSubject(null);
        this.setAuthor(null);
        this.setKeywords(null);
        this.setProjectExternallyEdited(false);
        this.setMinutesPerDay(DEFAULT_MINUTES_PER_DAY);
        this.setDaysPerMonth(DEFAULT_DAYS_PER_MONTH);
        this.setMinutesPerWeek(DEFAULT_MINUTES_PER_WEEK);
        this.setFiscalYearStart(false);
        this.setDefaultTaskEarnedValueMethod(EarnedValueMethod.PERCENT_COMPLETE);
        this.setNewTasksEstimated(true);
        this.setAutoAddNewResourcesAndTasks(true);
        this.setAutolink(true);
        this.setMicrosoftProjectServerURL(true);
        this.setDefaultTaskType(TaskType.FIXED_UNITS);
        this.setDefaultFixedCostAccrual(AccrueType.END);
        this.setCriticalSlackLimit(DEFAULT_CRITICAL_SLACK_LIMIT);
        this.setBaselineForEarnedValue(DEFAULT_BASELINE_FOR_EARNED_VALUE);
        this.setFiscalYearStartMonth(DEFAULT_FISCAL_YEAR_START_MONTH);
        this.setNewTaskStartIsProjectStart(true);
        this.setNewTasksAreManual(true);
        this.setWeekStartDay(DEFAULT_WEEK_START_DAY);
        this.setCriticalActivityType(CriticalActivityType.TOTAL_FLOAT);
        this.setTotalSlackCalculationType(TotalSlackCalculationType.SMALLEST_SLACK);
        this.setRelationshipLagCalendar(RelationshipLagCalendar.PREDECESSOR);
    }

    public TimeUnit getDefaultDurationUnits() {
        return (TimeUnit)this.get(ProjectField.DEFAULT_DURATION_UNITS);
    }

    public void setDefaultDurationUnits(TimeUnit units) {
        this.set((FieldType)ProjectField.DEFAULT_DURATION_UNITS, units);
    }

    public boolean getDefaultDurationIsFixed() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.DEFAULT_DURATION_IS_FIXED));
    }

    public void setDefaultDurationIsFixed(boolean fixed) {
        this.set((FieldType)ProjectField.DEFAULT_DURATION_IS_FIXED, fixed);
    }

    public TimeUnit getDefaultWorkUnits() {
        return (TimeUnit)this.get(ProjectField.DEFAULT_WORK_UNITS);
    }

    public void setDefaultWorkUnits(TimeUnit units) {
        this.set((FieldType)ProjectField.DEFAULT_WORK_UNITS, units);
    }

    public Rate getDefaultStandardRate() {
        return (Rate)this.get(ProjectField.DEFAULT_STANDARD_RATE);
    }

    public void setDefaultStandardRate(Rate rate) {
        this.set((FieldType)ProjectField.DEFAULT_STANDARD_RATE, rate);
    }

    public Rate getDefaultOvertimeRate() {
        return (Rate)this.get(ProjectField.DEFAULT_OVERTIME_RATE);
    }

    public void setDefaultOvertimeRate(Rate rate) {
        this.set((FieldType)ProjectField.DEFAULT_OVERTIME_RATE, rate);
    }

    public boolean getUpdatingTaskStatusUpdatesResourceStatus() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.UPDATING_TASK_STATUS_UPDATES_RESOURCE_STATUS));
    }

    public void setUpdatingTaskStatusUpdatesResourceStatus(boolean flag) {
        this.set((FieldType)ProjectField.UPDATING_TASK_STATUS_UPDATES_RESOURCE_STATUS, flag);
    }

    public boolean getSplitInProgressTasks() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.SPLIT_IN_PROGRESS_TASKS));
    }

    public void setSplitInProgressTasks(boolean flag) {
        this.set((FieldType)ProjectField.SPLIT_IN_PROGRESS_TASKS, flag);
    }

    public DateOrder getDateOrder() {
        return (DateOrder)this.get(ProjectField.DATE_ORDER);
    }

    public void setDateOrder(DateOrder dateOrder) {
        this.set((FieldType)ProjectField.DATE_ORDER, dateOrder);
    }

    public ProjectTimeFormat getTimeFormat() {
        return (ProjectTimeFormat)this.get(ProjectField.TIME_FORMAT);
    }

    public void setTimeFormat(ProjectTimeFormat timeFormat) {
        this.set((FieldType)ProjectField.TIME_FORMAT, timeFormat);
    }

    public LocalTime getDefaultStartTime() {
        return (LocalTime)this.get(ProjectField.DEFAULT_START_TIME);
    }

    public void setDefaultStartTime(LocalTime defaultStartTime) {
        this.set((FieldType)ProjectField.DEFAULT_START_TIME, defaultStartTime);
    }

    public char getDateSeparator() {
        return ((Character)this.get(ProjectField.DATE_SEPARATOR)).charValue();
    }

    public void setDateSeparator(char dateSeparator) {
        this.set((FieldType)ProjectField.DATE_SEPARATOR, Character.valueOf(dateSeparator));
    }

    public char getTimeSeparator() {
        return ((Character)this.get(ProjectField.TIME_SEPARATOR)).charValue();
    }

    public void setTimeSeparator(char timeSeparator) {
        this.set((FieldType)ProjectField.TIME_SEPARATOR, Character.valueOf(timeSeparator));
    }

    public String getAMText() {
        return (String)this.get(ProjectField.AM_TEXT);
    }

    public void setAMText(String amText) {
        this.set((FieldType)ProjectField.AM_TEXT, amText);
    }

    public String getPMText() {
        return (String)this.get(ProjectField.PM_TEXT);
    }

    public void setPMText(String pmText) {
        this.set((FieldType)ProjectField.PM_TEXT, pmText);
    }

    public ProjectDateFormat getDateFormat() {
        return (ProjectDateFormat)this.get(ProjectField.DATE_FORMAT);
    }

    public void setDateFormat(ProjectDateFormat dateFormat) {
        this.set((FieldType)ProjectField.DATE_FORMAT, dateFormat);
    }

    public ProjectDateFormat getBarTextDateFormat() {
        return (ProjectDateFormat)this.get(ProjectField.BAR_TEXT_DATE_FORMAT);
    }

    public void setBarTextDateFormat(ProjectDateFormat dateFormat) {
        this.set((FieldType)ProjectField.BAR_TEXT_DATE_FORMAT, dateFormat);
    }

    public LocalTime getDefaultEndTime() {
        return (LocalTime)this.get(ProjectField.DEFAULT_END_TIME);
    }

    public void setDefaultEndTime(LocalTime date) {
        this.set((FieldType)ProjectField.DEFAULT_END_TIME, date);
    }

    public void setProjectTitle(String projectTitle) {
        this.set((FieldType)ProjectField.PROJECT_TITLE, projectTitle);
    }

    public String getProjectTitle() {
        return (String)this.get(ProjectField.PROJECT_TITLE);
    }

    public void setCompany(String company) {
        this.set((FieldType)ProjectField.COMPANY, company);
    }

    public String getCompany() {
        return (String)this.get(ProjectField.COMPANY);
    }

    public void setManager(String manager) {
        this.set((FieldType)ProjectField.MANAGER, manager);
    }

    public String getManager() {
        return (String)this.get(ProjectField.MANAGER);
    }

    public void setDefaultCalendarUniqueID(Integer id) {
        this.set((FieldType)ProjectField.DEFAULT_CALENDAR_UNIQUE_ID, id);
    }

    public Integer getDefaultCalendarUniqueID() {
        return (Integer)this.get(ProjectField.DEFAULT_CALENDAR_UNIQUE_ID);
    }

    public void setDefaultCalendar(ProjectCalendar calendar) {
        this.set((FieldType)ProjectField.DEFAULT_CALENDAR_UNIQUE_ID, calendar.getUniqueID());
    }

    public ProjectCalendar getDefaultCalendar() {
        return (ProjectCalendar)this.getParentFile().getCalendars().getByUniqueID((Integer)this.get(ProjectField.DEFAULT_CALENDAR_UNIQUE_ID));
    }

    public void setStartDate(LocalDateTime startDate) {
        this.set((FieldType)ProjectField.START_DATE, startDate);
    }

    public LocalDateTime getStartDate() {
        return (LocalDateTime)this.get(ProjectField.START_DATE);
    }

    public LocalDateTime getFinishDate() {
        return (LocalDateTime)this.get(ProjectField.FINISH_DATE);
    }

    public void setFinishDate(LocalDateTime finishDate) {
        this.set((FieldType)ProjectField.FINISH_DATE, finishDate);
    }

    public ScheduleFrom getScheduleFrom() {
        return (ScheduleFrom)this.get(ProjectField.SCHEDULE_FROM);
    }

    public void setScheduleFrom(ScheduleFrom scheduleFrom) {
        this.set((FieldType)ProjectField.SCHEDULE_FROM, scheduleFrom);
    }

    public LocalDateTime getCurrentDate() {
        return (LocalDateTime)this.get(ProjectField.CURRENT_DATE);
    }

    public void setCurrentDate(LocalDateTime currentDate) {
        this.set((FieldType)ProjectField.CURRENT_DATE, currentDate);
    }

    public String getComments() {
        return (String)this.get(ProjectField.COMMENTS);
    }

    public void setComments(String comments) {
        this.set((FieldType)ProjectField.COMMENTS, comments);
    }

    public Number getCost() {
        return (Number)this.get(ProjectField.COST);
    }

    public void setCost(Number cost) {
        this.set((FieldType)ProjectField.COST, cost);
    }

    public void setBaselineCost(Number baselineCost) {
        this.set((FieldType)ProjectField.BASELINE_COST, baselineCost);
    }

    public Number getBaselineCost() {
        return (Number)this.get(ProjectField.BASELINE_COST);
    }

    public void setActualCost(Number actualCost) {
        this.set((FieldType)ProjectField.ACTUAL_COST, actualCost);
    }

    public Number getActualCost() {
        return (Number)this.get(ProjectField.ACTUAL_COST);
    }

    public void setWork(Duration work) {
        this.set((FieldType)ProjectField.WORK, work);
    }

    public Duration getWork() {
        return (Duration)this.get(ProjectField.WORK);
    }

    public void setBaselineWork(Duration baselineWork) {
        this.set((FieldType)ProjectField.BASELINE_WORK, baselineWork);
    }

    public Duration getBaselineWork() {
        return (Duration)this.get(ProjectField.BASELINE_WORK);
    }

    public void setActualWork(Duration actualWork) {
        this.set((FieldType)ProjectField.ACTUAL_WORK, actualWork);
    }

    public Duration getActualWork() {
        return (Duration)this.get(ProjectField.ACTUAL_WORK);
    }

    public Number getWork2() {
        return (Number)this.get(ProjectField.WORK2);
    }

    public void setWork2(Number work2) {
        this.set((FieldType)ProjectField.WORK2, work2);
    }

    public Duration getDuration() {
        return (Duration)this.get(ProjectField.DURATION);
    }

    public void setDuration(Duration duration) {
        this.set((FieldType)ProjectField.DURATION, duration);
    }

    public Duration getBaselineDuration() {
        return (Duration)this.get(ProjectField.BASELINE_DURATION);
    }

    public void setBaselineDuration(Duration baselineDuration) {
        this.set((FieldType)ProjectField.BASELINE_DURATION, baselineDuration);
    }

    public Duration getActualDuration() {
        return (Duration)this.get(ProjectField.ACTUAL_DURATION);
    }

    public void setActualDuration(Duration actualDuration) {
        this.set((FieldType)ProjectField.ACTUAL_DURATION, actualDuration);
    }

    public Number getPercentageComplete() {
        return (Number)this.get(ProjectField.PERCENTAGE_COMPLETE);
    }

    public void setPercentageComplete(Number percentComplete) {
        this.set((FieldType)ProjectField.PERCENTAGE_COMPLETE, percentComplete);
    }

    public void setBaselineStart(LocalDateTime baselineStartDate) {
        this.set((FieldType)ProjectField.BASELINE_START, baselineStartDate);
    }

    public LocalDateTime getBaselineStart() {
        return (LocalDateTime)this.get(ProjectField.BASELINE_START);
    }

    public void setBaselineFinish(LocalDateTime baselineFinishDate) {
        this.set((FieldType)ProjectField.BASELINE_FINISH, baselineFinishDate);
    }

    public LocalDateTime getBaselineFinish() {
        return (LocalDateTime)this.get(ProjectField.BASELINE_FINISH);
    }

    public void setActualStart(LocalDateTime actualStartDate) {
        this.set((FieldType)ProjectField.ACTUAL_START, actualStartDate);
    }

    public LocalDateTime getActualStart() {
        return (LocalDateTime)this.get(ProjectField.ACTUAL_START);
    }

    public void setActualFinish(LocalDateTime actualFinishDate) {
        this.set((FieldType)ProjectField.ACTUAL_FINISH, actualFinishDate);
    }

    public LocalDateTime getActualFinish() {
        return (LocalDateTime)this.get(ProjectField.ACTUAL_FINISH);
    }

    public Duration getStartVariance() {
        return (Duration)this.get(ProjectField.START_VARIANCE);
    }

    public void setStartVariance(Duration startVariance) {
        this.set((FieldType)ProjectField.START_VARIANCE, startVariance);
    }

    public Duration getFinishVariance() {
        return (Duration)this.get(ProjectField.FINISH_VARIANCE);
    }

    public void setFinishVariance(Duration finishVariance) {
        this.set((FieldType)ProjectField.FINISH_VARIANCE, finishVariance);
    }

    public String getSubject() {
        return (String)this.get(ProjectField.SUBJECT);
    }

    public void setSubject(String subject) {
        this.set((FieldType)ProjectField.SUBJECT, subject);
    }

    public String getAuthor() {
        return (String)this.get(ProjectField.AUTHOR);
    }

    public void setAuthor(String author) {
        this.set((FieldType)ProjectField.AUTHOR, author);
    }

    public String getKeywords() {
        return (String)this.get(ProjectField.KEYWORDS);
    }

    public void setKeywords(String keywords) {
        this.set((FieldType)ProjectField.KEYWORDS, keywords);
    }

    public void setCurrencySymbol(String symbol) {
        if (symbol == null) {
            symbol = DEFAULT_CURRENCY_SYMBOL;
        }
        this.set((FieldType)ProjectField.CURRENCY_SYMBOL, symbol);
    }

    public String getCurrencySymbol() {
        return (String)this.get(ProjectField.CURRENCY_SYMBOL);
    }

    public void setSymbolPosition(CurrencySymbolPosition value) {
        if (value == null) {
            value = DEFAULT_CURRENCY_SYMBOL_POSITION;
        }
        this.set((FieldType)ProjectField.CURRENCY_SYMBOL_POSITION, value);
    }

    public CurrencySymbolPosition getSymbolPosition() {
        return (CurrencySymbolPosition)this.get(ProjectField.CURRENCY_SYMBOL_POSITION);
    }

    public void setCurrencyDigits(Integer currDigs) {
        if (currDigs == null) {
            currDigs = DEFAULT_CURRENCY_DIGITS;
        }
        this.set((FieldType)ProjectField.CURRENCY_DIGITS, currDigs);
    }

    public Integer getCurrencyDigits() {
        return (Integer)this.get(ProjectField.CURRENCY_DIGITS);
    }

    public void setThousandsSeparator(char sep) {
        this.set((FieldType)ProjectField.THOUSANDS_SEPARATOR, Character.valueOf(sep));
    }

    public char getThousandsSeparator() {
        return ((Character)this.get(ProjectField.THOUSANDS_SEPARATOR)).charValue();
    }

    public void setDecimalSeparator(char decSep) {
        this.set((FieldType)ProjectField.DECIMAL_SEPARATOR, Character.valueOf(decSep));
    }

    public char getDecimalSeparator() {
        return ((Character)this.get(ProjectField.DECIMAL_SEPARATOR)).charValue();
    }

    public boolean getProjectExternallyEdited() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.PROJECT_EXTERNALLY_EDITED));
    }

    public void setProjectExternallyEdited(boolean projectExternallyEdited) {
        this.set((FieldType)ProjectField.PROJECT_EXTERNALLY_EDITED, projectExternallyEdited);
    }

    public String getCategory() {
        return (String)this.get(ProjectField.CATEGORY);
    }

    public void setCategory(String category) {
        this.set((FieldType)ProjectField.CATEGORY, category);
    }

    @Override
    public Integer getDaysPerMonth() {
        return (Integer)this.get(ProjectField.DAYS_PER_MONTH);
    }

    public void setDaysPerMonth(Integer daysPerMonth) {
        this.set((FieldType)ProjectField.DAYS_PER_MONTH, daysPerMonth);
    }

    @Override
    public Integer getMinutesPerDay() {
        return (Integer)this.get(ProjectField.MINUTES_PER_DAY);
    }

    public void setMinutesPerDay(Integer minutesPerDay) {
        this.set((FieldType)ProjectField.MINUTES_PER_DAY, minutesPerDay);
    }

    @Override
    public Integer getMinutesPerWeek() {
        return (Integer)this.get(ProjectField.MINUTES_PER_WEEK);
    }

    public void setMinutesPerWeek(Integer minutesPerWeek) {
        this.set((FieldType)ProjectField.MINUTES_PER_WEEK, minutesPerWeek);
    }

    @Override
    public Integer getMinutesPerMonth() {
        return (Integer)this.get(ProjectField.MINUTES_PER_MONTH);
    }

    public void setMinutesPerMonth(Integer minutesPerMonth) {
        this.set((FieldType)ProjectField.MINUTES_PER_MONTH, minutesPerMonth);
    }

    @Override
    public Integer getMinutesPerYear() {
        return (Integer)this.get(ProjectField.MINUTES_PER_YEAR);
    }

    public void setMinutesPerYear(Integer minutesPerYear) {
        this.set((FieldType)ProjectField.MINUTES_PER_YEAR, minutesPerYear);
    }

    public boolean getFiscalYearStart() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.FISCAL_YEAR_START));
    }

    public void setFiscalYearStart(boolean fiscalYearStart) {
        this.set((FieldType)ProjectField.FISCAL_YEAR_START, fiscalYearStart);
    }

    public EarnedValueMethod getDefaultTaskEarnedValueMethod() {
        return (EarnedValueMethod)this.get(ProjectField.DEFAULT_TASK_EARNED_VALUE_METHOD);
    }

    public void setDefaultTaskEarnedValueMethod(EarnedValueMethod defaultTaskEarnedValueMethod) {
        this.set((FieldType)ProjectField.DEFAULT_TASK_EARNED_VALUE_METHOD, defaultTaskEarnedValueMethod);
    }

    public boolean getRemoveFileProperties() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.REMOVE_FILE_PROPERTIES));
    }

    public void setRemoveFileProperties(boolean removeFileProperties) {
        this.set((FieldType)ProjectField.REMOVE_FILE_PROPERTIES, removeFileProperties);
    }

    public boolean getMoveCompletedEndsBack() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.MOVE_COMPLETED_ENDS_BACK));
    }

    public void setMoveCompletedEndsBack(boolean moveCompletedEndsBack) {
        this.set((FieldType)ProjectField.MOVE_COMPLETED_ENDS_BACK, moveCompletedEndsBack);
    }

    public boolean getNewTasksEstimated() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.NEW_TASKS_ESTIMATED));
    }

    public void setNewTasksEstimated(boolean newTasksEstimated) {
        this.set((FieldType)ProjectField.NEW_TASKS_ESTIMATED, newTasksEstimated);
    }

    public boolean getSpreadActualCost() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.SPREAD_ACTUAL_COST));
    }

    public void setSpreadActualCost(boolean spreadActualCost) {
        this.set((FieldType)ProjectField.SPREAD_ACTUAL_COST, spreadActualCost);
    }

    public boolean getMultipleCriticalPaths() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.MULTIPLE_CRITICAL_PATHS));
    }

    public void setMultipleCriticalPaths(boolean multipleCriticalPaths) {
        this.set((FieldType)ProjectField.MULTIPLE_CRITICAL_PATHS, multipleCriticalPaths);
    }

    public boolean getAutoAddNewResourcesAndTasks() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.AUTO_ADD_NEW_RESOURCES_AND_TASKS));
    }

    public void setAutoAddNewResourcesAndTasks(boolean autoAddNewResourcesAndTasks) {
        this.set((FieldType)ProjectField.AUTO_ADD_NEW_RESOURCES_AND_TASKS, autoAddNewResourcesAndTasks);
    }

    public LocalDateTime getLastSaved() {
        return (LocalDateTime)this.get(ProjectField.LAST_SAVED);
    }

    public void setLastSaved(LocalDateTime lastSaved) {
        this.set((FieldType)ProjectField.LAST_SAVED, lastSaved);
    }

    public LocalDateTime getStatusDate() {
        return (LocalDateTime)this.get(ProjectField.STATUS_DATE);
    }

    public void setStatusDate(LocalDateTime statusDate) {
        this.set((FieldType)ProjectField.STATUS_DATE, statusDate);
    }

    public boolean getMoveRemainingStartsBack() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.MOVE_REMAINING_STARTS_BACK));
    }

    public void setMoveRemainingStartsBack(boolean moveRemainingStartsBack) {
        this.set((FieldType)ProjectField.MOVE_REMAINING_STARTS_BACK, moveRemainingStartsBack);
    }

    public boolean getAutolink() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.AUTO_LINK));
    }

    public void setAutolink(boolean autolink) {
        this.set((FieldType)ProjectField.AUTO_LINK, autolink);
    }

    public boolean getMicrosoftProjectServerURL() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.MICROSOFT_PROJECT_SERVER_URL));
    }

    public void setMicrosoftProjectServerURL(boolean microsoftProjectServerURL) {
        this.set((FieldType)ProjectField.MICROSOFT_PROJECT_SERVER_URL, microsoftProjectServerURL);
    }

    public boolean getHonorConstraints() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.HONOR_CONSTRAINTS));
    }

    public void setHonorConstraints(boolean honorConstraints) {
        this.set((FieldType)ProjectField.HONOR_CONSTRAINTS, honorConstraints);
    }

    public boolean getAdminProject() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.ADMIN_PROJECT));
    }

    public void setAdminProject(boolean adminProject) {
        this.set((FieldType)ProjectField.ADMIN_PROJECT, adminProject);
    }

    public boolean getInsertedProjectsLikeSummary() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.INSERTED_PROJECTS_LIKE_SUMMARY));
    }

    public void setInsertedProjectsLikeSummary(boolean insertedProjectsLikeSummary) {
        this.set((FieldType)ProjectField.INSERTED_PROJECTS_LIKE_SUMMARY, insertedProjectsLikeSummary);
    }

    public String getName() {
        return (String)this.get(ProjectField.NAME);
    }

    public void setName(String name) {
        this.set((FieldType)ProjectField.NAME, name);
    }

    public boolean getSpreadPercentComplete() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.SPREAD_PERCENT_COMPLETE));
    }

    public void setSpreadPercentComplete(boolean spreadPercentComplete) {
        this.set((FieldType)ProjectField.SPREAD_PERCENT_COMPLETE, spreadPercentComplete);
    }

    public boolean getMoveCompletedEndsForward() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.MOVE_COMPLETED_ENDS_FORWARD));
    }

    public void setMoveCompletedEndsForward(boolean moveCompletedEndsForward) {
        this.set((FieldType)ProjectField.MOVE_COMPLETED_ENDS_FORWARD, moveCompletedEndsForward);
    }

    public boolean getEditableActualCosts() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.EDITABLE_ACTUAL_COSTS));
    }

    public void setEditableActualCosts(boolean editableActualCosts) {
        this.set((FieldType)ProjectField.EDITABLE_ACTUAL_COSTS, editableActualCosts);
    }

    public Integer getUniqueID() {
        return (Integer)this.get(ProjectField.UNIQUE_ID);
    }

    public void setUniqueID(Integer uniqueID) {
        this.set((FieldType)ProjectField.UNIQUE_ID, uniqueID);
    }

    public UUID getGUID() {
        return (UUID)this.get(ProjectField.GUID);
    }

    public void setGUID(UUID guid) {
        this.set((FieldType)ProjectField.GUID, guid);
    }

    public Integer getRevision() {
        return (Integer)this.get(ProjectField.REVISION);
    }

    public boolean getNewTasksEffortDriven() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.NEW_TASKS_EFFORT_DRIVEN));
    }

    public void setNewTasksEffortDriven(boolean newTasksEffortDriven) {
        this.set((FieldType)ProjectField.NEW_TASKS_EFFORT_DRIVEN, newTasksEffortDriven);
    }

    public void setRevision(Integer revision) {
        this.set((FieldType)ProjectField.REVISION, revision);
    }

    public boolean getMoveRemainingStartsForward() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.MOVE_REMAINING_STARTS_FORWARD));
    }

    public void setMoveRemainingStartsForward(boolean moveRemainingStartsForward) {
        this.set((FieldType)ProjectField.MOVE_REMAINING_STARTS_FORWARD, moveRemainingStartsForward);
    }

    public boolean getActualsInSync() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.ACTUALS_IN_SYNC));
    }

    public void setActualsInSync(boolean actualsInSync) {
        this.set((FieldType)ProjectField.ACTUALS_IN_SYNC, actualsInSync);
    }

    public TaskType getDefaultTaskType() {
        return (TaskType)((Object)this.get(ProjectField.DEFAULT_TASK_TYPE));
    }

    public void setDefaultTaskType(TaskType defaultTaskType) {
        this.set((FieldType)ProjectField.DEFAULT_TASK_TYPE, (Object)defaultTaskType);
    }

    public EarnedValueMethod getEarnedValueMethod() {
        return (EarnedValueMethod)this.get(ProjectField.EARNED_VALUE_METHOD);
    }

    public void setEarnedValueMethod(EarnedValueMethod earnedValueMethod) {
        this.set((FieldType)ProjectField.EARNED_VALUE_METHOD, earnedValueMethod);
    }

    public LocalDateTime getCreationDate() {
        return (LocalDateTime)this.get(ProjectField.CREATION_DATE);
    }

    public void setCreationDate(LocalDateTime creationDate) {
        this.set((FieldType)ProjectField.CREATION_DATE, creationDate);
    }

    public LocalDateTime getExtendedCreationDate() {
        return (LocalDateTime)this.get(ProjectField.EXTENDED_CREATION_DATE);
    }

    public AccrueType getDefaultFixedCostAccrual() {
        return (AccrueType)this.get(ProjectField.DEFAULT_FIXED_COST_ACCRUAL);
    }

    public void setDefaultFixedCostAccrual(AccrueType defaultFixedCostAccrual) {
        this.set((FieldType)ProjectField.DEFAULT_FIXED_COST_ACCRUAL, defaultFixedCostAccrual);
    }

    public void setExtendedCreationDate(LocalDateTime creationDate) {
        this.set((FieldType)ProjectField.EXTENDED_CREATION_DATE, creationDate);
    }

    public Duration getCriticalSlackLimit() {
        return (Duration)this.get(ProjectField.CRITICAL_SLACK_LIMIT);
    }

    public void setCriticalSlackLimit(Duration criticalSlackLimit) {
        this.set((FieldType)ProjectField.CRITICAL_SLACK_LIMIT, criticalSlackLimit);
    }

    public Integer getBaselineForEarnedValue() {
        return (Integer)this.get(ProjectField.BASELINE_FOR_EARNED_VALUE);
    }

    public void setBaselineForEarnedValue(Integer baselineForEarnedValue) {
        this.set((FieldType)ProjectField.BASELINE_FOR_EARNED_VALUE, baselineForEarnedValue);
    }

    public Integer getFiscalYearStartMonth() {
        return (Integer)this.get(ProjectField.FISCAL_YEAR_START_MONTH);
    }

    public void setFiscalYearStartMonth(Integer fiscalYearStartMonth) {
        this.set((FieldType)ProjectField.FISCAL_YEAR_START_MONTH, fiscalYearStartMonth);
    }

    public boolean getNewTaskStartIsProjectStart() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.NEW_TASK_START_IS_PROJECT_START));
    }

    public void setNewTaskStartIsProjectStart(boolean newTaskStartIsProjectStart) {
        this.set((FieldType)ProjectField.NEW_TASK_START_IS_PROJECT_START, newTaskStartIsProjectStart);
    }

    public boolean getNewTasksAreManual() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.NEW_TASKS_ARE_MANUAL));
    }

    public void setNewTasksAreManual(boolean newTasksAreManual) {
        this.set((FieldType)ProjectField.NEW_TASKS_ARE_MANUAL, newTasksAreManual);
    }

    public DayOfWeek getWeekStartDay() {
        return (DayOfWeek)this.get(ProjectField.WEEK_START_DAY);
    }

    public void setWeekStartDay(DayOfWeek weekStartDay) {
        this.set((FieldType)ProjectField.WEEK_START_DAY, weekStartDay);
    }

    public String getCurrencyCode() {
        return (String)this.get(ProjectField.CURRENCY_CODE);
    }

    public void setCurrencyCode(String currencyCode) {
        this.set((FieldType)ProjectField.CURRENCY_CODE, currencyCode);
    }

    public void setCustomProperties(Map<String, Object> customProperties) {
        this.set((FieldType)ProjectField.CUSTOM_PROPERTIES, customProperties);
    }

    public Map<String, Object> getCustomProperties() {
        return (Map)this.get(ProjectField.CUSTOM_PROPERTIES);
    }

    public void setHyperlinkBase(String hyperlinkBase) {
        this.set((FieldType)ProjectField.HYPERLINK_BASE, hyperlinkBase);
    }

    public String getHyperlinkBase() {
        return (String)this.get(ProjectField.HYPERLINK_BASE);
    }

    public boolean getShowProjectSummaryTask() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.SHOW_PROJECT_SUMMARY_TASK));
    }

    public void setShowProjectSummaryTask(boolean value) {
        this.set((FieldType)ProjectField.SHOW_PROJECT_SUMMARY_TASK, value);
    }

    public LocalDateTime getBaselineDate() {
        return (LocalDateTime)this.get(ProjectField.BASELINE_DATE);
    }

    public void setBaselineDate(LocalDateTime value) {
        this.set((FieldType)ProjectField.BASELINE_DATE, value);
    }

    public LocalDateTime getBaselineDate(int baselineNumber) {
        return (LocalDateTime)this.get(this.selectField(ProjectFieldLists.BASELINE_DATES, baselineNumber));
    }

    public void setBaselineDate(int baselineNumber, LocalDateTime value) {
        this.set((FieldType)this.selectField(ProjectFieldLists.BASELINE_DATES, baselineNumber), value);
    }

    public String getTemplate() {
        return (String)this.get(ProjectField.TEMPLATE);
    }

    public void setTemplate(String template) {
        this.set((FieldType)ProjectField.TEMPLATE, template);
    }

    public String getLastAuthor() {
        return (String)this.get(ProjectField.LAST_AUTHOR);
    }

    public void setLastAuthor(String projectUser) {
        this.set((FieldType)ProjectField.LAST_AUTHOR, projectUser);
    }

    public LocalDateTime getLastPrinted() {
        return (LocalDateTime)this.get(ProjectField.LASTPRINTED);
    }

    public void setLastPrinted(LocalDateTime lastPrinted) {
        this.set((FieldType)ProjectField.LASTPRINTED, lastPrinted);
    }

    public String getShortApplicationName() {
        return (String)this.get(ProjectField.SHORT_APPLICATION_NAME);
    }

    public void setShortApplicationName(String application) {
        this.set((FieldType)ProjectField.SHORT_APPLICATION_NAME, application);
    }

    public Integer getEditingTime() {
        return (Integer)this.get(ProjectField.EDITING_TIME);
    }

    public void setEditingTime(Integer editingTime) {
        this.set((FieldType)ProjectField.EDITING_TIME, editingTime);
    }

    public String getPresentationFormat() {
        return (String)this.get(ProjectField.PRESENTATION_FORMAT);
    }

    public void setPresentationFormat(String format) {
        this.set((FieldType)ProjectField.PRESENTATION_FORMAT, format);
    }

    public String getContentType() {
        return (String)this.get(ProjectField.CONTENT_TYPE);
    }

    public void setContentType(String contentType) {
        this.set((FieldType)ProjectField.CONTENT_TYPE, contentType);
    }

    public String getContentStatus() {
        return (String)this.get(ProjectField.CONTENT_STATUS);
    }

    public void setContentStatus(String contentStatus) {
        this.set((FieldType)ProjectField.CONTENT_STATUS, contentStatus);
    }

    public String getLanguage() {
        return (String)this.get(ProjectField.LANGUAGE);
    }

    public void setLanguage(String language) {
        this.set((FieldType)ProjectField.LANGUAGE, language);
    }

    public String getDocumentVersion() {
        return (String)this.get(ProjectField.DOCUMENT_VERSION);
    }

    public void setDocumentVersion(String documentVersion) {
        this.set((FieldType)ProjectField.DOCUMENT_VERSION, documentVersion);
    }

    public void setMpxDelimiter(char delimiter) {
        this.set((FieldType)ProjectField.MPX_DELIMITER, Character.valueOf(delimiter));
    }

    public char getMpxDelimiter() {
        return ((Character)this.get(ProjectField.MPX_DELIMITER)).charValue();
    }

    public void setMpxProgramName(String programName) {
        this.set((FieldType)ProjectField.MPX_PROGRAM_NAME, programName);
    }

    public String getMpxProgramName() {
        return (String)this.get(ProjectField.MPX_PROGRAM_NAME);
    }

    public void setMpxFileVersion(FileVersion version) {
        this.set((FieldType)ProjectField.MPX_FILE_VERSION, version);
    }

    public FileVersion getMpxFileVersion() {
        return (FileVersion)this.get(ProjectField.MPX_FILE_VERSION);
    }

    public void setMpxCodePage(CodePage codePage) {
        this.set((FieldType)ProjectField.MPX_CODE_PAGE, (Object)codePage);
    }

    public CodePage getMpxCodePage() {
        return (CodePage)((Object)this.get(ProjectField.MPX_CODE_PAGE));
    }

    public void setProjectFilePath(String projectFilePath) {
        this.set((FieldType)ProjectField.PROJECT_FILE_PATH, projectFilePath);
    }

    public String getProjectFilePath() {
        return (String)this.get(ProjectField.PROJECT_FILE_PATH);
    }

    public String getFullApplicationName() {
        return (String)this.get(ProjectField.FULL_APPLICATION_NAME);
    }

    public void setFullApplicationName(String name) {
        this.set((FieldType)ProjectField.FULL_APPLICATION_NAME, name);
    }

    public Integer getApplicationVersion() {
        return (Integer)this.get(ProjectField.APPLICATION_VERSION);
    }

    public void setApplicationVersion(Integer version) {
        this.set((FieldType)ProjectField.APPLICATION_VERSION, version);
    }

    public Integer getMppFileType() {
        return (Integer)this.get(ProjectField.MPP_FILE_TYPE);
    }

    public void setMppFileType(Integer fileType) {
        this.set((FieldType)ProjectField.MPP_FILE_TYPE, fileType);
    }

    public boolean getAutoFilter() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.AUTOFILTER));
    }

    public void setAutoFilter(boolean autoFilter) {
        this.set((FieldType)ProjectField.AUTOFILTER, autoFilter);
    }

    public String getFileApplication() {
        return (String)this.get(ProjectField.FILE_APPLICATION);
    }

    public void setFileApplication(String type) {
        this.set((FieldType)ProjectField.FILE_APPLICATION, type);
    }

    public String getFileType() {
        return (String)this.get(ProjectField.FILE_TYPE);
    }

    public void setFileType(String type) {
        this.set((FieldType)ProjectField.FILE_TYPE, type);
    }

    public boolean getExportFlag() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.EXPORT_FLAG));
    }

    public void setExportFlag(boolean value) {
        this.set((FieldType)ProjectField.EXPORT_FLAG, value);
    }

    public Integer getBaselineProjectUniqueID() {
        return (Integer)this.get(ProjectField.BASELINE_PROJECT_UNIQUE_ID);
    }

    public void setBaselineProjectUniqueID(Integer uniqueID) {
        this.set((FieldType)ProjectField.BASELINE_PROJECT_UNIQUE_ID, uniqueID);
    }

    public String getProjectID() {
        return (String)this.get(ProjectField.PROJECT_ID);
    }

    public void setProjectID(String id) {
        this.set((FieldType)ProjectField.PROJECT_ID, id);
    }

    public CriticalActivityType getCriticalActivityType() {
        return (CriticalActivityType)((Object)this.get(ProjectField.CRITICAL_ACTIVITY_TYPE));
    }

    public void setCriticalActivityType(CriticalActivityType value) {
        this.set((FieldType)ProjectField.CRITICAL_ACTIVITY_TYPE, (Object)value);
    }

    public void setMustFinishBy(LocalDateTime date) {
        this.set((FieldType)ProjectField.MUST_FINISH_BY, date);
    }

    public LocalDateTime getMustFinishBy() {
        return (LocalDateTime)this.get(ProjectField.MUST_FINISH_BY);
    }

    public void setScheduledFinish(LocalDateTime date) {
        this.set((FieldType)ProjectField.SCHEDULED_FINISH, date);
    }

    public LocalDateTime getScheduledFinish() {
        return (LocalDateTime)this.get(ProjectField.SCHEDULED_FINISH);
    }

    public void setPlannedStart(LocalDateTime date) {
        this.set((FieldType)ProjectField.PLANNED_START, date);
    }

    public LocalDateTime getPlannedStart() {
        return (LocalDateTime)this.get(ProjectField.PLANNED_START);
    }

    public Integer getLocationUniqueID() {
        return (Integer)this.get(ProjectField.LOCATION_UNIQUE_ID);
    }

    public void setLocationUniqueID(Integer uniqueID) {
        this.set((FieldType)ProjectField.LOCATION_UNIQUE_ID, uniqueID);
    }

    public Location getLocation() {
        return (Location)this.getParentFile().getLocations().getByUniqueID(this.getLocationUniqueID());
    }

    public void setLocation(Location location) {
        this.setLocationUniqueID(location == null ? null : location.getUniqueID());
    }

    public String getResourcePoolFile() {
        return (String)this.get(ProjectField.RESOURCE_POOL_FILE);
    }

    public void setResourcePoolFile(String file) {
        this.set((FieldType)ProjectField.RESOURCE_POOL_FILE, file);
    }

    public ProjectFile getResourcePoolObject() {
        return this.getParentFile().readExternalProject(this.getResourcePoolFile());
    }

    public void setTotalSlackCalculationType(TotalSlackCalculationType type) {
        this.set((FieldType)ProjectField.TOTAL_SLACK_CALCULATION_TYPE, (Object)type);
    }

    public TotalSlackCalculationType getTotalSlackCalculationType() {
        return (TotalSlackCalculationType)((Object)this.get(ProjectField.TOTAL_SLACK_CALCULATION_TYPE));
    }

    public void setRelationshipLagCalendar(RelationshipLagCalendar calendar) {
        this.set((FieldType)ProjectField.RELATIONSHIP_LAG_CALENDAR, (Object)calendar);
    }

    public RelationshipLagCalendar getRelationshipLagCalendar() {
        return (RelationshipLagCalendar)((Object)this.get(ProjectField.RELATIONSHIP_LAG_CALENDAR));
    }

    public String getWbsCodeSeparator() {
        return (String)this.get(ProjectField.WBS_CODE_SEPARATOR);
    }

    public void setWbsCodeSeparator(String value) {
        this.set((FieldType)ProjectField.WBS_CODE_SEPARATOR, value);
    }

    public boolean getConsiderAssignmentsInOtherProjects() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.CONSIDER_ASSIGNMENTS_IN_OTHER_PROJECTS));
    }

    public void setConsiderAssignmentsInOtherProjects(boolean value) {
        this.set((FieldType)ProjectField.CONSIDER_ASSIGNMENTS_IN_OTHER_PROJECTS, value);
    }

    public Integer getConsiderAssignmentsInOtherProjectsWithPriorityEqualHigherThan() {
        return (Integer)this.get(ProjectField.CONSIDER_ASSIGNMENTS_IN_OTHER_PROJECTS_WITH_PRIORITY_EQUAL_HIGHER_THAN);
    }

    public void setConsiderAssignmentsInOtherProjectsWithPriorityEqualHigherThan(Integer value) {
        this.set((FieldType)ProjectField.CONSIDER_ASSIGNMENTS_IN_OTHER_PROJECTS_WITH_PRIORITY_EQUAL_HIGHER_THAN, value);
    }

    public boolean getPreserveScheduledEarlyAndLateDates() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.PRESERVE_SCHEDULED_EARLY_AND_LATE_DATES));
    }

    public void setPreserveScheduledEarlyAndLateDates(boolean value) {
        this.set((FieldType)ProjectField.PRESERVE_SCHEDULED_EARLY_AND_LATE_DATES, value);
    }

    public boolean getLevelAllResources() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.LEVEL_ALL_RESOURCES));
    }

    public void setLevelAllResources(boolean value) {
        this.set((FieldType)ProjectField.LEVEL_ALL_RESOURCES, value);
    }

    public boolean getLevelResourcesOnlyWithinActivityTotalFloat() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.LEVEL_RESOURCES_ONLY_WITHIN_ACTIVITY_TOTAL_FLOAT));
    }

    public void setLevelResourcesOnlyWithinActivityTotalFloat(boolean value) {
        this.set((FieldType)ProjectField.LEVEL_RESOURCES_ONLY_WITHIN_ACTIVITY_TOTAL_FLOAT, value);
    }

    public Duration getPreserveMinimumFloatWhenLeveling() {
        return (Duration)this.get(ProjectField.PRESERVE_MINIMUM_FLOAT_WHEN_LEVELING);
    }

    public void setPreserveMinimumFloatWhenLeveling(Duration value) {
        this.set((FieldType)ProjectField.PRESERVE_MINIMUM_FLOAT_WHEN_LEVELING, value);
    }

    public Number getMaxPercentToOverallocateResources() {
        return (Number)this.get(ProjectField.MAX_PERCENT_TO_OVERALLOCATE_RESOURCES);
    }

    public void setMaxPercentToOverallocateResources(Number value) {
        this.set((FieldType)ProjectField.MAX_PERCENT_TO_OVERALLOCATE_RESOURCES, value);
    }

    public String getLevelingPriorities() {
        return (String)this.get(ProjectField.LEVELING_PRIORITIES);
    }

    public void setLevelingPriorities(String value) {
        this.set((FieldType)ProjectField.LEVELING_PRIORITIES, value);
    }

    public boolean getDataDateAndPlannedStartSetToProjectForecastStart() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.DATA_DATE_AND_PLANNED_START_SET_TO_PROJECT_FORECAST_START));
    }

    public void setDataDateAndPlannedStartSetToProjectForecastStart(boolean value) {
        this.set((FieldType)ProjectField.DATA_DATE_AND_PLANNED_START_SET_TO_PROJECT_FORECAST_START, value);
    }

    public boolean getIgnoreRelationshipsToAndFromOtherProjects() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.IGNORE_RELATIONSHIPS_TO_AND_FROM_OTHER_PROJECTS));
    }

    public void setIgnoreRelationshipsToAndFromOtherProjects(boolean value) {
        this.set((FieldType)ProjectField.IGNORE_RELATIONSHIPS_TO_AND_FROM_OTHER_PROJECTS, value);
    }

    public boolean getMakeOpenEndedActivitiesCritical() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.MAKE_OPEN_ENDED_ACTIVITIES_CRITICAL));
    }

    public void setMakeOpenEndedActivitiesCritical(boolean value) {
        this.set((FieldType)ProjectField.MAKE_OPEN_ENDED_ACTIVITIES_CRITICAL, value);
    }

    public boolean getUseExpectedFinishDates() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.USE_EXPECTED_FINISH_DATES));
    }

    public void setUseExpectedFinishDates(boolean value) {
        this.set((FieldType)ProjectField.USE_EXPECTED_FINISH_DATES, value);
    }

    public boolean getComputeStartToStartLagFromEarlyStart() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.COMPUTE_START_TO_START_LAG_FROM_EARLY_START));
    }

    public void setComputeStartToStartLagFromEarlyStart(boolean value) {
        this.set((FieldType)ProjectField.COMPUTE_START_TO_START_LAG_FROM_EARLY_START, value);
    }

    public boolean getCalculateFloatBasedOnFinishDateOfEachProject() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.CALCULATE_FLOAT_BASED_ON_FINISH_DATE_OF_EACH_PROJECT));
    }

    public void setCalculateFloatBasedOnFinishDateOfEachProject(boolean value) {
        this.set((FieldType)ProjectField.CALCULATE_FLOAT_BASED_ON_FINISH_DATE_OF_EACH_PROJECT, value);
    }

    public boolean getCalculateMultipleFloatPaths() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.CALCULATE_MULTIPLE_FLOAT_PATHS));
    }

    public void setCalculateMultipleFloatPaths(boolean value) {
        this.set((FieldType)ProjectField.CALCULATE_MULTIPLE_FLOAT_PATHS, value);
    }

    public boolean getCalculateMultipleFloatPathsUsingTotalFloat() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.CALCULATE_MULTIPLE_FLOAT_PATHS_USING_TOTAL_FLOAT));
    }

    public void setCalculateMultipleFloatPathsUsingTotalFloat(boolean value) {
        this.set((FieldType)ProjectField.CALCULATE_MULTIPLE_FLOAT_PATHS_USING_TOTAL_FLOAT, value);
    }

    public Integer getDisplayMultipleFloatPathsEndingWithActivityUniqueID() {
        return (Integer)this.get(ProjectField.DISPLAY_MULTIPLE_FLOAT_PATHS_ENDING_WITH_ACTIVITY_UNIQUE_ID);
    }

    public void setDisplayMultipleFloatPathsEndingWithActivityUniqueID(Integer value) {
        this.set((FieldType)ProjectField.DISPLAY_MULTIPLE_FLOAT_PATHS_ENDING_WITH_ACTIVITY_UNIQUE_ID, value);
    }

    public boolean getLimitNumberOfFloatPathsToCalculate() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.LIMIT_NUMBER_OF_FLOAT_PATHS_TO_CALCULATE));
    }

    public void setLimitNumberOfFloatPathsToCalculate(boolean value) {
        this.set((FieldType)ProjectField.LIMIT_NUMBER_OF_FLOAT_PATHS_TO_CALCULATE, value);
    }

    public Integer getMaximumNumberOfFloatPathsToCalculate() {
        return (Integer)this.get(ProjectField.MAXIMUM_NUMBER_OF_FLOAT_PATHS_TO_CALCULATE);
    }

    public void setSchedulingProgressedActivities(SchedulingProgressedActivities value) {
        this.set((FieldType)ProjectField.SCHEDULING_PROGRESSED_ACTIVITIES, (Object)value);
    }

    public SchedulingProgressedActivities getSchedulingProgressedActivities() {
        return (SchedulingProgressedActivities)((Object)this.get(ProjectField.SCHEDULING_PROGRESSED_ACTIVITIES));
    }

    public void setMaximumNumberOfFloatPathsToCalculate(Integer value) {
        this.set((FieldType)ProjectField.MAXIMUM_NUMBER_OF_FLOAT_PATHS_TO_CALCULATE, value);
    }

    public String getBaselineTypeName() {
        return (String)this.get(ProjectField.BASELINE_TYPE_NAME);
    }

    public void setBaselineTypeName(String value) {
        this.set((FieldType)ProjectField.BASELINE_TYPE_NAME, value);
    }

    public Integer getBaselineTypeUniqueID() {
        return (Integer)this.get(ProjectField.BASELINE_TYPE_UNIQUE_ID);
    }

    public void setBaselineTypeUniqueID(Integer value) {
        this.set((FieldType)ProjectField.BASELINE_TYPE_UNIQUE_ID, value);
    }

    public LocalDateTime getLastBaselineUpdateDate() {
        return (LocalDateTime)this.get(ProjectField.LAST_BASELINE_UPDATE_DATE);
    }

    public void setLastBaselineUpdateDate(LocalDateTime value) {
        this.set((FieldType)ProjectField.LAST_BASELINE_UPDATE_DATE, value);
    }

    public String getActivityIdPrefix() {
        return (String)this.get(ProjectField.ACTIVITY_ID_PREFIX);
    }

    public void setActivityIdPrefix(String value) {
        this.set((FieldType)ProjectField.ACTIVITY_ID_PREFIX, value);
    }

    public Integer getActivityIdSuffix() {
        return (Integer)this.get(ProjectField.ACTIVITY_ID_SUFFIX);
    }

    public void setActivityIdSuffix(Integer value) {
        this.set((FieldType)ProjectField.ACTIVITY_ID_SUFFIX, value);
    }

    public Integer getActivityIdIncrement() {
        return (Integer)this.get(ProjectField.ACTIVITY_ID_INCREMENT);
    }

    public void setActivityIdIncrement(Integer value) {
        this.set((FieldType)ProjectField.ACTIVITY_ID_INCREMENT, value);
    }

    public boolean getActivityIdIncrementBasedOnSelectedActivity() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.ACTIVITY_ID_INCREMENT_BASED_ON_SELECTED_ACTIVITY));
    }

    public void setActivityIdIncrementBasedOnSelectedActivity(boolean value) {
        this.set((FieldType)ProjectField.ACTIVITY_ID_INCREMENT_BASED_ON_SELECTED_ACTIVITY, value);
    }

    public String getBaselineCalendarName() {
        return (String)this.get(ProjectField.BASELINE_CALENDAR_NAME);
    }

    public void setBaselineCalendarName(String value) {
        this.set((FieldType)ProjectField.BASELINE_CALENDAR_NAME, value);
    }

    public boolean getProjectIsBaseline() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.PROJECT_IS_BASELINE));
    }

    public void setProjectIsBaseline(boolean value) {
        this.set((FieldType)ProjectField.PROJECT_IS_BASELINE, value);
    }

    public String getProjectWebsiteUrl() {
        return (String)this.get(ProjectField.PROJECT_WEBSITE_URL);
    }

    public String getNotes() {
        Object notes = this.get(TaskField.NOTES);
        return notes == null ? "" : notes.toString();
    }

    public void setNotes(String notes) {
        this.set((FieldType)TaskField.NOTES, notes == null ? null : new Notes(notes));
    }

    public Notes getNotesObject() {
        return (Notes)this.get(TaskField.NOTES);
    }

    public void setNotesObject(Notes notes) {
        this.set((FieldType)TaskField.NOTES, notes);
    }

    public void setProjectWebsiteUrl(String value) {
        this.set((FieldType)ProjectField.PROJECT_WEBSITE_URL, value);
    }

    public Map<ProjectCode, ProjectCodeValue> getProjectCodeValues() {
        return (Map)this.get(ProjectField.PROJECT_CODE_VALUES);
    }

    public void addProjectCodeValue(ProjectCodeValue value) {
        ((Map)this.get(ProjectField.PROJECT_CODE_VALUES)).put(value.getParentCode(), value);
    }

    public boolean getEnablePublication() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.ENABLE_PUBLICATION));
    }

    public void setEnablePublication(boolean value) {
        this.set((FieldType)ProjectField.ENABLE_PUBLICATION, value);
    }

    public boolean getEnableSummarization() {
        return BooleanHelper.getBoolean((Boolean)this.get(ProjectField.ENABLE_SUMMARIZATION));
    }

    public void setEnableSummarization(boolean value) {
        this.set((FieldType)ProjectField.ENABLE_SUMMARIZATION, value);
    }

    private ProjectField selectField(ProjectField[] fields, int index) {
        if (index < 1 || index > fields.length) {
            throw new IllegalArgumentException(index + " is not a valid field index");
        }
        return fields[index - 1];
    }

    @Override
    void handleFieldChange(FieldType field, Object oldValue, Object newValue) {
    }

    @Override
    boolean getAlwaysCalculatedField(FieldType field) {
        return false;
    }

    @Override
    Function<ProjectProperties, Object> getCalculationMethod(FieldType field) {
        return CALCULATED_FIELD_MAP.get(field);
    }

    public Set<FieldType> getPopulatedFields() {
        return new PopulatedFields<ProjectField, ProjectProperties>(this.getParentFile(), ProjectField.class, this.getParentFile().getUserDefinedFields().getProjectFields(), Collections.singletonList(this)).getPopulatedFields();
    }

    private void set(FieldType field, boolean value) {
        this.set(field, value ? Boolean.TRUE : Boolean.FALSE);
    }

    private LocalDateTime calculateStartDate() {
        return this.getParentFile().getEarliestStartDate();
    }

    private LocalDateTime calculateFinishDate() {
        return this.getParentFile().getLatestFinishDate();
    }

    private LocalDateTime calculateActualStart() {
        return this.getParentFile().getActualStart();
    }

    private LocalDateTime calculateActualFinish() {
        return this.getParentFile().getActualFinish();
    }

    private Integer calculateMinutesPerWeek() {
        return 5 * NumberHelper.getInt(this.getMinutesPerDay());
    }

    private Integer calculateMinutesPerMonth() {
        return NumberHelper.getInt(this.getMinutesPerDay()) * NumberHelper.getInt(this.getDaysPerMonth());
    }

    private Integer calculateMinutesPerYear() {
        return NumberHelper.getInt(this.getMinutesPerDay()) * NumberHelper.getInt(this.getDaysPerMonth()) * 12;
    }

    static {
        CALCULATED_FIELD_MAP.put(ProjectField.START_DATE, ProjectProperties::calculateStartDate);
        CALCULATED_FIELD_MAP.put(ProjectField.FINISH_DATE, ProjectProperties::calculateFinishDate);
        CALCULATED_FIELD_MAP.put(ProjectField.ACTUAL_START, ProjectProperties::calculateActualStart);
        CALCULATED_FIELD_MAP.put(ProjectField.ACTUAL_FINISH, ProjectProperties::calculateActualFinish);
        CALCULATED_FIELD_MAP.put(ProjectField.MINUTES_PER_WEEK, ProjectProperties::calculateMinutesPerWeek);
        CALCULATED_FIELD_MAP.put(ProjectField.MINUTES_PER_MONTH, ProjectProperties::calculateMinutesPerMonth);
        CALCULATED_FIELD_MAP.put(ProjectField.MINUTES_PER_YEAR, ProjectProperties::calculateMinutesPerYear);
        CALCULATED_FIELD_MAP.put(ProjectField.DAYS_PER_MONTH, p -> DEFAULT_DAYS_PER_MONTH);
        CALCULATED_FIELD_MAP.put(ProjectField.MINUTES_PER_DAY, p -> DEFAULT_MINUTES_PER_DAY);
        CALCULATED_FIELD_MAP.put(ProjectField.DATE_SEPARATOR, p -> Character.valueOf('/'));
        CALCULATED_FIELD_MAP.put(ProjectField.TIME_SEPARATOR, p -> Character.valueOf(':'));
        CALCULATED_FIELD_MAP.put(ProjectField.THOUSANDS_SEPARATOR, p -> Character.valueOf(','));
        CALCULATED_FIELD_MAP.put(ProjectField.DECIMAL_SEPARATOR, p -> Character.valueOf('.'));
        CALCULATED_FIELD_MAP.put(ProjectField.MPX_DELIMITER, p -> Character.valueOf(','));
        CALCULATED_FIELD_MAP.put(ProjectField.CUSTOM_PROPERTIES, p -> new HashMap());
        CALCULATED_FIELD_MAP.put(ProjectField.WBS_CODE_SEPARATOR, p -> ".");
        CALCULATED_FIELD_MAP.put(ProjectField.CONSIDER_ASSIGNMENTS_IN_OTHER_PROJECTS, p -> Boolean.FALSE);
        CALCULATED_FIELD_MAP.put(ProjectField.CONSIDER_ASSIGNMENTS_IN_OTHER_PROJECTS_WITH_PRIORITY_EQUAL_HIGHER_THAN, p -> DEFAULT_OTHER_PROJECT_ASSIGNMENT_PRIORITY);
        CALCULATED_FIELD_MAP.put(ProjectField.PRESERVE_SCHEDULED_EARLY_AND_LATE_DATES, p -> Boolean.TRUE);
        CALCULATED_FIELD_MAP.put(ProjectField.LEVEL_ALL_RESOURCES, p -> Boolean.TRUE);
        CALCULATED_FIELD_MAP.put(ProjectField.LEVEL_RESOURCES_ONLY_WITHIN_ACTIVITY_TOTAL_FLOAT, p -> Boolean.FALSE);
        CALCULATED_FIELD_MAP.put(ProjectField.PRESERVE_MINIMUM_FLOAT_WHEN_LEVELING, p -> DEFAULT_MINIMUM_FLOAT);
        CALCULATED_FIELD_MAP.put(ProjectField.MAX_PERCENT_TO_OVERALLOCATE_RESOURCES, p -> DEFAULT_OVERALLOCATION);
        CALCULATED_FIELD_MAP.put(ProjectField.LEVELING_PRIORITIES, p -> "(0||priority_type(sort_type|ASC)())");
        CALCULATED_FIELD_MAP.put(ProjectField.DATA_DATE_AND_PLANNED_START_SET_TO_PROJECT_FORECAST_START, p -> Boolean.FALSE);
        CALCULATED_FIELD_MAP.put(ProjectField.IGNORE_RELATIONSHIPS_TO_AND_FROM_OTHER_PROJECTS, p -> Boolean.FALSE);
        CALCULATED_FIELD_MAP.put(ProjectField.MAKE_OPEN_ENDED_ACTIVITIES_CRITICAL, p -> Boolean.FALSE);
        CALCULATED_FIELD_MAP.put(ProjectField.USE_EXPECTED_FINISH_DATES, p -> Boolean.TRUE);
        CALCULATED_FIELD_MAP.put(ProjectField.COMPUTE_START_TO_START_LAG_FROM_EARLY_START, p -> Boolean.TRUE);
        CALCULATED_FIELD_MAP.put(ProjectField.CALCULATE_FLOAT_BASED_ON_FINISH_DATE_OF_EACH_PROJECT, p -> Boolean.TRUE);
        CALCULATED_FIELD_MAP.put(ProjectField.CALCULATE_MULTIPLE_FLOAT_PATHS, p -> Boolean.FALSE);
        CALCULATED_FIELD_MAP.put(ProjectField.CALCULATE_MULTIPLE_FLOAT_PATHS_USING_TOTAL_FLOAT, p -> Boolean.TRUE);
        CALCULATED_FIELD_MAP.put(ProjectField.LIMIT_NUMBER_OF_FLOAT_PATHS_TO_CALCULATE, p -> Boolean.TRUE);
        CALCULATED_FIELD_MAP.put(ProjectField.MAXIMUM_NUMBER_OF_FLOAT_PATHS_TO_CALCULATE, p -> DEFAULT_FLOAT_PATHS);
        CALCULATED_FIELD_MAP.put(ProjectField.SCHEDULING_PROGRESSED_ACTIVITIES, p -> SchedulingProgressedActivities.RETAINED_LOGIC);
        CALCULATED_FIELD_MAP.put(ProjectField.ACTIVITY_ID_PREFIX, p -> "A");
        CALCULATED_FIELD_MAP.put(ProjectField.ACTIVITY_ID_SUFFIX, p -> 1000);
        CALCULATED_FIELD_MAP.put(ProjectField.ACTIVITY_ID_INCREMENT, p -> 10);
        CALCULATED_FIELD_MAP.put(ProjectField.ACTIVITY_ID_INCREMENT_BASED_ON_SELECTED_ACTIVITY, p -> Boolean.TRUE);
        CALCULATED_FIELD_MAP.put(ProjectField.PROJECT_IS_BASELINE, p -> Boolean.FALSE);
        CALCULATED_FIELD_MAP.put(ProjectField.PROJECT_CODE_VALUES, p -> new HashMap());
    }
}

