/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import org.mpxj.Duration;
import org.mpxj.ProjectConfig;
import org.mpxj.ProjectEntityWithMutableUniqueID;
import org.mpxj.ProjectFile;
import org.mpxj.RelationType;
import org.mpxj.Task;
import org.mpxj.TimeUnit;

public final class Relation
implements ProjectEntityWithMutableUniqueID {
    private Integer m_uniqueID;
    private final Task m_predecessorTask;
    private final Task m_successorTask;
    private final RelationType m_type;
    private final Duration m_lag;
    private final String m_notes;

    private Relation(Builder builder) {
        ProjectFile project;
        ProjectConfig projectConfig;
        this.m_predecessorTask = builder.m_predecessorTask;
        this.m_successorTask = builder.m_successorTask;
        this.m_type = builder.m_type == null ? RelationType.FINISH_START : builder.m_type;
        this.m_lag = builder.m_lag == null ? Duration.getInstance(0, TimeUnit.DAYS) : builder.m_lag;
        this.m_notes = builder.m_notes;
        Integer uniqueID = builder.m_uniqueID;
        if (uniqueID == null && (projectConfig = (project = this.m_successorTask.getParentFile()).getProjectConfig()).getAutoRelationUniqueID()) {
            uniqueID = project.getUniqueIdObjectSequence(Relation.class).getNext();
        }
        if (uniqueID != null) {
            this.m_successorTask.getParentFile().getRelations().updateUniqueID(this, this.m_uniqueID, uniqueID);
            this.m_uniqueID = uniqueID;
        }
    }

    public RelationType getType() {
        return this.m_type;
    }

    public Duration getLag() {
        return this.m_lag;
    }

    public Task getPredecessorTask() {
        return this.m_predecessorTask;
    }

    public Task getSuccessorTask() {
        return this.m_successorTask;
    }

    @Override
    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    @Override
    public void setUniqueID(Integer uniqueID) {
        this.m_successorTask.getParentFile().getRelations().updateUniqueID(this, this.m_uniqueID, uniqueID);
        this.m_uniqueID = uniqueID;
    }

    public String getNotes() {
        return this.m_notes;
    }

    public String toString() {
        return "[Relation lag: " + this.m_lag + " type: " + this.m_type + " " + this.m_predecessorTask + " -> " + this.m_successorTask + "]";
    }

    public static class Builder {
        Integer m_uniqueID;
        Task m_predecessorTask;
        Task m_successorTask;
        RelationType m_type = RelationType.FINISH_START;
        Duration m_lag = Duration.getInstance(0, TimeUnit.DAYS);
        String m_notes;

        public Builder from(Relation value) {
            this.m_uniqueID = value.m_uniqueID;
            this.m_predecessorTask = value.m_predecessorTask;
            this.m_successorTask = value.m_successorTask;
            this.m_type = value.m_type;
            this.m_lag = value.m_lag;
            this.m_notes = value.m_notes;
            return this;
        }

        public Builder uniqueID(Integer value) {
            this.m_uniqueID = value;
            return this;
        }

        public Builder predecessorTask(Task value) {
            this.m_predecessorTask = value;
            return this;
        }

        public Builder successorTask(Task value) {
            this.m_successorTask = value;
            return this;
        }

        public Builder type(RelationType value) {
            this.m_type = value;
            return this;
        }

        public Builder lag(Duration value) {
            this.m_lag = value;
            return this;
        }

        public Builder notes(String value) {
            this.m_notes = value;
            return this;
        }

        public Relation build() {
            return new Relation(this);
        }
    }
}

