/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.mpxj.Code;
import org.mpxj.ResourceAssignmentCodeValue;
import org.mpxj.UniqueIdObjectSequenceProvider;

public final class ResourceAssignmentCode
implements Code {
    private final Integer m_uniqueID;
    private final Integer m_sequenceNumber;
    private final String m_name;
    private final boolean m_secure;
    private final Integer m_maxLength;
    private final List<ResourceAssignmentCodeValue> m_values = new ArrayList<ResourceAssignmentCodeValue>();

    private ResourceAssignmentCode(Builder builder) {
        this.m_uniqueID = builder.m_sequenceProvider.getUniqueIdObjectSequence(ResourceAssignmentCode.class).syncOrGetNext(builder.m_uniqueID);
        this.m_sequenceNumber = builder.m_sequenceNumber;
        this.m_name = builder.m_name;
        this.m_secure = builder.m_secure;
        this.m_maxLength = builder.m_maxLength;
    }

    @Override
    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    @Override
    public Integer getSequenceNumber() {
        return this.m_sequenceNumber;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public boolean getSecure() {
        return this.m_secure;
    }

    @Override
    public Integer getMaxLength() {
        return this.m_maxLength;
    }

    public List<ResourceAssignmentCodeValue> getValues() {
        return this.m_values;
    }

    public List<ResourceAssignmentCodeValue> getChildValues() {
        return this.m_values.stream().filter(v -> v.getParentValue() == null).collect(Collectors.toList());
    }

    public void addValue(ResourceAssignmentCodeValue value) {
        this.m_values.add(value);
    }

    public ResourceAssignmentCodeValue getValueByUniqueID(Integer id) {
        if (id == null) {
            return null;
        }
        return this.m_values.stream().filter(v -> v.getUniqueID().intValue() == id.intValue()).findFirst().orElse(null);
    }

    public static class Builder {
        private final UniqueIdObjectSequenceProvider m_sequenceProvider;
        private Integer m_uniqueID;
        private Integer m_sequenceNumber;
        private String m_name;
        private boolean m_secure;
        private Integer m_maxLength;

        public Builder(UniqueIdObjectSequenceProvider sequenceProvider) {
            this.m_sequenceProvider = sequenceProvider;
        }

        public Builder from(ResourceAssignmentCode value) {
            this.m_uniqueID = value.m_uniqueID;
            this.m_sequenceNumber = value.m_sequenceNumber;
            this.m_name = value.m_name;
            this.m_secure = value.m_secure;
            this.m_maxLength = value.m_maxLength;
            return this;
        }

        public Builder uniqueID(Integer value) {
            this.m_uniqueID = value;
            return this;
        }

        public Builder sequenceNumber(Integer value) {
            this.m_sequenceNumber = value;
            return this;
        }

        public Builder name(String value) {
            this.m_name = value;
            return this;
        }

        public Builder secure(boolean value) {
            this.m_secure = value;
            return this;
        }

        public Builder maxLength(Integer value) {
            this.m_maxLength = value;
            return this;
        }

        public ResourceAssignmentCode build() {
            return new ResourceAssignmentCode(this);
        }
    }
}

