/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mpxj.CustomField;
import org.mpxj.FieldType;
import org.mpxj.FieldTypeClass;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectEntityWithIDContainer;
import org.mpxj.ProjectFile;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceField;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.PopulatedFields;

public class ResourceContainer
extends ProjectEntityWithIDContainer<Resource> {
    private final ProjectFile m_projectFile;

    public ResourceContainer(ProjectFile projectFile) {
        super(projectFile);
        this.m_projectFile = projectFile;
    }

    @Override
    public void removed(Resource resource) {
        super.removed(resource);
        this.m_idMap.remove(resource.getID());
        Resource parentResource = resource.getParentResource();
        if (parentResource != null) {
            parentResource.removeChildResource(resource);
        } else {
            this.m_projectFile.getChildResources().remove(resource);
        }
        Iterator iter = this.m_projectFile.getResourceAssignments().iterator();
        Integer resourceUniqueID = resource.getUniqueID();
        while (iter.hasNext()) {
            ResourceAssignment assignment = (ResourceAssignment)iter.next();
            if (!NumberHelper.equals(assignment.getResourceUniqueID(), resourceUniqueID)) continue;
            assignment.getTask().removeResourceAssignment(assignment);
            iter.remove();
        }
        ProjectCalendar calendar = resource.getCalendar();
        if (calendar != null) {
            calendar.remove();
        }
    }

    public Resource add() {
        Resource resource = new Resource(this.m_projectFile);
        this.add(resource);
        this.m_projectFile.getChildResources().add(resource);
        return resource;
    }

    void updateStructure() {
        if (this.size() > 1) {
            this.m_projectFile.getChildResources().clear();
            this.forEach(r -> r.getChildResources().clear());
            this.forEach(r -> {
                Resource parent = r.getParentResource();
                if (parent == null) {
                    this.m_projectFile.getChildResources().add((Resource)r);
                } else {
                    parent.addChildResource((Resource)r);
                }
            });
        }
    }

    public Set<FieldType> getPopulatedFields() {
        return new PopulatedFields<ResourceField, Resource>(this.m_projectFile, ResourceField.class, this.m_projectFile.getUserDefinedFields().getResourceFields(), this).getPopulatedFields();
    }

    public List<CustomField> getCustomFields() {
        return this.m_projectFile.getCustomFields().getCustomFieldsByFieldTypeClass(FieldTypeClass.RESOURCE);
    }

    public FieldType getFieldTypeByAlias(String alias) {
        return this.m_projectFile.getCustomFields().getFieldTypeByAlias(FieldTypeClass.RESOURCE, alias);
    }
}

