/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.mpxj.ProjectEntityWithUniqueID;
import org.mpxj.ShiftPeriod;
import org.mpxj.UniqueIdObjectSequenceProvider;

public final class Shift
implements ProjectEntityWithUniqueID {
    private final Integer m_uniqueID;
    private final String m_name;
    private final Set<ShiftPeriod> m_periods = new TreeSet<ShiftPeriod>();

    private Shift(Builder builder) {
        this.m_uniqueID = builder.m_sequenceProvider.getUniqueIdObjectSequence(Shift.class).syncOrGetNext(builder.m_uniqueID);
        this.m_name = builder.m_name;
    }

    @Override
    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public String getName() {
        return this.m_name;
    }

    public Collection<ShiftPeriod> getPeriods() {
        return this.m_periods;
    }

    public static class Builder {
        private final UniqueIdObjectSequenceProvider m_sequenceProvider;
        private Integer m_uniqueID;
        private String m_name;

        public Builder(UniqueIdObjectSequenceProvider sequenceProvider) {
            this.m_sequenceProvider = sequenceProvider;
        }

        public Builder uniqueID(Integer value) {
            this.m_uniqueID = value;
            return this;
        }

        public Builder name(String value) {
            this.m_name = value;
            return this;
        }

        public Shift build() {
            return new Shift(this);
        }
    }
}

