/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import org.mpxj.Duration;
import org.mpxj.ProjectEntityWithUniqueID;
import org.mpxj.Shift;
import org.mpxj.TimeUnit;
import org.mpxj.UniqueIdObjectSequenceProvider;

public final class ShiftPeriod
implements ProjectEntityWithUniqueID,
Comparable<ShiftPeriod> {
    private final Integer m_uniqueID;
    private final Shift m_parentShift;
    private final LocalTime m_start;

    private ShiftPeriod(Builder builder) {
        this.m_uniqueID = builder.m_sequenceProvider.getUniqueIdObjectSequence(ShiftPeriod.class).syncOrGetNext(builder.m_uniqueID);
        this.m_start = builder.m_start;
        this.m_parentShift = builder.m_shift;
        this.m_parentShift.getPeriods().add(this);
    }

    public Shift getParentShift() {
        return this.m_parentShift;
    }

    @Override
    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public LocalTime getStart() {
        return this.m_start;
    }

    public Duration getDuration() {
        LocalTime nextStart = this.m_parentShift.getPeriods().stream().filter(p -> p.m_start.isAfter(this.m_start)).findFirst().map(p -> p.m_start).orElse(LocalTime.MIDNIGHT);
        long hours = this.m_start.until(nextStart, ChronoUnit.HOURS);
        if (hours < 0L) {
            hours = 24L + hours;
        }
        return Duration.getInstance(hours, TimeUnit.HOURS);
    }

    @Override
    public int compareTo(ShiftPeriod o) {
        return this.m_start.compareTo(o.m_start);
    }

    public static class Builder {
        private final UniqueIdObjectSequenceProvider m_sequenceProvider;
        private final Shift m_shift;
        private Integer m_uniqueID;
        private LocalTime m_start;

        public Builder(UniqueIdObjectSequenceProvider sequenceProvider, Shift shift) {
            this.m_sequenceProvider = sequenceProvider;
            this.m_shift = shift;
        }

        public Builder uniqueID(Integer value) {
            this.m_uniqueID = value;
            return this;
        }

        public Builder start(LocalTime value) {
            this.m_start = value;
            return this;
        }

        public Builder start(Integer value) {
            this.m_start = LocalTime.of(value, 0);
            return this;
        }

        public ShiftPeriod build() {
            return new ShiftPeriod(this);
        }
    }
}

